package com.bcxin.ars.dao;

import java.util.Date;
import java.util.List;

import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import com.bcxin.ars.model.Organization;
import com.bcxin.ars.model.Role;
import com.bcxin.ars.model.SecurityCompany;
import com.bcxin.ars.model.SecurityCompanyPerson;
import com.bcxin.ars.model.SecurityPerson;

@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations = { "classpath:/ars-dao.xml" })
//@Transactional
//@TransactionConfiguration(transactionManager = "txManager", defaultRollback = true)
public class SecurityCompanyPersonDaoTest {
	
	@Autowired
	private SecurityCompanyPersonDao securityCompanyPersonDao;
	
	@Test
	@Ignore
	public void test() {
		SecurityCompany company = new SecurityCompany();
		company.setId(62l);
		SecurityPerson person = new SecurityPerson();
		person.setId(7l);
		Organization org = new Organization();
		org.setId(64l);
		Role role = new Role();
		role.setId(18l);
		SecurityCompanyPerson companyPerson = new SecurityCompanyPerson();
		companyPerson.setActive(true);;
		companyPerson.setCompany(company);
		companyPerson.setPerson(person);
		companyPerson.setNativeCode(11l);
		companyPerson.setOrg(org);
//		companyPerson.setRole(role);
		companyPerson.setCreateTime(new Date());
		companyPerson.setUpdateTime(new Date());
		companyPerson.setUpdateBy("ut");
		securityCompanyPersonDao.save(companyPerson);
		SecurityCompanyPerson result = securityCompanyPersonDao.findByPersonId(person.getId());
		Assert.assertNotNull(result);
		Assert.assertNotNull(result.getCompany());
		Assert.assertNotNull(result.getOrg());
//		Assert.assertNotNull(result.getRole());
		Assert.assertNotNull(result.getPerson());
		securityCompanyPersonDao.delete(result);
		SecurityCompanyPerson r = securityCompanyPersonDao.findByPersonId(person.getId());
		Assert.assertNull(r);
	}
	
	@Test
	public void testFindByX() {
		List<SecurityCompanyPerson> data1 = securityCompanyPersonDao.findByOrgId(71l);
		Assert.assertTrue(data1.size() > 0);
		List<SecurityCompanyPerson> data2 = securityCompanyPersonDao.findByRoleId(19l);
		Assert.assertTrue(data2.size() > 0);
	}
	
}
