package com.bcxin.ars.dao.sb;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.model.sb.GradeSubsidyBatchRoster;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 *等级证补贴批次关联花名册Dao
 * @author linqinglin
 * @Date 2020-05-20 09:11:59
 */
public interface GradeSubsidyBatchRosterDao {

   /****
     * 删除
     * @param gradeSubsidyBatchRoster
     * @return
     */
    int delete(GradeSubsidyBatchRoster gradeSubsidyBatchRoster);

    /****
     * 保存
     * @param gradeSubsidyBatchRoster
     * @return
     */
    int save(GradeSubsidyBatchRoster gradeSubsidyBatchRoster);

    /****
     * 主键查询
     * @param id
     * @return
     */
    GradeSubsidyBatchRoster findById(Long id);

    GradeSubsidyBatchRoster findByIdWithOutCache(Long id);

    /**
     * 外导内查询
     * @param searchDto
     * @return
     */
    List<GradeSubsidyBatchRoster> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

    /**
     * 内导外查询
     * @param startDate
     * @return
     */
    List<GradeSubsidyBatchRoster> findDSOutList(String startDate);

    /**
     * 批量保存
     * @param list
     */
    void saveBatch(@Param("list") List<GradeSubsidyBatchRoster> list);

 /**
     * 批量查询
     * @param list
     * @return
     */
    List<GradeSubsidyBatchRoster> findByBatchId(@Param("list") List<GradeSubsidyBatchRoster> list);

    List<GradeSubsidyBatchRoster> findByBatchIdWithOutCache(@Param("list") List<GradeSubsidyBatchRoster> list);

    GradeSubsidyBatchRoster findByRosterId(Long rosterId);
}
