package com.bcxin.ars.dao.sb;

import com.bcxin.ars.dto.ActivityRepairApprovalDto;
import com.bcxin.ars.dto.ActivityRepairApprovalSearchDto;
import com.bcxin.ars.dto.ActivityRepairDto;
import com.bcxin.ars.model.sb.Personcertificate;
import com.bcxin.ars.model.sys.Approval;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;

import java.util.List;
import java.util.Map;

/**
 * 流程修复
 *
 * @author linqinglin
 * @date 2018/09/26 0026 9:14
 */
public interface ActivityRepairDao {

    /**
     * 跳流程
     *
     * @param activityRepairDto
     */
    void skipProcess(ActivityRepairDto activityRepairDto);

    /**
     * 流程打回
     *
     * @param personIds
     */
    void batchRepulse(Long[] personIds);

    /**
     * @return void
     * @Decription:
     * @author：zhongjianhui
     * @method batchRepulseAndNotFeeState
     * @date：2018/12/12 14:37
     * @params： * @param personIds
     */
    void batchRepulseAndNotFeeState(Long[] personIds);

    List<Map<Object, Object>> searchApprovalList(Map<Object, Object> p);

    /**
     * @return java.util.List<java.util.Map>
     * @Decription:返回不可流程打回 人的姓名和身份证号
     * @author：zhongjianhui
     * @method checkReturn
     * @date：2018/12/6 15:32
     * @params： * @param perIds
     */
    List<Personcertificate> checkReturn(Long[] perIds);


    /**
     * @return java.util.List<java.util.Map>
     * @Decription:返回不可流程打回 人的姓名和身份证号(用于北京)
     * @author：zhongjianhui
     * @method checkReturn
     * @date：2018/12/6 15:32
     * @params： * @param perIds
     */
    List<Personcertificate> checkReturnForBJ(Long[] perIds);
    /**
     * @return java.util.List<java.util.Map>
     * @Decription:返回不可流程打回 人的姓名和身份证号(用于陕西)
     * @author：zhongjianhui
     * @method checkReturn
     * @date：2018/12/6 15:32
     * @params： * @param perIds
     */
    List<Personcertificate> checkReturnForSn(Long[] perIds);

    /**
     * @return java.util.List<java.util.Map>
     * @Decription:返回不可流程打回 人的姓名和身份证号(用于广西)
     * @author：zhongjianhui
     * @method checkReturn
     * @date：2018/12/6 15:32
     * @params： * @param perIds
     */
    List<Personcertificate> checkReturnForGx(Long[] perIds);
    /**
     * @return java.util.List<java.util.Map>
     * @Decription:返回不可流程打回 人的姓名和身份证号(用于宁夏)
     * @author：zhongjianhui
     * @method checkReturn
     * @date：2018/12/6 15:32
     * @params： * @param perIds
     */
    List<Personcertificate> checkReturnForNx(Long[] perIds);

    /**
     * @return java.util.List<java.util.Map>
     * @Decription:返回可流程打回的 id
     * @author：zhongjianhui
     * @method checkReturn
     * @date：2018/12/6 15:32
     * @params： * @param perIds
     */
    List<Long> checkCanReturnPerson(Long[] perIds);

    Integer searchApprovalListCount(Map<Object, Object> p);

    void repulseProcess(Approval approval);

    void updateApprovalState(Approval approval);

    /***
     * 审批流程修复查询
     * @param dto 查询条件参数
     * @param ajaxPageResponse 返回数据对象
     * @return 查询列表
     */
    List<Approval> search(ActivityRepairApprovalSearchDto dto, AjaxPageResponse<ActivityRepairApprovalDto> ajaxPageResponse);
}
