package com.bcxin.ars.dao;

import com.bcxin.ars.model.ProblemLog;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 背景筛查问题记录Dao接口
 * 
 * @author linqinglin
 * @date 2021-03-12
 */
public interface ProblemLogDao{

    /****
     * 删除
     * @param problemLog
     * @return
     */
    int delete(ProblemLog problemLog);

    /****
     * 保存
     * @param problemLog
     * @return
     */
    int save(ProblemLog problemLog);

    /****
     * 主键查询
     * @param id
     * @return
     */
     ProblemLog findById(Long id);

    /****
     * 选择修改
     * @param problemLog
     * @return
     */
    int updateSelective(ProblemLog problemLog);

    /**
     * 批量保存
     * @param list
     */
    void saveBatch(@Param("list") List<ProblemLog> list);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<ProblemLog> findByBatchId(@Param("list") List<ProblemLog> list);


    List<ProblemLog> findUnCensor();
}
