package com.bcxin.ars.dao;

import com.bcxin.ars.dto.sb.CyCheckSearchDto;
import com.bcxin.ars.model.CyCheck;

import java.util.List;

public interface CyCheckDao {
    /**
     * 查询
     *
     * @param cyCheckSearchDto
     * @return
     */
    List<CyCheck> search(CyCheckSearchDto cyCheckSearchDto);

    /**
     * 保存
     *
     * @param cyCheck
     * @return
     */
    Long save(CyCheck cyCheck);

    /**
     * 删除
     *
     * @param cyCheck
     * @return
     */
    Long delete(CyCheck cyCheck);


    /**
     * 根据ID查询
     *
     * @return
     */
    CyCheck findById(Long id);

    /**
     * 统计
     *
     * @return
     */
    long count(CyCheckSearchDto cyCheckSearchDto);

    /**
     * 更新监督检查情况
     *
     * @param cyCheck
     */
    void update(CyCheck cyCheck);


    List<CyCheck> searchForExportData(CyCheckSearchDto dto);

    Long saveForDS(CyCheck cyCheck);
}
