

DROP TABLE IF EXISTS `ministerial_log`;
CREATE TABLE `ministerial_log` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `active` bit(1) DEFAULT b'1' COMMENT '是否可用',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `businessType` varchar(100) DEFAULT NULL COMMENT '业务类型',
  `businessId` bigint(20) DEFAULT NULL COMMENT '业务主键id',
  `state` char(5) DEFAULT '0' COMMENT '上报状态 0上报失败 1 上报成功',
  `serialNo` varchar(50) DEFAULT NULL COMMENT '交易流水号',
  PRIMARY KEY (`id`),
  KEY `index_businessId` (`businessId`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='数据上报部级接口记录';


#20210312 背景筛查问题记录 目前 管理层及股东用

DROP TABLE IF EXISTS `problem_log`;
CREATE TABLE `problem_log` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `active` bit(1) DEFAULT b'1' COMMENT '是否可用',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `businessType` varchar(100) DEFAULT NULL COMMENT '业务类型',
  `name` varchar(100) DEFAULT NULL COMMENT '姓名',
  `idnum` varchar(20) DEFAULT NULL COMMENT '身份证号',
  `businessId` bigint(20) DEFAULT NULL COMMENT '业务主键id',
  `problemType` char(5) DEFAULT '0' COMMENT '问题类型',
  `problem` varchar(100) DEFAULT '0' COMMENT '问题',
  `content` text DEFAULT NULL COMMENT '违法犯罪详情',
  PRIMARY KEY (`id`),
  KEY `index_businessId` (`businessId`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='背景筛查问题记录';