
# 20201207 数据同步记录
DROP TABLE IF EXISTS `dataSync_log`;
CREATE TABLE `dataSync_log` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `active` bit(1) DEFAULT b'1' COMMENT '是否可用',
  `updateflag` bit(1) DEFAULT NULL COMMENT '更新标识',
  `intranet` bit(1) DEFAULT NULL COMMENT '是否内网',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `basePath` varchar(100) DEFAULT NULL COMMENT '基础路径',
  `filePath` varchar(200) DEFAULT NULL COMMENT '文件路径',
  `fileName` varchar(100) DEFAULT NULL COMMENT '文件名',
  `url` varchar(200) DEFAULT NULL COMMENT '访问路径',
  `businessType` varchar(6) DEFAULT NULL COMMENT '类型 0业务数据 1客户上传附件 2警官上传附件',
  `msgId` varchar(30) DEFAULT NULL COMMENT '同步返回id',
  `errorInfo` varchar(500) DEFAULT NULL COMMENT '同步失败消息',
  `dataSyncState` char(5) DEFAULT '0' COMMENT '同步状态 0未同步 1同步给ftp 2同步到内网',
  PRIMARY KEY (`id`)
)  COMMENT='数据同步记录';

# 20201209 抽查记录
DROP TABLE IF EXISTS `sb_per_check_record`;
CREATE TABLE `sb_per_check_record`(
  `id`          bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `active`      bit(1)       DEFAULT b'1' COMMENT '是否可用',
  `updateflag`  bit(1)       DEFAULT NULL COMMENT '更新标识',
  `create_time` datetime     DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime     DEFAULT NULL COMMENT '修改时间',
  `update_by`   varchar(50)  DEFAULT NULL COMMENT '修改者',
  `areaCode`    varchar(6)   DEFAULT NULL COMMENT '数据区域',
  `businessId`  bigint(20)   DEFAULT NULL COMMENT '业务id',
  `recordType`  varchar(10)  DEFAULT NULL COMMENT '记录类型 01 资格证 03 等级证',
  `checkState`  char(5)      DEFAULT NULL COMMENT '审查结果 1抽查合格 2抽查不合格 3待复核 ',
  `name`        varchar(20)  DEFAULT NULL COMMENT '姓名',
  `idNum`       varchar(18)  DEFAULT NULL COMMENT '身份证号',
  `phone`       varchar(20)  DEFAULT NULL COMMENT '手机号',
  `perId`       bigint(20)   DEFAULT NULL COMMENT '人员id',
  `comId`       bigint(20)   DEFAULT NULL COMMENT '公司id',
  `comName`     varchar(200) DEFAULT NULL COMMENT '公司名称',
  `trainId`     bigint(20)   DEFAULT NULL COMMENT '培训学校id',
  `trainName`   varchar(200) DEFAULT NULL COMMENT '培训学校名称',
  `checkTime`   varchar(50)     DEFAULT NULL COMMENT '抽查时间',
  `checkName`   varchar(200) DEFAULT NULL COMMENT '抽查人员名称',
  `userName` varchar(100) DEFAULT NULL COMMENT '抽查人员账号',
  `baseResult` char(5) DEFAULT NULL COMMENT '基本信息审查结果 1合格 0不合格',
  `baseOpinion` varchar(500) DEFAULT NULL COMMENT '基本信息审查意见',
  `studyResult` char(5) DEFAULT NULL COMMENT '学习照片审查结果 1合格 0不合格',
  `studyOpinion` varchar(500) DEFAULT NULL COMMENT '学习照片审查意见',
  `practiceResult` char(5) DEFAULT NULL COMMENT '实习信息审查结果 1合格 0不合格',
  `practiceOpinion` varchar(500) DEFAULT NULL COMMENT '实习信息审查意见',
  PRIMARY KEY (`id`)
)  COMMENT='抽查记录';
