
#20200716
#功能权限
DROP TABLE IF EXISTS `module_menu`;
CREATE TABLE `module_menu` (
  `id` bigint(20) NOT NULL COMMENT '功能ID',
  `active` bit(1) DEFAULT NULL COMMENT '是否有效',
  `createTime` datetime DEFAULT NULL COMMENT '创建时间',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` varchar(50) DEFAULT NULL COMMENT '修改人',
  `location` text COMMENT '菜单链接',
  `name` varchar(100) NOT NULL COMMENT '节点文本',
  `parentId` varchar(32) DEFAULT NULL COMMENT '父节点ID',
  `seq` int(10) DEFAULT NULL COMMENT '同级菜单中排序序号',
  `menuType` varchar(8) NOT NULL COMMENT '结点类型：0菜单1权限',
  `description` text COMMENT '功能的中文描述',
  `iconClass` varchar(500) DEFAULT NULL COMMENT '主界面图标class',
  `iconCls` varchar(500) DEFAULT NULL COMMENT '图标class',
  `permission` varchar(100) DEFAULT NULL COMMENT '权限标识',
  `parentIds` text COMMENT '父节点的id列表，如"100001/100020/100022/"，分别列出从根开始的编码',
  `uniqueId` varchar(200) DEFAULT NULL COMMENT '唯一标识id 页面跳转使用',
  `intranetFlag` varchar(5) DEFAULT NULL COMMENT '内外网标识 0外网 1内网 2内外网',
  `superAdmin` varchar(5) DEFAULT NULL COMMENT '是否超管可见 0否 1是',
  `platform` varchar(5) DEFAULT '1' COMMENT '平台角色 1公安 2企业 4自然人',
  `rankAuth`  varchar(5) NULL COMMENT '职级权限 0职级查询 1全部开放',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='功能权限表';



#公安权限表
DROP TABLE IF EXISTS `module_permission`;
CREATE TABLE `module_permission` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `active` bit(1) DEFAULT b'1' COMMENT '是否可用',
  `updateflag` bit(1) DEFAULT b'1' COMMENT '是否修改',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `update_by` varchar(50) DEFAULT NULL COMMENT '修改者',
  `roleId` bigint(20) DEFAULT NULL COMMENT '角色id',
  `moduleMenuId` bigint(20)DEFAULT NULL COMMENT '菜单权限id',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='公安权限';

ALTER TABLE `module_permission`
ADD INDEX `index_role_id` (`roleId`) USING BTREE ,
ADD INDEX `index_menu_id` (`moduleMenuId`) USING BTREE ;

#20200716 end









