
#等级证补贴花名册
DROP TABLE IF EXISTS `grade_subsidy_roster`;
CREATE TABLE `grade_subsidy_roster` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `active` bit(1) DEFAULT b'1' COMMENT '是否可用',
  `updateflag` bit(1) DEFAULT NULL COMMENT '更新标识',
  `used` bit(1) DEFAULT b'0' COMMENT '是否在批次审批中',
  `inAppraisal` bit(1) DEFAULT b'0' COMMENT '是否参加鉴定考试',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `update_by` varchar(50) DEFAULT NULL COMMENT '修改者',
  `areaCode` varchar(6) DEFAULT NULL COMMENT '数据区域',
	`gradeId` bigint(20) DEFAULT NULL COMMENT '报名id',
  `orgId` bigint(20) DEFAULT NULL COMMENT '机构id',
	`trainId` bigint(20) DEFAULT NULL COMMENT '培训机构id',
	`trainName` varchar(50) DEFAULT NULL COMMENT '培训机构名称',
	`companyId` bigint(20) DEFAULT NULL COMMENT '公司id',
	`companyName` varchar(50) DEFAULT NULL COMMENT '公司名称',
  `orgName` varchar(50) DEFAULT NULL COMMENT '机构名称',
  `name` varchar(20) DEFAULT NULL COMMENT '姓名',
  `idNum` varchar(18) DEFAULT NULL COMMENT '身份证号',
  `phone` varchar(20) DEFAULT NULL COMMENT '手机号',
  `sex` varchar(10) DEFAULT NULL COMMENT '性别',
  `residentNature` varchar(20) DEFAULT NULL COMMENT '户籍性质',
  `residentPlace` varchar(100) DEFAULT NULL COMMENT '户籍所在地',
  `contractStartTime` datetime DEFAULT NULL COMMENT '劳动合同起始时间',
  `contractEndTime` datetime DEFAULT NULL COMMENT '劳动合同结束时间',
  `subsidyType` varchar(20) DEFAULT NULL COMMENT '补贴政策类型',
  `subsidyPeopleType` varchar(20) DEFAULT NULL COMMENT '补贴对象类型（企业、培训机构',
  `socialCode` varchar(50) DEFAULT NULL COMMENT '统一社会信用代码',
  `trainProfession` varchar(20) DEFAULT NULL COMMENT '培训职业（工种）或项目',
  `trainGrade` varchar(20) DEFAULT NULL COMMENT '培训等级（一级、二级、三级、四级、五级、非等级）',
  `classHour` varchar(20) DEFAULT NULL COMMENT '培训课时',
  `certificateType` varchar(20) DEFAULT NULL COMMENT '证书类型（工种）或项目',
  `subsidyCerType` varchar(20) DEFAULT NULL COMMENT '补贴证书类型',
  `certificateNumber` varchar(50) DEFAULT NULL COMMENT '发证时间证书编号',
  `certificateProfession` varchar(20) DEFAULT NULL COMMENT '证书职业工种',
  `certificateGrade` varchar(20) DEFAULT NULL COMMENT '证书等级（一级、二级、三级、四级、五级、非等级）',
  `completeMoney` varchar(10) DEFAULT NULL COMMENT '结业补贴金额',
  `completeMoneyRate` varchar(10) DEFAULT NULL COMMENT '结业补贴比例',
  `appraisalMoney` varchar(10) DEFAULT NULL COMMENT '鉴定补贴金额',
  `appraisalMoneyRate` varchar(10) DEFAULT NULL COMMENT '鉴定补贴比例',
  `subsidyMoney` varchar(10) DEFAULT NULL COMMENT '补贴金额',
  `subsidyMoneyRate` varchar(10) DEFAULT NULL COMMENT '补贴比例',
  `remark` varchar(200) DEFAULT NULL COMMENT '备注',
  `subsidyStatus` varchar(10) DEFAULT NULL COMMENT '状态',
  `reason` varchar(200) DEFAULT NULL COMMENT '原因',
  `completeCerNo` varchar(20) DEFAULT NULL COMMENT '结业证书编号',
  `completeCerDate` varchar(20) DEFAULT NULL COMMENT '结业发证日期',
  `cerNo` varchar(20) DEFAULT NULL COMMENT '鉴定证书编号',
  `cerDate` varchar(20) DEFAULT NULL COMMENT '鉴定发证日期',
  `certificateDate` varchar(20) DEFAULT NULL COMMENT '发证日期',
  `trainBeginDate` datetime DEFAULT  NULL COMMENT '培训结束时间',
  `trainEndDate` datetime DEFAULT NULL COMMENT '培训开始时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COMMENT='等级证补贴花名册';



#等级证补贴批次
DROP TABLE IF EXISTS `sb_grade_subsidy_batch`;
CREATE TABLE `sb_grade_subsidy_batch` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `active` bit(1) DEFAULT b'1' COMMENT '是否可用',
  `updateflag` bit(1) DEFAULT NULL COMMENT '更新标志位',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `applyTime` datetime DEFAULT NULL COMMENT '申请时间',
  `approvaldate` datetime DEFAULT NULL COMMENT '审批时间',
  `update_by` varchar(50) DEFAULT NULL COMMENT '修改者',
  `userid` bigint(20) DEFAULT NULL COMMENT '用户id',
  `orgName` varchar(50) DEFAULT NULL COMMENT '机构名称',
	`companyid` bigint(20) DEFAULT NULL COMMENT '培训机构id',
	`companyname` varchar(50) DEFAULT NULL COMMENT '培训机构名称',
  `batchName` varchar(200) DEFAULT NULL COMMENT '批次名称',
  `contact` varchar(18) DEFAULT NULL COMMENT '培训机构联系人',
  `phone` varchar(20) DEFAULT NULL COMMENT '联系方式',
  `address` varchar(500) DEFAULT NULL COMMENT '培训机构地址',
  `remark` varchar(500) DEFAULT NULL COMMENT '备注',
  `perNum` varchar(10) DEFAULT NULL COMMENT '批次人数',
  `subsidyCerType` varchar(20) DEFAULT NULL COMMENT '补贴证书类型',
  `subsidyMoney` varchar(10) DEFAULT NULL COMMENT '补贴总额',
  `approvalreason` varchar(200) DEFAULT NULL COMMENT '审批意见',
  `outreason` varchar(200) DEFAULT NULL COMMENT '对外审批意见',
  `szss` varchar(200) DEFAULT NULL COMMENT '所在地省市县（区）',
  `province` varchar(10) DEFAULT NULL COMMENT '所在地省代码',
  `city` varchar(10) DEFAULT NULL COMMENT '所在地市代码',
  `cityOrgId` varchar(10) DEFAULT NULL COMMENT '所在地市机构id',
  `district` varchar(10) DEFAULT NULL COMMENT '所在地县（区）代码',
  `districtOrgId` varchar(10) DEFAULT NULL COMMENT '所在地县（区）机构id',
  `orgid` varchar(10) DEFAULT NULL COMMENT '派出所ID',
  `approvalstate` varchar(5) DEFAULT NULL COMMENT '审批状态',
  `templateRar` varchar(500) DEFAULT NULL COMMENT '压缩包地址',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='等级证补贴批次';



#等级证补贴批次关联花名册
DROP TABLE IF EXISTS `sb_grade_subsidy_batch_roster`;
CREATE TABLE `sb_grade_subsidy_batch_roster` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `active` bit(1) DEFAULT b'1' COMMENT '是否可用',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `update_by` varchar(50) DEFAULT NULL COMMENT '修改者',
  `batchId` bigint(20) DEFAULT NULL COMMENT '批次id',
  `rosterId` bigint(20)DEFAULT NULL COMMENT '花名册id',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='等级证补贴批次关联花名册';

#保安员等级证报名鉴定证书
DROP TABLE IF EXISTS `sb_grade_appraisal_cer`;
CREATE TABLE `sb_grade_appraisal_cer` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `active` bit(1) DEFAULT b'1' COMMENT '是否可用',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `update_by` varchar(50) DEFAULT NULL COMMENT '修改者',
  `updateflag` bit(1) DEFAULT NULL COMMENT '更新标志位',
  `userid` bigint(20) DEFAULT NULL COMMENT '用户id',
  `areaCode` varchar(6) DEFAULT NULL COMMENT '数据区域',
  `personGradeId` bigint(20) DEFAULT NULL COMMENT '等级证报名id',
  `cerDate` varchar(18) DEFAULT NULL COMMENT '发证日期',
  `name` varchar(50) DEFAULT NULL COMMENT '姓名',
  `idNum` varchar(18) DEFAULT NULL COMMENT '身份证号',
  `gender` varchar(2) DEFAULT NULL COMMENT '性别',
  `gradeLevel` varchar(5) DEFAULT NULL COMMENT '等级',
  `cerNo` varchar(50) DEFAULT NULL COMMENT '证书编号',
  `profession` varchar(50) DEFAULT NULL COMMENT '职业',
  `trainId` bigint(20) DEFAULT NULL COMMENT '培训机构id',
  `trainName` varchar(500) DEFAULT NULL COMMENT '培训机构',
  `trainStartDate` varchar(18) DEFAULT NULL COMMENT '培训开始日期',
  `trainEndDate` varchar(18) DEFAULT NULL COMMENT '培训结束日期',
  `comId` bigint(20) DEFAULT NULL COMMENT '公司id',
  `comName` varchar(500) DEFAULT NULL COMMENT '公司名称',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='保安员等级证报名鉴定证书';


#yyx 导入通用配置 20200518
DROP TABLE IF EXISTS `sys_import_config`;
CREATE TABLE `sys_import_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `active` bit(1) DEFAULT b'1' COMMENT '是否可用',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `update_by` varchar(50) DEFAULT NULL COMMENT '修改者',
  `readRow` int(10) DEFAULT NULL COMMENT '开始读取的行数',
	`keyColumn` int(10) DEFAULT NULL COMMENT '读取唯一标识列',
  `resultColumn` int(10) DEFAULT NULL COMMENT '读取结果列',
  `reasonColumn` int(10) DEFAULT NULL COMMENT '读取原因列',
  `businessType` varchar(20) DEFAULT NULL COMMENT '业务类型',
  `tableName` varchar(50) DEFAULT NULL COMMENT '表名（唯一标识列的所在表名）',
  `filedName` varchar(50) DEFAULT NULL COMMENT '字段名（唯一标识列的字段名）',
  `reasonFiledName` varchar(50) DEFAULT NULL COMMENT '原因字段名（更新的原因字段名）',
  `resultFiledName` varchar(50) DEFAULT NULL COMMENT '状态字段名',
  `subsidyCerType` varchar(20) DEFAULT NULL COMMENT '补贴证书类型',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COMMENT='导入通用配置';


DROP TABLE IF EXISTS `subsidyconfig`;
CREATE TABLE `subsidyconfig` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `active` bit(1) DEFAULT NULL COMMENT '是否可用',
  `create_time` varchar(100) DEFAULT NULL COMMENT '创建时间',
  `update_time` varchar(100) DEFAULT NULL COMMENT '修改时间',
  `update_by` varchar(50) DEFAULT NULL COMMENT '更新人',
  `businessType` varchar(10) DEFAULT NULL COMMENT '业务类型001结业002等级003资格证',
  `businessName` varchar(20) DEFAULT NULL COMMENT '业务名称',
  `amount` varchar(20) DEFAULT NULL COMMENT '金额',
  `percent` varchar(11) DEFAULT NULL COMMENT '百分比',
  `EffectiveTime` varchar(100) DEFAULT NULL COMMENT '有效时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COMMENT='补贴参数配置表';



DROP TABLE IF EXISTS `sys_export_column`;
CREATE TABLE `sys_export_column` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `active` bit(1) DEFAULT b'1' COMMENT '是否可用',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `update_by` varchar(50) DEFAULT NULL COMMENT '修改者',
  `columnName` varchar(255) DEFAULT NULL COMMENT '字段名称',
  `columnWith` int(11) DEFAULT NULL COMMENT '字段宽度',
  `occupy` int(11) DEFAULT NULL COMMENT '占用几列',
  `beginCol` int(11) DEFAULT NULL COMMENT '起始列',
  `columnValueSource` varchar(30) DEFAULT NULL COMMENT '字段值来源',
  `formula` varchar(50) DEFAULT NULL COMMENT '字段值公式',
  `formatDate` varchar(50) DEFAULT NULL COMMENT '日期格式',
  `sysCodeType` varchar(50) DEFAULT NULL COMMENT '码表类型',
  `context` varchar(2000) DEFAULT NULL COMMENT '固定内容',
  `seq` int(11) DEFAULT NULL COMMENT '排序',
  `required` varchar(10) DEFAULT NULL COMMENT '必填标识',
  `configId` int(11) unsigned zerofill DEFAULT NULL COMMENT '配置表ID',
  `position` varchar(20) DEFAULT NULL COMMENT '位置',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COMMENT='导出字段配置表';

DROP TABLE IF EXISTS `sys_export_config`;
CREATE TABLE `sys_export_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `active` bit(1) DEFAULT b'1' COMMENT '是否可用',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `update_by` varchar(50) DEFAULT NULL COMMENT '修改者',
  `title` varchar(255) DEFAULT NULL COMMENT '标题',
  `exportType` varchar(3) DEFAULT NULL COMMENT '导出类型',
  `columns` int(11) DEFAULT NULL COMMENT '列数，不包含序号',
  `columnNo` varchar(5) DEFAULT NULL COMMENT '是否有序号列',
  `isJar` varchar(5) DEFAULT NULL COMMENT '是否有序号列',
  `tableName` varchar(50) DEFAULT NULL COMMENT '表名',
  `subsidyCerType` varchar(20) DEFAULT NULL COMMENT '补贴证书类型',
  `trainNameKey` varchar(20) DEFAULT NULL COMMENT '花名册区分表名的key',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COMMENT='导出配置表';

#补贴导入比对流向
DROP TABLE IF EXISTS `subsidycomparison`;
CREATE TABLE `subsidycomparison` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `active` bit(1) DEFAULT NULL COMMENT '是否可用',
  `create_time` varchar(100) DEFAULT NULL COMMENT '创建时间',
  `update_time` varchar(100) DEFAULT NULL COMMENT '修改时间',
  `update_by` varchar(50) DEFAULT NULL COMMENT '更新人',
  `code` varchar(10) DEFAULT NULL COMMENT '编码值',
  `codeValue` varchar(50) DEFAULT NULL COMMENT '编写中文名称',
  `flowTo` varchar(10) DEFAULT NULL COMMENT '001修改002不可修改',
  `businessType` varchar(20) DEFAULT NULL COMMENT '比对业务类型',
  PRIMARY KEY (`id`)
)  ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COMMENT='比对流向表';

#培训单位补贴简称批次配置
DROP TABLE IF EXISTS `train_subsidy_config`;
CREATE TABLE `train_subsidy_config` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `active` bit(1) DEFAULT b'1' COMMENT '是否可用',
  `updateflag` bit(1) DEFAULT NULL COMMENT '更新标志位',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `update_by` varchar(50) DEFAULT NULL COMMENT '修改者',
  `userid` bigint(20) DEFAULT NULL COMMENT '用户id',
	`trainId` bigint(20) DEFAULT NULL COMMENT '培训机构id',
	`trainName` varchar(200) DEFAULT NULL COMMENT '培训机构名称',
	`shortName` varchar(50) DEFAULT NULL COMMENT '简称',
	`subsidyCerType` varchar(5) DEFAULT NULL COMMENT '补贴证书类型',
  `batchNo` bigint(20) DEFAULT NULL COMMENT '批次号',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='培训单位补贴简称批次配置';

drop view if EXISTS v_grade_subsidy_batch;
CREATE
VIEW `v_grade_subsidy_batch` AS
select
t1.id as batchId,
t1.applyTime as applyTime,
t1.batchName,
t1.approvalstate,
t1.approvaldate,
t3.*
from sb_grade_subsidy_batch t1 inner join sb_grade_subsidy_batch_roster t2 on t1.id = t2.batchId
inner join grade_subsidy_roster t3 on t2.rosterId = t3.id;


DROP TABLE IF EXISTS `riskarea`;
CREATE TABLE `riskarea` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  `active` bit(1) DEFAULT NULL COMMENT '是否有效',
  `update_by` varchar(50) DEFAULT NULL COMMENT '更新者',
  `areaCode` varchar(20) DEFAULT NULL COMMENT '区域',
  `streetName` varchar(100) DEFAULT NULL COMMENT '街道名称',
  `riskLevel` varchar(10) DEFAULT NULL COMMENT '风险级别',
  `areaName` varchar(20) DEFAULT NULL COMMENT '区域',
  PRIMARY KEY (`id`),
  KEY `riskarea_key` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COMMENT='街道管理表';



