delete from sys_dict where codeType='dateType';

INSERT INTO `sys_dict` (`isActive`, `codeType`, `tableName`, `description`, `codeValue`, `label`, `seq`)
VALUES ('1', 'dateType', NULL, '报表日期类型', '1', '年', '1'),
('1', 'dateType', NULL, '报表日期类型', '2', '月', '2'),
('1', 'dateType', NULL, '报表日期类型', '3', '周', '3');

DROP TABLE IF EXISTS `report_company`;
CREATE TABLE `report_company` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `active` bit(1) DEFAULT NULL,
  `createTime` datetime DEFAULT NULL,
  `updateTime` datetime DEFAULT NULL,
  `orgId` varchar(30) DEFAULT NULL,
  `path` varchar(255) DEFAULT NULL,
  `areaCode` varchar(255) DEFAULT NULL,
  `institutionType` varchar(10) DEFAULT NULL,
  `totalNum` int(11) DEFAULT NULL COMMENT '总数',
  `initNum` int(11) DEFAULT NULL COMMENT '初始化',
  `unInitNum` int(11) DEFAULT NULL COMMENT '未初始化',
  PRIMARY KEY (`id`),
  KEY `index_orgid` (`orgId`) USING BTREE,
  KEY `index_path` (`path`) USING BTREE,
  KEY `index_areacode` (`areaCode`) USING BTREE,
  KEY `index_institutiontype` (`institutionType`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=159 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `report_person`;
CREATE TABLE `report_person` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `active` bit(1) DEFAULT NULL,
  `createTime` datetime DEFAULT NULL,
  `updateTime` datetime DEFAULT NULL,
  `orgId` varchar(30) DEFAULT NULL,
  `path` varchar(255) DEFAULT NULL,
  `areaCode` varchar(255) DEFAULT NULL,
  `institutionType` varchar(10) DEFAULT NULL,
  `totalNum` int(11) DEFAULT NULL COMMENT '总数',
  `quitNum` int(11) DEFAULT NULL COMMENT '离职',
  `authNum` int(11) DEFAULT NULL COMMENT '已认证',
  `unAuthNum` int(11) DEFAULT NULL COMMENT '未认证',
  `certificateNum` int(11) DEFAULT NULL COMMENT '已持证',
  `unCerNum` int(11) DEFAULT NULL COMMENT '未持证',
  PRIMARY KEY (`id`),
  KEY `index_orgid` (`orgId`) USING BTREE,
  KEY `index_path` (`path`) USING BTREE,
  KEY `index_areacode` (`areaCode`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=191 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `report_personcertificate`;
CREATE TABLE `report_personcertificate` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `active` bit(1) DEFAULT NULL,
  `createTime` datetime DEFAULT NULL,
  `updateTime` datetime DEFAULT NULL,
  `orgId` varchar(30) DEFAULT NULL,
  `path` varchar(255) DEFAULT NULL,
  `areaCode` varchar(255) DEFAULT NULL,
  `dateType` varchar(255) DEFAULT NULL,
  `reportDate` varchar(255) DEFAULT NULL,
  `totalNum` int(11) DEFAULT NULL COMMENT '总数',
  `passNum` int(11) DEFAULT NULL COMMENT '政审通过',
  `failNum` int(11) DEFAULT NULL COMMENT '政审不通过',
  `testNum` int(11) DEFAULT NULL COMMENT '考试人数',
  `testPassNum` int(11) DEFAULT NULL COMMENT '考试通过',
  `testFailNum` int(11) DEFAULT NULL COMMENT '考试失败',
  `passRate` float(20,2) DEFAULT NULL COMMENT '考试通过同比去年同期',
  PRIMARY KEY (`id`),
  KEY `index_orgid` (`orgId`) USING BTREE,
  KEY `index_path` (`path`) USING BTREE,
  KEY `index_areacode` (`areaCode`) USING BTREE,
  KEY `index_datetype` (`dateType`) USING BTREE,
  KEY `index_reportdate` (`reportDate`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=767 DEFAULT CHARSET=utf8 COMMENT='保安员参与资格证考试情况';

DROP TABLE IF EXISTS `report_problem_person`;
CREATE TABLE `report_problem_person` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `active` bit(1) DEFAULT NULL,
  `createTime` datetime DEFAULT NULL,
  `updateTime` datetime DEFAULT NULL,
  `orgId` varchar(30) DEFAULT NULL,
  `path` varchar(255) DEFAULT NULL,
  `areaCode` varchar(255) DEFAULT NULL,
  `dateType` varchar(255) DEFAULT NULL,
  `reportDate` varchar(255) DEFAULT NULL,
  `focalNum` int(11) DEFAULT NULL COMMENT '重点人员',
  `escapeNum` int(11) DEFAULT NULL COMMENT '在逃人员',
  `errorNum` int(11) DEFAULT NULL COMMENT '重要信息有误',
  `captureNum` int(11) DEFAULT NULL COMMENT '已抓获',
  `unCaptureNum` int(11) DEFAULT NULL COMMENT '未抓获',
  `handleNum` int(11) DEFAULT NULL COMMENT '已处理',
  `unHandleNum` int(11) DEFAULT NULL COMMENT '未处理',
  `dismissNum` int(11) DEFAULT NULL COMMENT '辞退',
  `retainNum` int(11) DEFAULT NULL COMMENT '留用',
  PRIMARY KEY (`id`),
  KEY `index_orgid` (`orgId`) USING BTREE,
  KEY `index_path` (`path`) USING BTREE,
  KEY `index_areacode` (`areaCode`) USING BTREE,
  KEY `index_datetype` (`dateType`) USING BTREE,
  KEY `index_reportdate` (`reportDate`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=639 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `report_task`;
CREATE TABLE `report_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `active` bit(1) DEFAULT NULL,
  `createTime` datetime DEFAULT NULL,
  `updateTime` datetime DEFAULT NULL,
  `orgId` varchar(30) DEFAULT NULL,
  `path` varchar(255) DEFAULT NULL,
  `areaCode` varchar(255) DEFAULT NULL,
  `dateType` varchar(255) DEFAULT NULL,
  `reportDate` varchar(255) DEFAULT NULL,
  `totalNum` int(11) DEFAULT NULL COMMENT '总数',
  `relatedNum` int(11) DEFAULT NULL COMMENT '已关联合同',
  `unRelatedNum` int(11) DEFAULT NULL COMMENT '未关联合同',
  `personNum` int(11) DEFAULT NULL COMMENT '人员总数',
  `signNum` int(11) DEFAULT NULL COMMENT '已签订',
  `renewaNum` int(11) DEFAULT NULL COMMENT '续签',
  `completeNum` int(11) DEFAULT NULL COMMENT '已完成',
  `stopNum` int(11) DEFAULT NULL COMMENT '已终止',
  `underWayNum` int(11) DEFAULT NULL COMMENT '进行中',
  PRIMARY KEY (`id`),
  KEY `index_orgid` (`orgId`) USING BTREE,
  KEY `index_path` (`path`) USING BTREE,
  KEY `index_areacode` (`areaCode`) USING BTREE,
  KEY `index_datetype` (`dateType`) USING BTREE,
  KEY `index_reportdate` (`reportDate`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=639 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `report_train`;
CREATE TABLE `report_train` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `active` bit(1) DEFAULT NULL,
  `createTime` datetime DEFAULT NULL,
  `updateTime` datetime DEFAULT NULL,
  `orgId` varchar(30) DEFAULT NULL,
  `path` varchar(255) DEFAULT NULL,
  `areaCode` varchar(255) DEFAULT NULL,
  `dateType` varchar(255) DEFAULT NULL,
  `reportDate` varchar(255) DEFAULT NULL,
  `totalNum` int(11) DEFAULT NULL COMMENT '考试场次',
  `personNum` int(11) DEFAULT NULL COMMENT '安排人数',
  `missNum` int(11) DEFAULT NULL COMMENT '缺考人数',
  `testNum` int(11) DEFAULT NULL COMMENT '参与考试人数',
  `testPassNum` int(11) DEFAULT NULL COMMENT '考试通过',
  `testFailNum` int(11) DEFAULT NULL COMMENT '考试不通过',
  PRIMARY KEY (`id`),
  KEY `index_orgid` (`orgId`) USING BTREE,
  KEY `index_path` (`path`) USING BTREE,
  KEY `index_areacode` (`areaCode`) USING BTREE,
  KEY `index_datetype` (`dateType`) USING BTREE,
  KEY `index_reportdate` (`reportDate`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
