


DROP TABLE IF EXISTS `sys_data_change_log`;
CREATE TABLE `sys_data_change_log` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  `update_by` varchar(50) DEFAULT NULL COMMENT '更新者',
  `updateflag` bit(1) DEFAULT NULL COMMENT '更新标志位',
  `method_name` varchar(500) DEFAULT NULL COMMENT '方法名',
  `old_value` longtext COMMENT '旧值',
  `new_value` longtext COMMENT '新值',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='数据变更记录表';


DROP TABLE IF EXISTS `filerecord`;
CREATE TABLE `filerecord` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `filepath` varchar(200) DEFAULT NULL COMMENT '文件名称',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  `filename` varchar(300) DEFAULT NULL COMMENT '文件名称',
  `intranet` bit(1) DEFAULT NULL COMMENT '文件类型',
  `recordsize` int(11) DEFAULT NULL COMMENT '记录数量',
  `updateFlag` bit(1) DEFAULT NULL,
  `synchtype` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `r_id` (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=658463057701702 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;


DROP TABLE IF EXISTS `filerecord_detail`;
CREATE TABLE `filerecord_detail` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  `recordId` bigint(20) DEFAULT NULL COMMENT '文件名称',
  `businessId` bigint(20) DEFAULT NULL COMMENT '文件名称',
  `intranet` bit(1) DEFAULT NULL COMMENT '是否内网',
  `data` longtext COMMENT '同步数据',
  `error` longtext COMMENT '错误记录',
  `updateFlag` bit(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `r_id` (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=617025628811651 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;


DROP TABLE IF EXISTS `filerecordout`;
CREATE TABLE `filerecordout` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `filepath` varchar(200) DEFAULT NULL COMMENT '文件名称',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  `filename` varchar(300) DEFAULT NULL COMMENT '文件名称',
  `synchtype` varchar(100) DEFAULT NULL COMMENT '文件类型',
  `recordsize` int(11) DEFAULT NULL COMMENT '记录数量',
  PRIMARY KEY (`id`),
  KEY `r_id` (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT COMMENT='文件同步记录（用于数据同步）';


ALTER TABLE `problemperson`
MODIFY COLUMN `inform`  varchar(5) NULL DEFAULT NULL COMMENT '是否通知企业' AFTER `active`;


ALTER TABLE `problemperson`
ADD COLUMN `disposeCompany`  varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '企业是否处理' AFTER `handler`;



ALTER TABLE `problemperson`
ADD COLUMN `reson`  varchar(255) NULL AFTER `disposeCompany`;


ALTER TABLE `problemperson`
MODIFY COLUMN `suggestion`  varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '对外意见' AFTER `problemtype`,
MODIFY COLUMN `reson`  varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '处理意见 ' AFTER `disposeCompany`,
ADD COLUMN `companyReson`  varchar(255) NULL COMMENT '公司处理意见' AFTER `reson`;

INSERT INTO `operation` (`id`, `native_code`, `code`, `name`, `module_id`, `active`, `create_time`, `update_time`, `update_by`) VALUES (null, '3502', 'toCompanyDispose', '处理页面', '171',true, now(),now(), 'system');
INSERT INTO `operation` (`id`, `native_code`, `code`, `name`, `module_id`, `active`, `create_time`, `update_time`, `update_by`) VALUES (null, '3502', 'saveCompanyDispose', '处理', '171',true, now(),now(),'system');

ALTER TABLE `problemperson`
ADD COLUMN `handlerOrg`  varchar(20) NULL COMMENT '处理人机构' AFTER `companyReson`;


INSERT INTO `sys_dict` (`sysDictId`, `isActive`, `codeType`, `tableName`, `description`, `codeValue`, `label`, `seq`) VALUES ('803', '1', 'inform', NULL, '告知企业类型', '2', '辞退', '2');
INSERT INTO `sys_dict` (`sysDictId`, `isActive`, `codeType`, `tableName`, `description`, `codeValue`, `label`, `seq`) VALUES ('804', '1', 'inform', NULL, '告知企业类型', '3', '留用', '3');
INSERT INTO `sys_dict` (`sysDictId`, `isActive`, `codeType`, `tableName`, `description`, `codeValue`, `label`, `seq`) VALUES ('805', '1', 'inform', NULL, '告知企业类型', '4', '企业自行处理', '4');
INSERT INTO `sys_dict` (`sysDictId`, `isActive`, `codeType`, `tableName`, `description`, `codeValue`, `label`, `seq`) VALUES ('806', '1', 'inform', '', '告知企业类型', '1', '企业根据意见处理', '1');
