ALTER TABLE `com_task`
ADD COLUMN `contractStatus`  varchar(10) DEFAULT NULL COMMENT '合同状态';

ALTER TABLE `com_task`
ADD COLUMN `taskStatusNew`  varchar(10) DEFAULT NULL COMMENT '新驻勤状态';

drop view if EXISTS v_com_task;
CREATE
VIEW `v_com_task`AS
select
      t.comTaskId,
      t.taskName,
      t.orgName,
      t.taskStationType,
      sc.`name` as comName,
      t.serviceObject,
      t.serviceObjectSySituation,
      t.taskAddress,
      b.effectStartDate as startDate,
      b.effectEndDate as endDate,
      t.startDate as taskStartDate,
      t.endDate as taskEndDate,
      t.area,
      t.taskStatus,
      t.taskStatusNew,
      sc.areaCode as comAreaCode,
      t.areaCode as taskAreaCode,
      sc.orgId as comOrgId,
      t.orgId as taskOrgId,
      t.contractStatus as contractStatus,
      (
      select count(1) from security_company_person d,com_task_per e where d.active =true and e.active =true and company_id = sc.id  and e.perId =d.person_id and e.comTaskId =  t.comTaskId

      ) as perNum,
      sc.id as comId,
      b.comContractId as comContractId,
      b.contractName as contractName
    from com_task t
    INNER JOIN security_company sc on t.comId = sc.comId
    left JOIN com_contract b on t.comContractId = b.comContractId
    WHERE
      t.isDelete='0'