
CREATE TABLE `module_menu` (
  `id` bigint(20) NOT NULL COMMENT '功能ID',
  `active` bit(1) DEFAULT NULL COMMENT '是否有效',
  `createTime` datetime DEFAULT NULL COMMENT '创建时间',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` varchar(50) DEFAULT NULL COMMENT '修改人',
  `location` text COMMENT '菜单链接',
  `name` varchar(100) NOT NULL COMMENT '节点文本',
  `parentId` bigint(20) DEFAULT NULL COMMENT '父节点ID',
  `seq` int(10) DEFAULT NULL COMMENT '同级菜单中排序序号',
  `menuType` varchar(8) NOT NULL COMMENT '结点类型：0菜单1权限',
  `description` text COMMENT '功能的中文描述',
  `iconClass` varchar(20) DEFAULT NULL COMMENT '主界面图标class',
  `iconCls` varchar(20) DEFAULT NULL COMMENT '图标class',
  `permission` varchar(100) DEFAULT NULL COMMENT '权限标识',
  `parentIds` text COMMENT '父节点的id列表，如"100001/100020/100022/"，分别列出从根开始的编码',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='功能权限表';


delete from sys_dict where codeType = 'menuType';
INSERT INTO `sys_dict` (`isActive`, `codeType`, `tableName`, `description`, `codeValue`, `label`, `seq`)
VALUES
('1', 'menuType', NULL, '节点类型', '0', '菜单', '1'),
('1', 'menuType', NULL, '节点类型', '1', '权限', '2');
