

##保安员等级证报名记录表
DROP TABLE IF EXISTS `sb_person_grade`;
CREATE TABLE `sb_person_grade` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `active` bit(1) DEFAULT b'1' COMMENT '是否可用',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `update_by` varchar(50) DEFAULT NULL COMMENT '修改者',
  `updateflag` bit(1) DEFAULT NULL COMMENT '更新标志位',
  `userid` bigint(20) DEFAULT NULL COMMENT '用户id',
  `areaCode` varchar(6) DEFAULT NULL COMMENT '数据区域',
  `orgId` bigint(20) DEFAULT NULL COMMENT '公安机关id',
  `personId` bigint(20) DEFAULT NULL COMMENT '人员id',
  `name` varchar(50) DEFAULT NULL COMMENT '姓名',
  `phone` varchar(20) DEFAULT NULL COMMENT '手机号',
  `idNum` varchar(18) DEFAULT NULL COMMENT '身份证号',
  `applyTime` datetime DEFAULT NULL COMMENT '报名时间',
  `trainId` bigint(20) DEFAULT NULL COMMENT '培训机构id',
  `trainName` varchar(500) DEFAULT NULL COMMENT '培训机构',
  `testTime` datetime DEFAULT NULL COMMENT '选择培训机构时间（考试报名时间）',
  `idFrontImg` varchar(500) DEFAULT NULL COMMENT '身份证正面',
  `idBackImg` varchar(500) DEFAULT NULL COMMENT '身份证反面',
  `headImg` varchar(500) DEFAULT NULL COMMENT '头像',
  `comId` bigint(20) DEFAULT NULL COMMENT '公司id',
  `comName` varchar(500) DEFAULT NULL COMMENT '公司名称',
  `gradeLevel` varchar(5) DEFAULT NULL COMMENT '等级',
  `period` varchar(20) DEFAULT NULL COMMENT '学时进度',
  `periodStatus` varchar(5) DEFAULT '0' COMMENT '学时进度状态',
  `practiceDay` int(10) DEFAULT NULL COMMENT '实习天数',
  `practiceHour` int(10) DEFAULT NULL COMMENT '实习时长',
  `censorStatus` varchar(5) DEFAULT NULL COMMENT '背景筛查状态',
  `address` varchar(500) DEFAULT NULL COMMENT '户籍地址',
  `liveAddress` varchar(500) DEFAULT NULL COMMENT '现住地址',
  `residentType` varchar(5) DEFAULT NULL COMMENT '户籍类型',
  `residentPlaceType` varchar(5) DEFAULT NULL COMMENT '户籍所在地类型',
  `contractId` bigint(20) DEFAULT NULL COMMENT '合同id',
  `classId` bigint(20) DEFAULT NULL COMMENT '班级id',
  `testStateComplete` varchar(5) DEFAULT NULL COMMENT '结业考试结果',
  `writtenScoreComplete` varchar(10) DEFAULT NULL COMMENT '结业笔试成绩',
  `operateScoreComplete` varchar(10) DEFAULT NULL COMMENT '结业实操成绩',
  `sumScoreComplete` varchar(10) DEFAULT NULL COMMENT '结业总成绩',
  `zgCerNo` varchar(30) DEFAULT NULL COMMENT '资格证号',
  `zgCerUrl` varchar(500) DEFAULT NULL COMMENT '资格证电子证',
  `zgOrg` varchar(500) DEFAULT NULL COMMENT '资格证发证机关',
  `zgTrainName` varchar(500) DEFAULT NULL COMMENT '资格证培训单位',
  `zgIssueDate` varchar(30) DEFAULT NULL COMMENT '资格证发证日期',
  `payTime` datetime DEFAULT NULL COMMENT '缴费时间',
  `payState` varchar(5) DEFAULT NULL COMMENT '缴费状态',
  `checkState` varchar(5) DEFAULT NULL COMMENT '材料核对状态',
  `classState` varchar(5) DEFAULT NULL COMMENT '开班安排状态',
  `writtenScore` varchar(10) DEFAULT NULL COMMENT '鉴定笔试成绩',
  `operateScore` varchar(10) DEFAULT NULL COMMENT '鉴定实操成绩',
  `sumScore` varchar(10) DEFAULT NULL COMMENT '鉴定总成绩',
  `testState` varchar(5) DEFAULT NULL COMMENT '鉴定考试结果',
  `approvalReason` varchar(500) DEFAULT NULL COMMENT '审批原因',
  `approvalState` varchar(5) DEFAULT NULL COMMENT '审批状态',
  `gradePersonType` varchar(5) DEFAULT NULL COMMENT '人员类型',
  `mainHomeUrl` varchar(500) DEFAULT NULL COMMENT '户口簿户主页',
  `selfHomeUrl` varchar(500) DEFAULT NULL COMMENT '户口簿本人页',
  `regCerUrl` varchar(500) DEFAULT NULL COMMENT '普通高等学校报到证',
  `gradCerUrl` varchar(500) DEFAULT NULL COMMENT '普通高等学校毕业证书',
  `empCerUrl` varchar(500) DEFAULT NULL COMMENT '就业失业登记证',
  `laborTranCerUrl` varchar(500) DEFAULT NULL COMMENT '北京市农村劳动力转移就业证',
  `dischargeCerUrl` varchar(500) DEFAULT NULL COMMENT '退役证或退伍证',
  `selfEmpCerUrl` varchar(500) DEFAULT NULL COMMENT '自主就业安置证明',
  `demobCerUrl` varchar(500) DEFAULT NULL COMMENT '复员证',
  `conversionCerUrl` varchar(500) DEFAULT NULL COMMENT '转业证',
  `confirmCerUrl` varchar(500) DEFAULT NULL COMMENT '户籍所在区县人力社保部门开据的确认证明',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=676035580659761153 DEFAULT CHARSET=utf8 COMMENT='保安员等级证报名';


##实习记录
DROP TABLE IF EXISTS `sb_grade_practice`;
CREATE TABLE `sb_grade_practice` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `active` bit(1) DEFAULT b'1' COMMENT '是否可用',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `update_by` varchar(50) DEFAULT NULL COMMENT '更新者',
  `userid` bigint(20) DEFAULT NULL COMMENT '用户id',
  `personId` bigint(20) DEFAULT NULL COMMENT '人员id',
  `gradeLevel` varchar(5) DEFAULT NULL COMMENT '等级',
  `name` varchar(50) DEFAULT NULL COMMENT '姓名',
  `idnum` varchar(20) DEFAULT NULL COMMENT '身份证号',
  `practiceDate` varchar(20) DEFAULT NULL COMMENT '实习日期',
  `comId` bigint(20) DEFAULT NULL COMMENT '实习单位id',
  `comName` varchar(500) DEFAULT NULL COMMENT '实习单位',
  `startTime` datetime DEFAULT NULL COMMENT '上班打卡时间',
  `endTime` datetime DEFAULT NULL COMMENT '下班打卡时间',
  `duration` int(10) DEFAULT NULL COMMENT '时长',
  `chargeName` varchar(50) DEFAULT NULL COMMENT '负责人',
  `chargeNo` varchar(20) DEFAULT NULL COMMENT '负责人身份证号',
  `content` varchar(500) DEFAULT NULL COMMENT '实习内容',
  `uniformImg` varchar(500) DEFAULT NULL COMMENT '穿戴保安服照',
  `addressImg` varchar(500) DEFAULT NULL COMMENT '实习地点照片',
  `processImg` varchar(500) DEFAULT NULL COMMENT '实习过程照片',
  `video` varchar(500) DEFAULT NULL COMMENT '实习过程视频',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

## 等级证
DROP TABLE IF EXISTS `sb_grade_class`;
CREATE TABLE `sb_grade_class` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `active` bit(1) DEFAULT b'1' COMMENT '是否可用',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `userid` bigint(20) DEFAULT NULL COMMENT '用户id',
  `name` varchar(50) DEFAULT NULL COMMENT '班级名称',
  `trainId` bigint(20) DEFAULT NULL COMMENT '培训机构id',
  `trainName` varchar(500) DEFAULT NULL COMMENT '培训机构',
  `perNum` int(10) DEFAULT NULL COMMENT '班级人数',
  `startTime` varchar(50) DEFAULT NULL COMMENT '实操培训开始时间',
  `endTime` varchar(50) DEFAULT NULL COMMENT '实操培训结束时间',
  `approvalState` varchar(5) DEFAULT NULL COMMENT '审批状态',
  `address` varchar(500) DEFAULT NULL COMMENT '实操培训地点',
  `approvalReson` varchar(500) DEFAULT NULL COMMENT '审批原因',
  `updateflag` bit(1) DEFAULT NULL COMMENT '更新标识',
  `approvalResonIn` varchar(500) DEFAULT NULL COMMENT '对内意见',
  `update_by` varchar(50) DEFAULT NULL COMMENT '更新人',
  `gradeLevel` varchar(10) DEFAULT NULL COMMENT '等级',
  `contactPerson` varchar(50) DEFAULT NULL COMMENT '考场联系人',
  `contactPersonTel` varchar(20) DEFAULT NULL COMMENT '考场联系人电话',
  `otherTel` varchar(20) DEFAULT NULL COMMENT '其它联系方式',
  `contactPersonEmail` varchar(20) DEFAULT NULL COMMENT '考场联系人邮箱',
  `graduationStartTime` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '结业理论考试开始时间',
  `graduationEndTime` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '结业理论考试结束时间',
  `graduationStartAddress` varchar(200) DEFAULT NULL COMMENT '结业理论考试地点',
  `graduationStartExamType` varchar(10) DEFAULT NULL COMMENT '考试试卷',
  `graduationOperationStartTime` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '实操考试开始时间',
  `graduationOperationEndTime` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '实操考试结束时间',
  `graduationOperationAddress` varchar(200) DEFAULT NULL COMMENT '实操考试地点',
  `appraisalStartTime` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '鉴定理论考试时间',
  `appraisalEndTime` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '鉴定理论考试开始时间',
  `appraisalAddress` varchar(200) DEFAULT NULL COMMENT '鉴定理论考试地址',
  `appraisalOperationStartTime` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '鉴定实操考试开始时间',
  `appraisalOperationEndTime` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '鉴定实操考试结束时间',
  `appraisalOperationAddress` varchar(200) DEFAULT NULL COMMENT '鉴定实操考试地点',
  `graduationQualified` varchar(10) DEFAULT NULL COMMENT '结业理论成绩合格',
  `graduationOperationQualified` varchar(10) DEFAULT NULL COMMENT '结业实操成绩合格',
  `appraisalQualified` varchar(10) DEFAULT NULL COMMENT '鉴定实操成绩合格',
  `appraisalOperationQualified` varchar(10) DEFAULT NULL COMMENT '鉴定实操成绩合格',
  `graduationStartExamPaper` varchar(255) DEFAULT NULL COMMENT '结业考试试卷',
  `carefulMatter` varchar(500) DEFAULT NULL COMMENT '注意事项',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=676057909926297601 DEFAULT CHARSET=utf8;

#保安员等级证报名结业证书
DROP TABLE IF EXISTS `sb_grade_complete_cer`;
CREATE TABLE `sb_grade_complete_cer` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `active` bit(1) DEFAULT b'1' COMMENT '是否可用',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `update_by` varchar(50) DEFAULT NULL COMMENT '修改者',
  `updateflag` bit(1) DEFAULT NULL COMMENT '更新标志位',
  `userid` bigint(20) DEFAULT NULL COMMENT '用户id',
  `areaCode` varchar(6) DEFAULT NULL COMMENT '数据区域',
  `personGradeId` bigint(20) DEFAULT NULL COMMENT '等级证报名id',
  `cerDate` varchar(18) DEFAULT NULL COMMENT '发证日期',
  `name` varchar(50) DEFAULT NULL COMMENT '姓名',
  `idNum` varchar(18) DEFAULT NULL COMMENT '身份证号',
  `gender` varchar(2) DEFAULT NULL COMMENT '性别',
  `gradeLevel` varchar(5) DEFAULT NULL COMMENT '等级',
  `cerNo` varchar(50) DEFAULT NULL COMMENT '证书编号',
  `profession` varchar(50) DEFAULT NULL COMMENT '职业',
  `trainId` bigint(20) DEFAULT NULL COMMENT '培训机构id',
  `trainName` varchar(500) DEFAULT NULL COMMENT '培训机构',
  `trainStartDate` varchar(18) DEFAULT NULL COMMENT '培训开始日期',
  `trainEndDate` varchar(18) DEFAULT NULL COMMENT '培训结束日期',
  `comId` bigint(20) DEFAULT NULL COMMENT '公司id',
  `comName` varchar(500) DEFAULT NULL COMMENT '公司名称',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='保安员等级证报名结业证书';


delete from sys_sequence where seqName = 'seq_Complete_Cer';
INSERT INTO `sys_sequence` (`seqName`, `currentValue`, `increment`, `description`)
VALUES ('seq_Complete_Cer', '202000000', '1', '结业证书编号序号');


ALTER TABLE `sys_interface_log`
ADD COLUMN `successful`  bit NULL DEFAULT true COMMENT '接口调用结果 true成功/false失败' AFTER `update_by`;



delete from sys_dict where codeType='appealType';
INSERT INTO `sys_dict` (`isActive`, `codeType`, `tableName`, `description`, `codeValue`, `label`, `seq`)
VALUES ('1', 'appealType', NULL, '申诉类型', '001', '身份认证', '1'),
('1', 'appealType', NULL, '申诉类型', '002', '等级证', '2');

delete from sys_dict where codeType='checkState';
INSERT INTO `sys_dict` (`isActive`, `codeType`, `tableName`, `description`, `codeValue`, `label`, `seq`)
VALUES ('1', 'checkState', NULL, '材料核对状态', '0', '未审批', '1'),
('1', 'checkState', NULL, '材料核对状态', '1', '审批通过', '2'),
('1', 'checkState', NULL, '材料核对状态', '2', '审批不通过', '3');


delete from sys_dict where codeType='classState';
INSERT INTO `sys_dict` (`isActive`, `codeType`, `tableName`, `description`, `codeValue`, `label`, `seq`)
VALUES ('1', 'classState', NULL, '开班安排状态', '0', '未开班', '1'),
('1', 'classState', NULL, '开班安排状态', '1', '已开班', '2');


delete from sys_dict where codeType='periodStatus';
INSERT INTO `sys_dict` (`isActive`, `codeType`, `tableName`, `description`, `codeValue`, `label`, `seq`)
VALUES ('1', 'periodStatus', NULL, '学时进度状态', '1', '完成', '1'),
('1', 'periodStatus', NULL, '学时进度状态', '0', '未完成', '2');

delete from sys_dict where codeType='gradePersonType';
INSERT INTO `sys_dict` (`isActive`, `codeType`, `tableName`, `description`, `codeValue`, `label`, `seq`)
VALUES ('1', 'gradePersonType', NULL, '人员类型', '1', '外省市来京务工人员', '1'),
('1', 'gradePersonType', NULL, '人员类型', '2', '本市登记失业人员', '2'),
('1', 'gradePersonType', NULL, '人员类型', '3', '本市农村转移就业劳动力', '3'),
('1', 'gradePersonType', NULL, '人员类型', '4', '本市应届高校毕业生', '4'),
('1', 'gradePersonType', NULL, '人员类型', '5', '本市复员专业军人', '5');

UPDATE `sys_dict` SET `codeValue`='0' WHERE codeType='testState' and codeValue='2' and seq='2';

ALTER TABLE `security_company`
ADD COLUMN `officeAreaCode`  varchar(255) NULL COMMENT '办公区域编码' AFTER `local`;

ALTER TABLE `security_company`
MODIFY COLUMN `officeAreaCode`  varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '办公区域编码' AFTER `local`,
ADD COLUMN `officeOrgId`  varchar(20) NULL COMMENT '办公区域监管机构' AFTER `officeAreaCode`;

ALTER TABLE `security_company`
MODIFY COLUMN `officeOrgId`  varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '办公区域监管机构ID' AFTER `officeAreaCode`,
ADD COLUMN `officeOrgName`  varchar(50) NULL COMMENT '办公区域监管机构名称' AFTER `officeOrgId`;


DROP TABLE IF EXISTS `cloud_conference`;
CREATE TABLE `cloud_conference` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `active` bit(1) DEFAULT b'1',
  `createTime` datetime DEFAULT NULL,
  `updateTime` datetime DEFAULT NULL,
  `userid` bigint(20) DEFAULT NULL,
  `accountId` bigint(20) DEFAULT NULL,
  `meetId` varchar(30) DEFAULT NULL COMMENT '华为云会议id',
  `theme` varchar(500) DEFAULT NULL COMMENT '会议主题',
  `type` varchar(5) DEFAULT NULL COMMENT '会议类型',
  `subscribe` bit(1) DEFAULT NULL COMMENT '是否预约',
  `hd` bit(1) DEFAULT NULL COMMENT '是否高清会议',
  `notice` bit(1) DEFAULT NULL COMMENT '是否短信通知',
  `duration` int(11) DEFAULT NULL COMMENT '会议时长（分钟）',
  `startTime` varchar(20) DEFAULT NULL COMMENT '会议开始时间',
  `endTime` varchar(20) DEFAULT NULL COMMENT '会议结束时间',
  `state` varchar(5) DEFAULT NULL COMMENT '会议状态',
  `chairPwd` varchar(30) DEFAULT NULL COMMENT '主席密码',
  `generalPwd` varchar(30) DEFAULT NULL COMMENT '来宾密码',
  `confUUID` varchar(100) DEFAULT NULL,
  `chairman` varchar(10) DEFAULT NULL COMMENT '会议是否有主席',
  `conferenceModel` varchar(10) DEFAULT NULL COMMENT '会议模式1个人会议2云会议模式',
  `vmrID` varchar(50) DEFAULT NULL COMMENT '会议ID类型',
  `vmrName` varchar(100) DEFAULT NULL COMMENT '云会议室名称',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=268 DEFAULT CHARSET=utf8;


delete from sys_dict where codeType='conferenceModel';
INSERT INTO `sys_dict` (`sysDictId`, `isActive`, `codeType`, `tableName`, `description`, `codeValue`, `label`, `seq`) VALUES (null, '1', 'conferenceModel', NULL, '会议模式', '1', '个人会议', '1');
INSERT INTO `sys_dict` (`sysDictId`, `isActive`, `codeType`, `tableName`, `description`, `codeValue`, `label`, `seq`) VALUES (null, '1', 'conferenceModel', '', '会议模式', '2', '云会议', '2');



#等级证报名导出视图
drop view if EXISTS v_person_grade;
CREATE
VIEW `v_person_grade`AS
SELECT
	t1.id,
	t1.active,
	t1.create_time,
	t1.update_time,
	t1.update_by,
	t1.updateflag,
	t1.userid,
	t1.areaCode,
	t1.orgId,
	t1.personId,
	t1.name,
	t1.phone,
	t1.idNum,
	t1.applyTime,
	t1.trainId,
	t1.trainName,
	t1.testTime,
	t1.idFrontImg,
	t1.idBackImg,
	t1.headImg,
	t1.comId,
	t1.comName,
	t1.gradeLevel,
	t1.period,
	t1.periodStatus,
	t1.practiceStatus,
	t1.practiceDay,
	t1.practiceHour,
	t1.censorStatus,
	t1.address,
	t1.liveAddress,
	t1.residentType,
	t1.residentPlaceType,
	t1.contractId,
	t1.classId,
	t1.testStateComplete,
	t1.writtenScoreComplete,
	t1.operateScoreComplete,
	t1.sumScoreComplete,
	t1.zgCerNo,
	t1.zgCerUrl,
	t1.zgOrg,
	t1.zgTrainName,
	t1.zgIssueDate,
	t1.payTime,
	t1.payState,
	t1.checkState,
	t1.classState,
	t1.writtenScore,
	t1.operateScore,
	t1.sumScore,
	t1.testState,
	t1.approvalReason,
	t1.approvalState,
	t1.gradePersonType,
	t1.mainHomeUrl,
	t1.selfHomeUrl,
	t1.regCerUrl,
	t1.gradCerUrl,
	t1.empCerUrl,
	t1.laborTranCerUrl,
	t1.dischargeCerUrl,
	t1.selfEmpCerUrl,
	t1.demobCerUrl,
	t1.conversionCerUrl,
	t1.confirmCerUrl,
	t2.`name` as 'className',
	IF(t2.startTime is null,'',CONCAT(DATE_FORMAT(t2.startTime,'%Y-%m-%d'),' ~ ',DATE_FORMAT(t2.endTime,'%Y-%m-%d'))) as 'classStartTime'
	FROM sb_person_grade t1
	LEFT JOIN sb_grade_class t2 ON t1.classId = t2.id and t2.active = true
	where
	t1.active =true;
delete from sys_dict where codeType='gradeState';
delete from sys_dict where codeType='appprovalStateGradeClass';
INSERT INTO `sys_dict` (`sysDictId`, `isActive`, `codeType`, `tableName`, `description`, `codeValue`, `label`, `seq`) VALUES (null, '1', 'gradeState', NULL, '等级证报名状态', '1', '可报名', '1');
INSERT INTO `sys_dict` (`sysDictId`, `isActive`, `codeType`, `tableName`, `description`, `codeValue`, `label`, `seq`) VALUES (null, '1', 'gradeState', NULL, '等级证报名状态', '2', '已报名', '2');
INSERT INTO `sys_dict` (`sysDictId`, `isActive`, `codeType`, `tableName`, `description`, `codeValue`, `label`, `seq`) VALUES (null, '1', 'gradeState', NULL, '等级证报名状态', '3', '学习中', '3');
INSERT INTO `sys_dict` (`sysDictId`, `isActive`, `codeType`, `tableName`, `description`, `codeValue`, `label`, `seq`) VALUES (null, '1', 'gradeState', NULL, '等级证报名状态', '4', '考试不合格', '4');
INSERT INTO `sys_dict` (`sysDictId`, `isActive`, `codeType`, `tableName`, `description`, `codeValue`, `label`, `seq`) VALUES (null, '1', 'gradeState', NULL, '等级证报名状态', '5', '考试合格', '5');
INSERT INTO `sys_dict` (`sysDictId`, `isActive`, `codeType`, `tableName`, `description`, `codeValue`, `label`, `seq`) VALUES (null, '1', 'gradeState', NULL, '等级证报名状态', '0', '已撤销', '6');
INSERT INTO `sys_dict` (`sysDictId`, `isActive`, `codeType`, `tableName`, `description`, `codeValue`, `label`, `seq`) VALUES (null, '1', 'appprovalStateGradeClass', '', '等级班级审批状态', '002', '待审批', '1');
INSERT INTO `sys_dict` (`sysDictId`, `isActive`, `codeType`, `tableName`, `description`, `codeValue`, `label`, `seq`) VALUES (null, '1', 'appprovalStateGradeClass', '', '等级班级审批状态', '003', '审批通过', '2');
INSERT INTO `sys_dict` (`sysDictId`, `isActive`, `codeType`, `tableName`, `description`, `codeValue`, `label`, `seq`) VALUES (null, '1', 'appprovalStateGradeClass', '', '等级班级审批状态', '004', '审批不通过', '3');
INSERT INTO `sys_dict` ( `isActive`, `codeType`, `tableName`, `description`, `codeValue`, `label`, `seq`)
VALUES ( '1', 'appprovalStateGradeClass', '', '等级班级审批状态', '006', '已取消', '4');
delete from  `module` where  id in(311,312,313);
INSERT INTO `module` (`id`, `native_code`, `code`, `name`, `url`, `seq`, `index`, `shortcut`, `class`, `action`, `active`, `create_time`, `update_time`, `update_by`, `moduletype`, `p_id`) VALUES ('311', '11', 'gradePracticeManager', '等级证实习记录', '', '2', '\0', '\0', '', '', '', '2017-06-30 18:00:19', '2017-06-30 18:00:21', 'system', '1', '142');
INSERT INTO `module` (`id`, `native_code`, `code`, `name`, `url`, `seq`, `index`, `shortcut`, `class`, `action`, `active`, `create_time`, `update_time`, `update_by`, `moduletype`, `p_id`) VALUES ('312', '11', 'gradeClassManager', '班级管理', '', '2', '\0', '\0', '', '', '', '2017-06-30 18:00:19', '2017-06-30 18:00:21', 'system', '1', '142');
INSERT INTO `module` (`id`, `native_code`, `code`, `name`, `url`, `seq`, `index`, `shortcut`, `class`, `action`, `active`, `create_time`, `update_time`, `update_by`, `moduletype`, `p_id`) VALUES ('313', '11', 'personGradeManager', '保安员等级证考试报名', '', '2', '\0', '\0', '', '', '', '2017-06-30 18:00:19', '2017-06-30 18:00:21', 'system', '1', '142');

delete from  `operation` where  module_id in(311,312,313);


INSERT INTO `operation` (`id`, `native_code`, `code`, `name`, `module_id`, `active`, `create_time`, `update_time`, `update_by`) VALUES (null, '11', 'toQueryPage', '进入查询页面', '311', '', '2019-10-15 13:19:09', '2019-10-15 13:19:09', 'system');
INSERT INTO `operation` (`id`, `native_code`, `code`, `name`, `module_id`, `active`, `create_time`, `update_time`, `update_by`) VALUES (null, '11', 'query', '查询', '311', '', '2019-10-15 13:19:09', '2019-10-15 13:19:09', 'system');
INSERT INTO `operation` (`id`, `native_code`, `code`, `name`, `module_id`, `active`, `create_time`, `update_time`, `update_by`) VALUES (null, '11', 'export', '导出', '311', '', '2019-10-15 13:19:09', '2019-10-15 13:19:09', 'system');
INSERT INTO `operation` (`id`, `native_code`, `code`, `name`, `module_id`, `active`, `create_time`, `update_time`, `update_by`) VALUES (null, '11', 'toQueryPage', '进入查询页面', '312', '', '2019-10-15 13:19:09', '2019-10-15 13:19:09', 'system');
INSERT INTO `operation` (`id`, `native_code`, `code`, `name`, `module_id`, `active`, `create_time`, `update_time`, `update_by`) VALUES (null, '11', 'query', '查询', '312', '', '2019-10-15 13:19:09', '2019-10-15 13:19:09', 'system');
INSERT INTO `operation` (`id`, `native_code`, `code`, `name`, `module_id`, `active`, `create_time`, `update_time`, `update_by`) VALUES (null, '11', 'export', '导出', '312', '', '2019-10-15 13:19:09', '2019-10-15 13:19:09', 'system');
INSERT INTO `operation` (`id`, `native_code`, `code`, `name`, `module_id`, `active`, `create_time`, `update_time`, `update_by`) VALUES (null, '11', 'view', '查看', '312', '', '2019-10-15 13:19:09', '2019-10-15 13:19:09', 'system');
INSERT INTO `operation` (`id`, `native_code`, `code`, `name`, `module_id`, `active`, `create_time`, `update_time`, `update_by`) VALUES (null, '11', 'saveAppealApproval', '查看', '312', '', '2019-10-15 13:19:09', '2019-10-15 13:19:09', 'system');
INSERT INTO `operation` (`id`, `native_code`, `code`, `name`, `module_id`, `active`, `create_time`, `update_time`, `update_by`) VALUES (null, '11', 'toQueryPage', '进入查询页面', '313', '', '2019-10-15 13:19:09', '2019-10-15 13:19:09', 'system');
INSERT INTO `operation` (`id`, `native_code`, `code`, `name`, `module_id`, `active`, `create_time`, `update_time`, `update_by`) VALUES (null, '11', 'query', '查询', '313', '', '2019-10-15 13:19:09', '2019-10-15 13:19:09', 'system');
INSERT INTO `operation` (`id`, `native_code`, `code`, `name`, `module_id`, `active`, `create_time`, `update_time`, `update_by`) VALUES (null, '11', 'export', '导出', '313', '', '2019-10-15 13:19:09', '2019-10-15 13:19:09', 'system');




INSERT INTO`permission` (`native_code`, `role_id`, `module_id`, `operation_id`, `roletype`)
select '45',pr.id,o.module_id,o.id,'2' from police_role pr,police p,operation o
where pr.active=true
and p.active=TRUE
and o.active=TRUE
and pr.orgid=p.id
and o.module_id in(311,312,313);;



ALTER TABLE `sb_person_grade`
ADD COLUMN `practiceStatus`  varchar(5) NULL COMMENT '实习状态' AFTER `periodStatus`;


delete from sys_dict where codeType='practiceStatus';
INSERT INTO `sys_dict` (`isActive`, `codeType`, `tableName`, `description`, `codeValue`, `label`, `seq`)
VALUES ('1', 'practiceStatus', NULL, '实习状态', '1', '完成', '1'),
('1', 'practiceStatus', NULL, '实习状态', '0', '未完成', '2');
