

DROP TABLE IF EXISTS `conference_account`;
CREATE TABLE `conference_account` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `active` bit(1) DEFAULT true,
  `createTime` datetime DEFAULT NULL,
  `updateTime` datetime DEFAULT NULL,
  `userid` bigint(20) DEFAULT NULL,
  `account` varchar(255) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `cloud_conference`;
CREATE TABLE `cloud_conference` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `active` bit(1) DEFAULT true,
  `createTime` datetime DEFAULT NULL,
  `updateTime` datetime DEFAULT NULL,
  `userid` bigint(20) DEFAULT NULL,
  `accountId` bigint(20) DEFAULT NULL,
  `meetId` varchar(30) DEFAULT NULL COMMENT '华为云会议id',
  `theme` varchar(500) DEFAULT NULL COMMENT '会议主题',
  `type` varchar(5) DEFAULT NULL COMMENT '会议类型',
  `subscribe` bit(1) DEFAULT NULL COMMENT '是否预约',
  `hd` bit(1) DEFAULT NULL COMMENT '是否高清会议',
  `notice` bit(1) DEFAULT NULL COMMENT '是否短信通知',
  `duration` int(11) DEFAULT NULL COMMENT '会议时长（分钟）',
  `startTime` varchar(20) DEFAULT NULL COMMENT '会议开始时间',
  `endTime` varchar(20) DEFAULT NULL COMMENT '会议结束时间',
  `state` varchar(5) DEFAULT NULL COMMENT '会议状态',
  `chairPwd` varchar(30) DEFAULT NULL COMMENT '主席密码',
  `generalPwd` varchar(30) DEFAULT NULL COMMENT '来宾密码',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

ALTER TABLE `cloud_conference`
ADD COLUMN `confUUID`  varchar(100) NULL COMMENT '会议uuid';


DROP TABLE IF EXISTS `conference_member`;
CREATE TABLE `conference_member` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `active` bit(1) DEFAULT true,
  `createTime` datetime DEFAULT NULL,
  `updateTime` datetime DEFAULT NULL,
  `userid` bigint(20) DEFAULT NULL,
  `conferenceId` bigint(20) DEFAULT NULL,
  `accountId` bigint(20) DEFAULT NULL,
  `conferenceRole` varchar(5) DEFAULT NULL COMMENT '会议角色',
  `name` varchar(500) DEFAULT NULL COMMENT '姓名',
  `mute` bit(1) DEFAULT NULL COMMENT '是否静音',
  `memberState` varchar(5) DEFAULT NULL COMMENT '会议成员状态',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



delete from sys_dict where codeType='conferenceType';
INSERT INTO `sys_dict` (`isActive`, `codeType`, `tableName`, `description`, `codeValue`, `label`, `seq`)
VALUES ('1', 'conferenceType', NULL, '会议类型', '0', '音频', '1'),
('1', 'conferenceType', NULL, '会议类型', '1', '视频', '2');

delete from sys_dict where codeType='conferenceState';
INSERT INTO `sys_dict` (`isActive`, `codeType`, `tableName`, `description`, `codeValue`, `label`, `seq`)
VALUES
('1', 'conferenceState', NULL, '会议状态', '0', '取消', '1'),
('1', 'conferenceState', NULL, '会议状态', '1', '进行中', '2'),
('1', 'conferenceState', NULL, '会议状态', '2', '未开始', '3'),
('1', 'conferenceState', NULL, '会议状态', '3', '结束', '4');


delete from sys_dict where codeType='conferenceRole';
INSERT INTO `sys_dict` (`isActive`, `codeType`, `tableName`, `description`, `codeValue`, `label`, `seq`)
VALUES ('1', 'conferenceRole', NULL, '会议角色', '1', '主席', '1'),
('1', 'conferenceRole', NULL, '会议角色', '2', '来宾', '2');
