ALTER TABLE `problemperson`
DROP COLUMN `dispose`;

ALTER TABLE `problemperson`
ADD COLUMN `dispose`  varchar(3) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '是否处理1处理0未处理' AFTER `wf`;

ALTER TABLE `problemperson`
ADD COLUMN `orgId`  bigint(20) NULL COMMENT '监管机构' AFTER `dispose`;

ALTER TABLE `problemperson`
ADD COLUMN `orgName`  varchar(255) NULL COMMENT '监管机构' AFTER `orgId`;

ALTER TABLE `problemperson`
ADD COLUMN `updateflag`  bit(1) NULL COMMENT '修改标识' AFTER `orgName`;

ALTER TABLE `problemperson`
ADD COLUMN `areaCode`  varchar(10) NULL COMMENT '所属区域' AFTER `updateflag`;

ALTER TABLE `problemperson`
ADD COLUMN `incumbencyStatus`  varchar(10) NULL COMMENT '就职状态1在职0离职' AFTER `areaCode`;


DROP TABLE IF EXISTS `person_black_list`;

CREATE TABLE `person_black_list` (
  `id` bigint(20) NOT NULL,
  `active` bit(1) NOT NULL COMMENT '是否有效',
  `create_time` datetime NOT NULL COMMENT '创建时间',
  `update_time` datetime NOT NULL COMMENT '修改时间',
  `update_by` varchar(50) NOT NULL COMMENT '修改者',
  `realName` varchar(50) DEFAULT NULL COMMENT '姓名',
  `phone` varchar(20) DEFAULT NULL COMMENT '手机',
  `idNum` varchar(50) DEFAULT NULL COMMENT '身份证号',
  `address` varchar(100) DEFAULT NULL COMMENT '现住址',
  `reason` varchar(300) DEFAULT NULL COMMENT '入单原因',
  `sex` varchar(5) DEFAULT NULL COMMENT '性别',
  `orgName` varchar(100) DEFAULT NULL COMMENT '登记机构名',
  `registrant` varchar(100) DEFAULT NULL COMMENT '登记人',
  `orgId` bigint(20) DEFAULT NULL COMMENT '登记机构id',
  `registerDate` varchar(20) DEFAULT NULL COMMENT '登记时间',
  `updateflag` bit(1) DEFAULT NULL COMMENT '更新标志位',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='保安员行业黑名单表';


ALTER TABLE `security_company`
ADD COLUMN `orgName`  varchar(100) NULL COMMENT '监管机构名' AFTER `operatorname`;
ALTER TABLE `security_company`
ADD COLUMN `orgId`  varchar(20) NULL COMMENT '监管机构id' AFTER `operatorname`;

ALTER TABLE `security_company`
ADD COLUMN `securityScopeType`  varchar(100) NULL COMMENT '服务范围' AFTER `operatorname`;




delete from  `sys_dict` where codeType ='dispose';

INSERT INTO `sys_dict` (`sysDictId`, `isActive`, `codeType`, `tableName`, `description`, `codeValue`, `label`, `seq`) VALUES (null, '1', 'dispose', NULL, '是否处理', '1', '处理', '1');
INSERT INTO `sys_dict` (`sysDictId`, `isActive`, `codeType`, `tableName`, `description`, `codeValue`, `label`, `seq`) VALUES (null, '1', 'dispose', NULL, '是否处理', '0', '未处理', '2');





update security_company sc,
(select scs.company_id,GROUP_CONCAT(DISTINCT scs.scope_id) as scope from security_company_scope scs GROUP BY scs.company_id
)scs set sc.securityScopeType=scope
where sc.active=true and sc.id=scs.company_id ;


delete from `sys_dict` where `codeType` = 'sponsorlicenseType';
INSERT INTO `sys_dict` (`isActive`, `codeType`, `tableName`, `description`, `codeValue`, `label`, `seq`)
VALUES ('1', 'sponsorlicenseType', NULL, '保安公司类型', '01', '普通保安服务公司', '1'),
('1', 'sponsorlicenseType', NULL, '保安公司类型', '02', '武装押运保安服务公司', '2'),
('1', 'sponsorlicenseType', NULL, '保安公司类型', '03', '中外合资保安服务公司', '3');




##修正在职人数
update security_company sc,
(
SELECT
	sc.id,
	count(sp.id) as num
FROM
	security_company sc,
	security_person sp,
	security_company_person scp
WHERE
	sc.active = TRUE
AND scp.active = TRUE
AND sp.id = scp.person_id
AND scp.company_id = sc.id
GROUP BY
	sc.id
)t
set sc.security_amount=t.num
where t.id=sc.id;





DELETE from `sys_dict` where `codeType`='securityProfessionLevel';
INSERT INTO`sys_dict` (`isActive`, `codeType`, `tableName`, `description`, `codeValue`, `label`, `seq`)
select '1','securityProfessionLevel',NULL,'保安员等级',id,`level`,seq from security_profession_level;

DELETE from `sys_dict` where `codeType`='idType';
INSERT INTO `sys_dict` (`isActive`, `codeType`, `tableName`, `description`, `codeValue`, `label`, `seq`)
VALUES ('1', 'idType', NULL, '证件类型', '1', '身份证', '1'),
('1', 'idType', NULL, '证件类型', '2', '港澳台身份证', '2'),
('1', 'idType', NULL, '证件类型', '3', '护照', '3');


DELETE from `sys_dict` where `codeType`='identityAuthState';
INSERT INTO`sys_dict` (`isActive`, `codeType`, `tableName`, `description`, `codeValue`, `label`, `seq`)
VALUES ('1', 'identityAuthState', NULL, '实名认证', '0', '已认证', '1'),
('1', 'identityAuthState', NULL, '实名认证', '1', '未认证', '2');

DELETE from `sys_dict` where `codeType`='isSubsidiary';
INSERT INTO`sys_dict` (`isActive`, `codeType`, `tableName`, `description`, `codeValue`, `label`, `seq`)
VALUES ('1', 'isSubsidiary', NULL, '是否分公司', '0', '否', '1'),
('1', 'isSubsidiary', NULL, '是否分公司', '1', '是', '2');


DELETE from `sys_dict` where `codeType`='incumbencyStatus';
INSERT INTO`sys_dict` (`isActive`, `codeType`, `tableName`, `description`, `codeValue`, `label`, `seq`)
VALUES ('1', 'incumbencyStatus', NULL, '在职状态', '1', '在职', '1'),
('1', 'incumbencyStatus', NULL, '在职状态', '0', '离职', '2');


DELETE from `sys_dict` where `codeType`='certificateState';
INSERT INTO`sys_dict` (`isActive`, `codeType`, `tableName`, `description`, `codeValue`, `label`, `seq`)
VALUES ('1', 'certificateState', NULL, '资格证持证状态', '1', '持证', '1'),
('1', 'certificateState', NULL, '资格证持证状态', '0', '未持证', '2');

DELETE from `sys_dict` where `codeType`='investorsType';
INSERT INTO`sys_dict` (`isActive`, `codeType`, `tableName`, `description`, `codeValue`, `label`, `seq`)
VALUES ('1', 'investorsType', NULL, '股东类型', '1', '自然人股东', '1'),
('1', 'investorsType', NULL, '股东类型', '2', '机构股东', '2');


DELETE from `sys_dict` where `codeType`='companyState';
INSERT INTO`sys_dict` (`isActive`, `codeType`, `tableName`, `description`, `codeValue`, `label`, `seq`)
VALUES ('1', 'companyState', NULL, '公司状态', '0', '未登录系统', '1'),
('1', 'companyState', NULL, '公司状态', '1', '正常', '2'),
('1', 'companyState', NULL, '公司状态', '2', '关闭', '3'),
('1', 'companyState', NULL, '公司状态', '3', '吊销', '4');


DELETE from `sys_dict` where `codeType`='institutionType';
INSERT INTO`sys_dict` (`isActive`, `codeType`, `tableName`, `description`, `codeValue`, `label`, `seq`)
VALUES ('1', 'institutionType', NULL, '机构类型', '0102', '保安服务公司', '1'),
('1', 'institutionType', NULL, '机构类型', '0103', '保安培训单位', '2'),
('1', 'institutionType', NULL, '机构类型', '0104', '自行招用保安单位', '3'),
('1', 'institutionType', NULL, '机构类型', '0105', '保安服务分公司', '4');

DELETE from `sys_dict` where `codeType`='humanDefenseLevel';
DELETE from `sys_dict` where `codeType`='securityTechnologyLevel';
DELETE from `sys_dict` where `codeType`='riskAssessmentLevel';
DELETE from `sys_dict` where `codeType`='armedEscortLevel';
INSERT INTO`sys_dict` (`isActive`, `codeType`, `tableName`, `description`, `codeValue`, `label`, `seq`)
VALUES ('1', 'humanDefenseLevel', NULL, '人力防范等级', '1', '一级', '1'),
('1', 'humanDefenseLevel', NULL, '人力防范等级', '2', '二级', '2'),
('1', 'humanDefenseLevel', NULL, '人力防范等级', '3', '三级', '3'),

('1', 'securityTechnologyLevel', NULL, '安全技术防范等级', '1', '一级', '1'),
('1', 'securityTechnologyLevel', NULL, '安全技术防范等级', '2', '二级', '2'),
('1', 'securityTechnologyLevel', NULL, '安全技术防范等级', '3', '三级', '3'),

('1', 'riskAssessmentLevel', NULL, '风险评估等级', '1', '一级', '1'),
('1', 'riskAssessmentLevel', NULL, '风险评估等级', '2', '二级', '2'),
('1', 'riskAssessmentLevel', NULL, '风险评估等级', '3', '三级', '3'),

('1', 'armedEscortLevel', NULL, '武装押运守护等级', '1', '一级', '1'),
('1', 'armedEscortLevel', NULL, '武装押运守护等级', '2', '二级', '2'),
('1', 'armedEscortLevel', NULL, '武装押运守护等级', '3', '三级', '3');


DELETE from `sys_dict` where `codeType`='national';
INSERT INTO`sys_dict` (`isActive`, `codeType`, `tableName`, `description`, `codeValue`, `label`, `seq`)
VALUES('1', 'national', NULL, '国家', '中国','中国',1),
('1', 'national', NULL, '国家', '阿鲁巴','阿鲁巴',2),
('1', 'national', NULL, '国家', '阿富汗','阿富汗',3),
('1', 'national', NULL, '国家', '安哥拉','安哥拉',4),
('1', 'national', NULL, '国家', '安圭拉','安圭拉',5),
('1', 'national', NULL, '国家', '阿尔巴尼亚','阿尔巴尼亚',6),
('1', 'national', NULL, '国家', '安道尔','安道尔',7),
('1', 'national', NULL, '国家', '荷属安的列斯','荷属安的列斯',8),
('1', 'national', NULL, '国家', '阿联酋','阿联酋',9),
('1', 'national', NULL, '国家', '阿根廷','阿根廷',10),
('1', 'national', NULL, '国家', '亚美尼亚','亚美尼亚',11),
('1', 'national', NULL, '国家', '美属萨摩亚','美属萨摩亚',12),
('1', 'national', NULL, '国家', '南极洲','南极洲',13),
('1', 'national', NULL, '国家', '法属南部领土','法属南部领土',14),
('1', 'national', NULL, '国家', '安提瓜和巴布达','安提瓜和巴布达',15),
('1', 'national', NULL, '国家', '澳大利亚','澳大利亚',16),
('1', 'national', NULL, '国家', '奥地利','奥地利',17),
('1', 'national', NULL, '国家', '阿塞拜疆','阿塞拜疆',18),
('1', 'national', NULL, '国家', '布隆迪','布隆迪',19),
('1', 'national', NULL, '国家', '比利时','比利时',20),
('1', 'national', NULL, '国家', '贝宁','贝宁',21),
('1', 'national', NULL, '国家', '布基纳法索','布基纳法索',22),
('1', 'national', NULL, '国家', '孟加拉国','孟加拉国',23),
('1', 'national', NULL, '国家', '保加利亚','保加利亚',24),
('1', 'national', NULL, '国家', '巴林','巴林',25),
('1', 'national', NULL, '国家', '巴哈马','巴哈马',26),
('1', 'national', NULL, '国家', '波斯尼亚和黑塞哥维那','波斯尼亚和黑塞哥维那',27),
('1', 'national', NULL, '国家', '白俄罗斯','白俄罗斯',28),
('1', 'national', NULL, '国家', '伯利兹','伯利兹',29),
('1', 'national', NULL, '国家', '百幕大','百幕大',30),
('1', 'national', NULL, '国家', '玻利维亚','玻利维亚',31),
('1', 'national', NULL, '国家', '巴西','巴西',32),
('1', 'national', NULL, '国家', '巴巴多斯','巴巴多斯',33),
('1', 'national', NULL, '国家', '文莱文莱/n','文莱文莱/n',34),
('1', 'national', NULL, '国家', '不丹','不丹',35),
('1', 'national', NULL, '国家', '布维岛','布维岛',36),
('1', 'national', NULL, '国家', '博茨瓦纳','博茨瓦纳',37),
('1', 'national', NULL, '国家', '中非','中非',38),
('1', 'national', NULL, '国家', '加拿大','加拿大',39),
('1', 'national', NULL, '国家', '科科斯群岛','科科斯群岛',40),
('1', 'national', NULL, '国家', '瑞士','瑞士',41),
('1', 'national', NULL, '国家', '智利','智利',42),
('1', 'national', NULL, '国家', '科特迪瓦','科特迪瓦',43),
('1', 'national', NULL, '国家', '喀麦隆','喀麦隆',44),
('1', 'national', NULL, '国家', '刚果民主共和国','刚果民主共和国',45),
('1', 'national', NULL, '国家', '刚果','刚果',46),
('1', 'national', NULL, '国家', '库克群岛','库克群岛',47),
('1', 'national', NULL, '国家', '哥伦比亚','哥伦比亚',48),
('1', 'national', NULL, '国家', '科摩罗','科摩罗',49),
('1', 'national', NULL, '国家', '佛得角','佛得角',50),
('1', 'national', NULL, '国家', '哥斯达黎加','哥斯达黎加',51),
('1', 'national', NULL, '国家', '古巴','古巴',52),
('1', 'national', NULL, '国家', '圣诞岛','圣诞岛',53),
('1', 'national', NULL, '国家', '开曼群岛','开曼群岛',54),
('1', 'national', NULL, '国家', '塞浦路斯','塞浦路斯',55),
('1', 'national', NULL, '国家', '捷克','捷克',56),
('1', 'national', NULL, '国家', '德国','德国',57),
('1', 'national', NULL, '国家', '吉布提','吉布提',58),
('1', 'national', NULL, '国家', '多米尼加','多米尼加',59),
('1', 'national', NULL, '国家', '丹麦','丹麦',60),
('1', 'national', NULL, '国家', '多米尼家共和国','多米尼家共和国',61),
('1', 'national', NULL, '国家', '阿尔及利亚','阿尔及利亚',62),
('1', 'national', NULL, '国家', '厄瓜多尔','厄瓜多尔',63),
('1', 'national', NULL, '国家', '埃及','埃及',64),
('1', 'national', NULL, '国家', '厄立特里亚','厄立特里亚',65),
('1', 'national', NULL, '国家', '西撒哈拉','西撒哈拉',66),
('1', 'national', NULL, '国家', '西班牙','西班牙',67),
('1', 'national', NULL, '国家', '爱沙尼亚','爱沙尼亚',68),
('1', 'national', NULL, '国家', '埃塞俄比亚','埃塞俄比亚',69),
('1', 'national', NULL, '国家', '芬兰','芬兰',70),
('1', 'national', NULL, '国家', '斐济','斐济',71),
('1', 'national', NULL, '国家', '马尔维纳斯群岛','马尔维纳斯群岛',72),
('1', 'national', NULL, '国家', '法国','法国',73),
('1', 'national', NULL, '国家', '法罗群岛','法罗群岛',74),
('1', 'national', NULL, '国家', '密克罗尼西亚','密克罗尼西亚',75),
('1', 'national', NULL, '国家', '加蓬','加蓬',76),
('1', 'national', NULL, '国家', '英国（独立领土公民、出国不用）','英国（独立领土公民、出国不用）',77),
('1', 'national', NULL, '国家', '英国（海外国民，出国不用）','英国（海外国民，出国不用）',78),
('1', 'national', NULL, '国家', '英国（海外公民，出国不用）','英国（海外公民，出国不用）',79),
('1', 'national', NULL, '国家', '英国（保护公民，出国不用）','英国（保护公民，出国不用）',80),
('1', 'national', NULL, '国家', '英国','英国',81),
('1', 'national', NULL, '国家', '英国（隶属，出国不用）','英国（隶属，出国不用）',82),
('1', 'national', NULL, '国家', '格鲁吉亚','格鲁吉亚',83),
('1', 'national', NULL, '国家', '加纳','加纳',84),
('1', 'national', NULL, '国家', '直布罗陀','直布罗陀',85),
('1', 'national', NULL, '国家', '几内亚','几内亚',86),
('1', 'national', NULL, '国家', '瓜德罗普','瓜德罗普',87),
('1', 'national', NULL, '国家', '冈比亚','冈比亚',88),
('1', 'national', NULL, '国家', '几内亚比绍','几内亚比绍',89),
('1', 'national', NULL, '国家', '赤道几内亚','赤道几内亚',90),
('1', 'national', NULL, '国家', '希腊','希腊',91),
('1', 'national', NULL, '国家', '格林纳达','格林纳达',92),
('1', 'national', NULL, '国家', '格陵兰','格陵兰',93),
('1', 'national', NULL, '国家', '危地马拉','危地马拉',94),
('1', 'national', NULL, '国家', '法属圭亚那','法属圭亚那',95),
('1', 'national', NULL, '国家', '关岛','关岛',96),
('1', 'national', NULL, '国家', '圭亚那','圭亚那',97),
('1', 'national', NULL, '国家', '香港','香港',98),
('1', 'national', NULL, '国家', '赫德岛和麦克唐纳岛','赫德岛和麦克唐纳岛',99),
('1', 'national', NULL, '国家', '洪都拉斯','洪都拉斯',100),
('1', 'national', NULL, '国家', '克罗地亚','克罗地亚',101),
('1', 'national', NULL, '国家', '海地','海地',102),
('1', 'national', NULL, '国家', '匈牙利','匈牙利',103),
('1', 'national', NULL, '国家', '印度尼西亚','印度尼西亚',104),
('1', 'national', NULL, '国家', '印度','印度',105),
('1', 'national', NULL, '国家', '英属印度洋领土','英属印度洋领土',106),
('1', 'national', NULL, '国家', '爱尔兰','爱尔兰',107),
('1', 'national', NULL, '国家', '伊朗','伊朗',108),
('1', 'national', NULL, '国家', '伊拉克','伊拉克',109),
('1', 'national', NULL, '国家', '冰岛','冰岛',110),
('1', 'national', NULL, '国家', '以色列','以色列',111),
('1', 'national', NULL, '国家', '意大利','意大利',112),
('1', 'national', NULL, '国家', '牙买加','牙买加',113),
('1', 'national', NULL, '国家', '约旦','约旦',114),
('1', 'national', NULL, '国家', '日本日本/n','日本日本/n',115),
('1', 'national', NULL, '国家', '约翰斯顿岛','约翰斯顿岛',116),
('1', 'national', NULL, '国家', '哈萨克斯坦','哈萨克斯坦',117),
('1', 'national', NULL, '国家', '肯尼亚','肯尼亚',118),
('1', 'national', NULL, '国家', '吉尔吉斯斯坦','吉尔吉斯斯坦',119),
('1', 'national', NULL, '国家', '柬埔寨','柬埔寨',120),
('1', 'national', NULL, '国家', '基里巴斯','基里巴斯',121),
('1', 'national', NULL, '国家', '圣基茨和尼维斯','圣基茨和尼维斯',122),
('1', 'national', NULL, '国家', '韩国（南朝鲜','韩国（南朝鲜',123),
('1', 'national', NULL, '国家', '科威特','科威特',124),
('1', 'national', NULL, '国家', '老挝','老挝',125),
('1', 'national', NULL, '国家', '黎巴嫩','黎巴嫩',126),
('1', 'national', NULL, '国家', '利比里亚','利比里亚',127),
('1', 'national', NULL, '国家', '利比亚','利比亚',128),
('1', 'national', NULL, '国家', '圣卢西亚','圣卢西亚',129),
('1', 'national', NULL, '国家', '列支敦土登','列支敦土登',130),
('1', 'national', NULL, '国家', '斯里兰卡','斯里兰卡',131),
('1', 'national', NULL, '国家', '莱索托','莱索托',132),
('1', 'national', NULL, '国家', '立陶宛','立陶宛',133),
('1', 'national', NULL, '国家', '卢森堡','卢森堡',134),
('1', 'national', NULL, '国家', '拉脱维亚','拉脱维亚',135),
('1', 'national', NULL, '国家', '澳门','澳门',136),
('1', 'national', NULL, '国家', '摩洛哥','摩洛哥',137),
('1', 'national', NULL, '国家', '摩纳哥','摩纳哥',138),
('1', 'national', NULL, '国家', '摩尔多瓦','摩尔多瓦',139),
('1', 'national', NULL, '国家', '马达加斯加','马达加斯加',140),
('1', 'national', NULL, '国家', '马尔代夫','马尔代夫',141),
('1', 'national', NULL, '国家', '墨西哥','墨西哥',142),
('1', 'national', NULL, '国家', '马绍尔群岛','马绍尔群岛',143),
('1', 'national', NULL, '国家', '中途岛','中途岛',144),
('1', 'national', NULL, '国家', '马其顿','马其顿',145),
('1', 'national', NULL, '国家', '马里','马里',146),
('1', 'national', NULL, '国家', '马耳他','马耳他',147),
('1', 'national', NULL, '国家', '缅甸','缅甸',148),
('1', 'national', NULL, '国家', '蒙古','蒙古',149),
('1', 'national', NULL, '国家', '北马里亚纳','北马里亚纳',150),
('1', 'national', NULL, '国家', '莫桑比克','莫桑比克',151),
('1', 'national', NULL, '国家', '毛里塔尼亚','毛里塔尼亚',152),
('1', 'national', NULL, '国家', '蒙特塞拉特','蒙特塞拉特',153),
('1', 'national', NULL, '国家', '马提尼克','马提尼克',154),
('1', 'national', NULL, '国家', '毛里求斯','毛里求斯',155),
('1', 'national', NULL, '国家', '马拉维','马拉维',156),
('1', 'national', NULL, '国家', '马来西亚','马来西亚',157),
('1', 'national', NULL, '国家', '马约特','马约特',158),
('1', 'national', NULL, '国家', '纳米比亚','纳米比亚',159),
('1', 'national', NULL, '国家', '新喀里多尼亚','新喀里多尼亚',160),
('1', 'national', NULL, '国家', '尼日尔','尼日尔',161),
('1', 'national', NULL, '国家', '诺福克岛','诺福克岛',162),
('1', 'national', NULL, '国家', '尼日利亚','尼日利亚',163),
('1', 'national', NULL, '国家', '尼加拉瓜','尼加拉瓜',164),
('1', 'national', NULL, '国家', '纽埃','纽埃',165),
('1', 'national', NULL, '国家', '荷兰','荷兰',166),
('1', 'national', NULL, '国家', '挪威','挪威',167),
('1', 'national', NULL, '国家', '尼波尔','尼波尔',168),
('1', 'national', NULL, '国家', '瑙鲁','瑙鲁',169),
('1', 'national', NULL, '国家', '中间地带','中间地带',170),
('1', 'national', NULL, '国家', '新西兰','新西兰',171),
('1', 'national', NULL, '国家', '阿曼','阿曼',172),
('1', 'national', NULL, '国家', '巴基斯坦','巴基斯坦',173),
('1', 'national', NULL, '国家', '巴拿马','巴拿马',174),
('1', 'national', NULL, '国家', '皮特凯恩群岛','皮特凯恩群岛',175),
('1', 'national', NULL, '国家', '秘鲁','秘鲁',176),
('1', 'national', NULL, '国家', '菲律宾','菲律宾',177),
('1', 'national', NULL, '国家', '贝劳','贝劳',178),
('1', 'national', NULL, '国家', '巴布亚新几内亚','巴布亚新几内亚',179),
('1', 'national', NULL, '国家', '波兰','波兰',180),
('1', 'national', NULL, '国家', '波多黎各','波多黎各',181),
('1', 'national', NULL, '国家', '朝鲜','朝鲜',182),
('1', 'national', NULL, '国家', '葡萄牙','葡萄牙',183),
('1', 'national', NULL, '国家', '巴拉圭','巴拉圭',184),
('1', 'national', NULL, '国家', '巴勒斯坦','巴勒斯坦',185),
('1', 'national', NULL, '国家', '法属菠利尼西亚','法属菠利尼西亚',186),
('1', 'national', NULL, '国家', '卡塔尔','卡塔尔',187),
('1', 'national', NULL, '国家', '留尼汪','留尼汪',188),
('1', 'national', NULL, '国家', '罗马尼亚','罗马尼亚',189),
('1', 'national', NULL, '国家', '俄罗斯','俄罗斯',190),
('1', 'national', NULL, '国家', '卢旺达','卢旺达',191),
('1', 'national', NULL, '国家', '沙特阿拉伯','沙特阿拉伯',192),
('1', 'national', NULL, '国家', '苏丹','苏丹',193),
('1', 'national', NULL, '国家', '塞内加尔','塞内加尔',194),
('1', 'national', NULL, '国家', '新加坡新加坡/','新加坡新加坡/',195),
('1', 'national', NULL, '国家', '南乔治亚岛和南桑德韦奇岛','南乔治亚岛和南桑德韦奇岛',196),
('1', 'national', NULL, '国家', '圣赫勒拿','圣赫勒拿',197),
('1', 'national', NULL, '国家', '斯瓦尔巴群岛','斯瓦尔巴群岛',198),
('1', 'national', NULL, '国家', '所罗门群岛','所罗门群岛',199),
('1', 'national', NULL, '国家', '塞拉利昂','塞拉利昂',200),
('1', 'national', NULL, '国家', '萨尔瓦多','萨尔瓦多',201),
('1', 'national', NULL, '国家', '圣马力诺','圣马力诺',202),
('1', 'national', NULL, '国家', '索马里','索马里',203),
('1', 'national', NULL, '国家', '圣皮埃尔和密克隆','圣皮埃尔和密克隆',204),
('1', 'national', NULL, '国家', '塞班','塞班',205),
('1', 'national', NULL, '国家', '圣多美和普林西比','圣多美和普林西比',206),
('1', 'national', NULL, '国家', '苏里南','苏里南',207),
('1', 'national', NULL, '国家', '斯洛伐克','斯洛伐克',208),
('1', 'national', NULL, '国家', '斯洛文尼亚','斯洛文尼亚',209),
('1', 'national', NULL, '国家', '瑞典','瑞典',210),
('1', 'national', NULL, '国家', '斯威士兰','斯威士兰',211),
('1', 'national', NULL, '国家', '锡金','锡金',212),
('1', 'national', NULL, '国家', '塞尔维亚','塞尔维亚',213),
('1', 'national', NULL, '国家', '塞舌尔','塞舌尔',214),
('1', 'national', NULL, '国家', '叙利亚','叙利亚',215),
('1', 'national', NULL, '国家', '特克斯和凯科斯群岛','特克斯和凯科斯群岛',216),
('1', 'national', NULL, '国家', '乍得','乍得',217),
('1', 'national', NULL, '国家', '多哥','多哥',218),
('1', 'national', NULL, '国家', '泰国','泰国',219),
('1', 'national', NULL, '国家', '塔吉克斯坦','塔吉克斯坦',220),
('1', 'national', NULL, '国家', '托克劳','托克劳',221),
('1', 'national', NULL, '国家', '土库曼斯坦','土库曼斯坦',222),
('1', 'national', NULL, '国家', '东帝汶','东帝汶',223),
('1', 'national', NULL, '国家', '汤加','汤加',224),
('1', 'national', NULL, '国家', '特立尼达和多巴哥','特立尼达和多巴哥',225),
('1', 'national', NULL, '国家', '突尼斯','突尼斯',226),
('1', 'national', NULL, '国家', '土耳其','土耳其',227),
('1', 'national', NULL, '国家', '图瓦卢','图瓦卢',228),
('1', 'national', NULL, '国家', '台湾','台湾',229),
('1', 'national', NULL, '国家', '坦桑尼亚','坦桑尼亚',230),
('1', 'national', NULL, '国家', '乌干达','乌干达',231),
('1', 'national', NULL, '国家', '乌克兰','乌克兰',232),
('1', 'national', NULL, '国家', '美属太平洋各群岛','美属太平洋各群岛',233),
('1', 'national', NULL, '国家', '联合国','联合国',234),
('1', 'national', NULL, '国家', '联合国','联合国',235),
('1', 'national', NULL, '国家', '联合国','联合国',236),
('1', 'national', NULL, '国家', '乌拉圭','乌拉圭',237),
('1', 'national', NULL, '国家', '美国','美国',238),
('1', 'national', NULL, '国家', '乌兹别克斯坦','乌兹别克斯坦',239),
('1', 'national', NULL, '国家', '梵蒂冈','梵蒂冈',240),
('1', 'national', NULL, '国家', '圣文森特和格林纳丁斯','圣文森特和格林纳丁斯',241),
('1', 'national', NULL, '国家', '委内瑞拉','委内瑞拉',242),
('1', 'national', NULL, '国家', '英属维尔京群岛','英属维尔京群岛',243),
('1', 'national', NULL, '国家', '美属维尔京群岛','美属维尔京群岛',244),
('1', 'national', NULL, '国家', '越南','越南',245),
('1', 'national', NULL, '国家', '瓦努阿图','瓦努阿图',246),
('1', 'national', NULL, '国家', '威克岛','威克岛',247),
('1', 'national', NULL, '国家', '瓦利斯和富图纳群岛','瓦利斯和富图纳群岛',248),
('1', 'national', NULL, '国家', '西萨摩亚','西萨摩亚',249),
('1', 'national', NULL, '国家', '无国籍（无国籍人）','无国籍（无国籍人）',250),
('1', 'national', NULL, '国家', '无国籍（难民）','无国籍（难民）',251),
('1', 'national', NULL, '国家', '无国籍（未声明国籍）','无国籍（未声明国籍）',252),
('1', 'national', NULL, '国家', '也门','也门',253),
('1', 'national', NULL, '国家', '南斯拉夫','南斯拉夫',254),
('1', 'national', NULL, '国家', '南非','南非',255),
('1', 'national', NULL, '国家', '扎伊尔','扎伊尔',256),
('1', 'national', NULL, '国家', '赞比亚','赞比亚',257),
('1', 'national', NULL, '国家', '津巴布韦','津巴布韦',258),
('1', 'national', NULL, '国家', '国籍不详','国籍不详',259);

#超时未持证保安员天数设置
delete from `config` where `key` = 'person_outtime';
INSERT INTO `config` (`key`, `value`, `name`, `active`, `create_time`, `update_time`, `update_by`)
VALUES ('person_outtime', '20', '超时未持证保安员天数设置', true, now(), now(), 'system');

#入职时间没有值设为创建时间
update security_person p,`user` u
set entrydate=CONCAT(LEFT(create_time,10),' 00:00:00')
where entrydate is null and p.user_id=u.id;


delete from config where `key`='dataSyncLastDate';
INSERT INTO `config` (`key`, `value`, `name`, `active`, `create_time`, `update_time`, `update_by`)
VALUES ('dataSyncLastDate', '2019-06-13', '同步最后日期', true, now(), now(), 'system');




