/*
Navicat MySQL Data Transfer

Source Server         : 阿里云
Source Server Version : 50518
Source Host           : bcxin366.mysql.rds.aliyuncs.com:3306
Source Database       : ars

Target Server Type    : MYSQL
Target Server Version : 50518
File Encoding         : 65001

Date: 2018-02-24 09:50:40
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for approve_act_rela
-- ----------------------------
DROP TABLE IF EXISTS `approve_act_rela`;
CREATE TABLE `approve_act_rela` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '审批activity关联ID',
  `active` bit(1) DEFAULT NULL COMMENT '是否可用',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `update_by` varchar(50) DEFAULT NULL COMMENT '修改者',
  `approveType` varchar(6) DEFAULT NULL COMMENT '审批类型',
  `processInfo` longtext COMMENT '流程配置信息',
  `regionLevel` varchar(6) DEFAULT NULL COMMENT '区域级别',
  `effectTime` datetime DEFAULT NULL COMMENT '生效时间',
  `failureTime` datetime DEFAULT NULL COMMENT '失效时间',
  `regionId` int(11) NOT NULL COMMENT '单位所在区域ID',
  `approveLinkId` varchar(30) NOT NULL COMMENT 'activity流程ID',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=100000 DEFAULT CHARSET=utf8 COMMENT='审批activity关联';

-- ----------------------------
-- Records of approve_act_rela
-- ----------------------------

-- ----------------------------
-- Table structure for approve_area_pro_detail
-- ----------------------------
DROP TABLE IF EXISTS `approve_area_pro_detail`;
CREATE TABLE `approve_area_pro_detail` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '区域审批流程明细ID',
  `active` bit(1) DEFAULT NULL COMMENT '是否可用',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `update_by` varchar(50) DEFAULT NULL COMMENT '修改者',
  `effectTime` datetime DEFAULT NULL COMMENT '生效时间',
  `failureTime` datetime DEFAULT NULL COMMENT '失效时间',
  `approveRank` int(4) DEFAULT NULL COMMENT '审批级次（填写1,2之类）',
  `manyApproveRule` varchar(6) DEFAULT NULL COMMENT '多人审批规则',
  `positionName` varchar(20) DEFAULT NULL COMMENT '职位名称',
  `approveAreaProId` int(11) NOT NULL COMMENT '区域审批流程ID',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=102746 DEFAULT CHARSET=utf8 COMMENT='区域审批流程明细';

-- ----------------------------
-- Records of approve_area_pro_detail
-- ----------------------------

-- ----------------------------
-- Table structure for approve_area_pro_detail_per
-- ----------------------------
DROP TABLE IF EXISTS `approve_area_pro_detail_per`;
CREATE TABLE `approve_area_pro_detail_per` (
  `approveAreaProDetailId` int(11) NOT NULL COMMENT '区域审批流程明细ID',
  `approvePerId` int(11) NOT NULL COMMENT '审批人员ID',
  `active` bit(1) DEFAULT NULL COMMENT '是否可用',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `update_by` varchar(50) DEFAULT NULL COMMENT '修改者',
  `seq` int(4) DEFAULT NULL COMMENT '排序',
  `approveTimes` int(11) DEFAULT NULL COMMENT '审批次数',
  `workStatus` varchar(6) DEFAULT NULL COMMENT '审批次数',
  PRIMARY KEY (`approveAreaProDetailId`,`approvePerId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='区域审批流程明细人员';

-- ----------------------------
-- Records of approve_area_pro_detail_per
-- ----------------------------

-- ----------------------------
-- Table structure for approve_area_process
-- ----------------------------
DROP TABLE IF EXISTS `approve_area_process`;
CREATE TABLE `approve_area_process` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '区域审批流程ID',
  `active` bit(1) DEFAULT NULL COMMENT '是否可用',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `update_by` varchar(50) DEFAULT NULL COMMENT '修改者',
  `effectTime` datetime DEFAULT NULL COMMENT '生效时间',
  `failureTime` datetime DEFAULT NULL COMMENT '失效时间',
  `approveSetStatus` varchar(6) DEFAULT NULL COMMENT '审批配置状态',
  `regionLevel` varchar(6) DEFAULT NULL COMMENT '区域级别',
  `regionId` int(11) NOT NULL COMMENT '单位所在区域ID',
  `approveLinkLevelId` int(11) NOT NULL COMMENT '审批环节层级ID',
  `policeCode` varchar(50) NOT NULL COMMENT '单位代码',
  `policeId` int(11) NOT NULL COMMENT '单位代码',
  `path` varchar(50) DEFAULT NULL COMMENT '树',
  `processInfo` longtext COMMENT '流程配置信息',
  PRIMARY KEY (`id`),
  KEY `index_approve_area_process_policeId` (`policeId`),
  KEY `index_approve_area_process_approveLinkLevelId` (`approveLinkLevelId`)
) ENGINE=InnoDB AUTO_INCREMENT=203040 DEFAULT CHARSET=utf8 COMMENT='区域审批流程';

-- ----------------------------
-- Records of approve_area_process
-- ----------------------------

-- ----------------------------
-- Table structure for approve_group
-- ----------------------------
DROP TABLE IF EXISTS `approve_group`;
CREATE TABLE `approve_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '审批组ID',
  `active` bit(1) DEFAULT NULL COMMENT '是否可用',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `update_by` varchar(50) DEFAULT NULL COMMENT '修改者',
  `groupName` varchar(20) DEFAULT NULL COMMENT '审批组名称',
  `seq` int(4) DEFAULT NULL COMMENT '排序',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=100004 DEFAULT CHARSET=utf8 COMMENT='审批组';

-- ----------------------------
-- Records of approve_group
-- ----------------------------
INSERT INTO `approve_group` VALUES ('100001', '', '2018-01-17 14:43:22', '2018-01-17 14:43:29', 'gx_super', '备案业务', '1');
INSERT INTO `approve_group` VALUES ('100002', '', '2018-01-17 14:43:24', '2018-01-17 14:43:31', 'gx_super', '行政许可业务', '2');
INSERT INTO `approve_group` VALUES ('100003', '', '2018-01-17 14:43:27', '2018-01-17 17:30:29', 'gx_super', '保安员资格考试', '3');

-- ----------------------------
-- Table structure for approve_link
-- ----------------------------
DROP TABLE IF EXISTS `approve_link`;
CREATE TABLE `approve_link` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '审批环节ID',
  `active` bit(1) DEFAULT NULL COMMENT '是否可用',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `update_by` varchar(50) DEFAULT NULL COMMENT '修改者',
  `linkName` varchar(20) DEFAULT NULL COMMENT '审批环节名称',
  `linkType` varchar(3) DEFAULT NULL COMMENT '环节类型 1报名确认、2缴费确认、3指纹获取、4考试安排、5指派民警',
  `seq` int(4) DEFAULT NULL COMMENT '排序',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=100032 DEFAULT CHARSET=utf8 COMMENT='审批环节';

-- ----------------------------
-- Records of approve_link
-- ----------------------------
INSERT INTO `approve_link` VALUES ('1', '', '2018-02-07 14:38:55', '2018-03-01 10:01:50', 'gx_super', '材料审批', '', null);
INSERT INTO `approve_link` VALUES ('2', '', '2018-01-30 11:31:37', '2018-02-20 11:03:33', 'gx_super', '子公司市级审批', '', null);
INSERT INTO `approve_link` VALUES ('3', '', '2018-01-30 11:31:45', '2018-01-30 11:31:49', '', '环节3', '', null);
INSERT INTO `approve_link` VALUES ('4', '', '2018-01-30 13:03:12', '2018-01-30 13:03:16', '', '环节4', '', null);
INSERT INTO `approve_link` VALUES ('5', '', '2018-01-30 13:03:19', '2018-01-30 13:03:21', '', '环节5', '', null);
INSERT INTO `approve_link` VALUES ('6', '', '2018-01-30 13:03:25', '2018-01-30 13:03:28', '', '环节6', '', null);
INSERT INTO `approve_link` VALUES ('7', '', '2018-01-30 13:03:30', '2018-01-30 13:03:33', '', '环节一', '', null);
INSERT INTO `approve_link` VALUES ('8', '', '2018-01-30 13:03:36', '2018-01-30 13:03:39', '', '环节二', '', null);
INSERT INTO `approve_link` VALUES ('9', '', '2018-01-30 13:03:43', '2018-01-30 13:03:46', '', '环节三', '', null);
INSERT INTO `approve_link` VALUES ('10', '', '2018-02-07 15:34:24', '2018-02-07 15:34:24', 'gx_super', '环节四', '', null);
INSERT INTO `approve_link` VALUES ('11', '', '2018-02-07 15:37:54', '2018-02-07 15:37:54', 'gx_super', '环节五', '', null);
INSERT INTO `approve_link` VALUES ('12', '', '2018-03-01 10:14:50', '2018-03-01 10:14:50', 'gx_super', '报名确认', '1', null);
INSERT INTO `approve_link` VALUES ('13', '', '2018-03-01 10:15:00', '2018-03-01 10:15:00', 'gx_super', '缴费确认', '2', null);
INSERT INTO `approve_link` VALUES ('14', '', '2018-03-01 10:15:11', '2018-03-01 10:15:11', 'gx_super', '指纹获取', '3', null);
INSERT INTO `approve_link` VALUES ('15', '', '2018-03-01 10:15:20', '2018-03-01 10:15:20', 'gx_super', '考试安排', '4', null);
INSERT INTO `approve_link` VALUES ('16', '', '2018-03-01 10:15:33', '2018-03-01 10:15:33', 'gx_super', '年报最后一级审批', '5', null);

-- ----------------------------
-- Table structure for approve_link_level
-- ----------------------------
DROP TABLE IF EXISTS `approve_link_level`;
CREATE TABLE `approve_link_level` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '审批环节层级ID',
  `active` bit(1) DEFAULT NULL COMMENT '是否可用',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `update_by` varchar(50) DEFAULT NULL COMMENT '修改者',
  `approveLevel` varchar(6) DEFAULT NULL COMMENT '审批层级',
  `parentId` int(11) DEFAULT NULL COMMENT '上级审批环节层级ID',
  `tempLinkRelaId` int(11) NOT NULL COMMENT '审批模板环节关联ID',
  PRIMARY KEY (`id`),
  KEY `index_link_level_tempLinkRelaId` (`tempLinkRelaId`)
) ENGINE=InnoDB AUTO_INCREMENT=100406 DEFAULT CHARSET=utf8 COMMENT='审批环节层级';

-- ----------------------------
-- Records of approve_link_level
-- ----------------------------

-- ----------------------------
-- Table structure for approve_link_pro_detail
-- ----------------------------
DROP TABLE IF EXISTS `approve_link_pro_detail`;
CREATE TABLE `approve_link_pro_detail` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '审批环节流程明细ID',
  `active` bit(1) DEFAULT NULL COMMENT '是否可用',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `update_by` varchar(50) DEFAULT NULL COMMENT '修改者',
  `processInfo` longtext COMMENT '流程配置信息',
  `regionLevel` varchar(6) DEFAULT NULL COMMENT '区域级别',
  `regionId` int(11) DEFAULT NULL COMMENT '单位所在区域ID',
  `approveAreaProId` int(11) DEFAULT NULL COMMENT '区域审批流程ID',
  `tempLinkRelaId` int(11) DEFAULT NULL COMMENT '审批模板环节关联ID',
  `policeId` int(11) DEFAULT NULL COMMENT '公安单位Id',
  `processPath` varchar(50) DEFAULT NULL,
  `policeCode` varchar(50) DEFAULT NULL COMMENT '单位代码',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=416606580486701057 DEFAULT CHARSET=utf8 COMMENT='审批环节流程明细';

-- ----------------------------
-- Records of approve_link_pro_detail
-- ----------------------------

-- ----------------------------
-- Table structure for approve_temp
-- ----------------------------
DROP TABLE IF EXISTS `approve_temp`;
CREATE TABLE `approve_temp` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '审批模板ID',
  `active` bit(1) DEFAULT NULL COMMENT '是否可用',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `update_by` varchar(50) DEFAULT NULL COMMENT '修改者',
  `tempName` varchar(20) DEFAULT NULL COMMENT '审批模板名称',
  `tempCode` varchar(50) DEFAULT NULL COMMENT '模板编码(activiti使用)',
  `iconUrl` varchar(50) DEFAULT NULL COMMENT '审批图标url',
  `approveType` varchar(6) DEFAULT NULL COMMENT '审批类型',
  `effectTime` datetime DEFAULT NULL COMMENT '生效时间',
  `failureTime` datetime DEFAULT NULL COMMENT '失效时间',
  `approveSetStatus` varchar(6) DEFAULT NULL COMMENT '审批配置状态',
  `noticeTemp` varchar(100) DEFAULT NULL COMMENT '信息通知模板',
  `repulseExplain` varchar(100) DEFAULT NULL COMMENT '审批打回说明',
  `seq` int(4) DEFAULT NULL COMMENT '排序',
  `approveGroupId` int(11) NOT NULL COMMENT '审批组ID',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=100001 DEFAULT CHARSET=utf8 COMMENT='审批模板';

-- ----------------------------
-- Records of approve_temp
-- ----------------------------
INSERT INTO `approve_temp` VALUES ('1', '', '2018-02-07 17:52:18', '2018-02-23 09:33:23', 'gx_super', '保安服务公司设立分公司备案', 'activitisubsidiaryapprovalProcess', null, null, '2018-02-21 14:47:50', '2018-02-22 13:09:23', '0', ' ', ' ', '1', '100001');
INSERT INTO `approve_temp` VALUES ('2', '', '2018-02-07 17:52:18', '2018-02-23 09:46:54', 'gx_super', '保安跨区服务备案', 'activiticrosscompanyapprovalProcess', null, null, '2018-02-07 17:56:34', null, '0', '123121', '   ', '2', '100001');
INSERT INTO `approve_temp` VALUES ('3', '', '2018-02-07 17:52:18', '2018-02-23 14:32:43', 'system', '枪支培训机构备案', 'activitifirearmsapprovalProcess', null, null, '2018-02-23 14:32:43', '2018-02-23 14:10:33', '1', null, null, '3', '100001');
INSERT INTO `approve_temp` VALUES ('4', '', '2018-02-07 17:52:18', '2018-02-23 09:47:09', 'gx_super', '自行招用保安员单位备案', 'activiticonfesscompanyapprovalProcess', null, null, '2018-02-22 18:06:06', '2018-02-22 18:12:59', '0', '    ', '1233', '4', '100001');
INSERT INTO `approve_temp` VALUES ('5', '', '2018-02-07 17:52:18', '2018-02-23 09:33:58', 'gx_super', '保安培训单位许可证审批', 'activititraincompanyapplyapprovalProcess', null, null, null, null, '0', ' ', ' ', '1', '100002');
INSERT INTO `approve_temp` VALUES ('6', '', '2018-02-07 17:52:18', '2018-02-23 14:57:06', 'gxnnxnadmin', '保安服务公司许可证审批', 'activitisponsorlicenseapprovalProcess', null, null, '2018-02-23 14:57:06', '2018-02-23 14:50:20', '1', 'test', 'teset', '2', '100002');
INSERT INTO `approve_temp` VALUES ('7', '', '2018-02-07 17:52:18', '2018-02-22 10:25:23', 'system', '保安服务（培训）许可证项目变更', 'activitilegalchangeapprovalProcess', null, null, '2018-02-22 10:25:23', null, '0', null, null, '3', '100002');
INSERT INTO `approve_temp` VALUES ('8', '', '2018-02-07 17:52:18', '2018-02-23 10:46:43', 'system', '保安员资格考试管理', 'activitipersoncertificateapprovalProcess', null, null, '2018-02-23 10:46:43', null, '1', null, null, '1', '100003');
INSERT INTO `approve_temp` VALUES ('9', '', '2018-02-07 17:52:18', '2018-02-23 09:52:08', 'gx_super', '保安服务公司年度报告备案', 'activitiyearreportapprovalProcess', null, null, '2018-02-22 13:39:59', null, '0', 'null', 'null', '5', '100001');

-- ----------------------------
-- Table structure for approve_temp_link_rela
-- ----------------------------
DROP TABLE IF EXISTS `approve_temp_link_rela`;
CREATE TABLE `approve_temp_link_rela` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '审批模板环节关联ID',
  `active` bit(1) DEFAULT NULL COMMENT '是否可用',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `update_by` varchar(50) DEFAULT NULL COMMENT '修改者',
  `approveTempId` int(11) NOT NULL COMMENT '审批模板ID',
  `approveLinkId` int(11) NOT NULL COMMENT '审批环节ID',
  `seq` int(4) DEFAULT NULL COMMENT '排序',
  `linkSetStatus` varchar(6) DEFAULT '0' COMMENT '环节配置状态（1为配置完成 ，0为为配置）',
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_tempId_linkId` (`approveTempId`,`approveLinkId`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=10053 DEFAULT CHARSET=utf8 COMMENT='审批模板环节关联';

-- ----------------------------
-- Records of approve_temp_link_rela
-- ----------------------------

-- ----------------------------
-- Table structure for approve_temp_process
-- ----------------------------
DROP TABLE IF EXISTS `approve_temp_process`;
CREATE TABLE `approve_temp_process` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '审批模板主流程ID',
  `active` bit(1) DEFAULT NULL COMMENT '是否可用',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `update_by` varchar(50) DEFAULT NULL COMMENT '修改者',
  `approveTempId` int(11) NOT NULL COMMENT '审批模板ID',
  `regionLevel` varchar(6) DEFAULT NULL COMMENT '区域级别',
  `policeCode` varchar(50) DEFAULT NULL COMMENT '单位代码',
  `policeId` int(11) DEFAULT NULL COMMENT '公安单位Id',
  `processInfo` longtext COMMENT '一级子流程配置信息',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=381 DEFAULT CHARSET=utf8 COMMENT='审批模板主流程信息';

-- ----------------------------
-- Records of approve_temp_process
-- ----------------------------



ALTER TABLE `sb_sponsorlicense`
ADD COLUMN `card_state`  varchar(3) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '制证状态 2已制证  0未制证  1提交审核' AFTER `reply_state`;

ALTER TABLE `sb_traincompanyapply`
ADD COLUMN `card_state`  varchar(3) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '制证状态 2已制证  0未制证  1提交审核' AFTER `plan_censor_status`;


