
DROP TABLE IF EXISTS `news_company_relationship`;
CREATE TABLE `news_company_relationship` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `active` bit(1) DEFAULT NULL COMMENT '是否可用',
  `create_time` datetime DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  `update_by` varchar(50) DEFAULT NULL,
  `path` varchar(200) DEFAULT NULL COMMENT '附件地址',
  `companyId` int(11) DEFAULT NULL COMMENT '公司ID',
  `newsnoticeId` int(11) DEFAULT NULL COMMENT '公安消息ID',
  `companyName` varchar(200) DEFAULT NULL COMMENT '公司名称',
  `updateflag` varchar(3) DEFAULT NULL COMMENT '修改更新标志',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10146 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

-- ----------------------------
-- Table structure for newsnotice_company
-- ----------------------------
DROP TABLE IF EXISTS `newsnotice_company`;
CREATE TABLE `newsnotice_company` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `active` bit(1) DEFAULT NULL COMMENT '是否可用',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  `update_by` varchar(50) DEFAULT NULL COMMENT '修改者',
  `sendName` varchar(50) DEFAULT NULL COMMENT '发送人姓名',
  `sendOrgName` varchar(200) DEFAULT NULL COMMENT '发送人机构',
  `companyId` int(11) DEFAULT NULL COMMENT '发送人ID',
  `newsContext` varchar(5000) DEFAULT NULL COMMENT '消息内容',
  `readstate` varchar(10) DEFAULT NULL COMMENT '阅读状态',
  `newsnoticeId` int(11) DEFAULT NULL COMMENT '公安消息ID',
  `newsTitle` varchar(200) DEFAULT NULL COMMENT '消息标题',
  `updateflag` varchar(3) DEFAULT NULL COMMENT '修改更新标志',
  `undoState`  varchar(3) NULL COMMENT '是否撤回 0未撤消1已撤消',
  PRIMARY KEY (`id`),
  KEY `newsnotice_company_key` (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=68 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

-- ----------------------------
-- Table structure for newsnotice_police
-- ----------------------------
DROP TABLE IF EXISTS `newsnotice_police`;
CREATE TABLE `newsnotice_police` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `active` bit(1) DEFAULT NULL COMMENT '是否可用',
  `create_time` datetime DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  `update_by` varchar(50) DEFAULT NULL,
  `newsTitle` varchar(200) DEFAULT NULL COMMENT '标题',
  `newsContext` longtext COMMENT '消息内容',
  `sendId` int(11) DEFAULT NULL COMMENT '发送人ID',
  `sendName` varchar(50) DEFAULT NULL COMMENT '发送人员姓名',
  `sendOrgId` int(11) DEFAULT NULL COMMENT '发送机构id',
  `sendOrgName` varchar(200) DEFAULT NULL COMMENT '发送机构',
  `undoState` varchar(3) DEFAULT NULL COMMENT '是否撤消 0未撤消1已撤消',
  `readnum` int(11) DEFAULT NULL COMMENT '已读数',
  `unreadnum` int(11) DEFAULT NULL COMMENT '未读数',
  `temporaryState` varchar(3) DEFAULT NULL COMMENT '暂存状态 0暂存1保存',
  `noticeperson` varchar(3) DEFAULT NULL COMMENT '是否通知保安人员 0不通知1通知',
  `areaCode` varchar(10) DEFAULT NULL COMMENT '发送人机构编码',
  `updateflag` varchar(3) DEFAULT NULL COMMENT '修改更新标志',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=390 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

-- ----------------------------
-- Table structure for newsnotice_recipient
-- ----------------------------
DROP TABLE IF EXISTS `newsnotice_recipient`;
CREATE TABLE `newsnotice_recipient` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `active` bit(1) DEFAULT NULL COMMENT '是否可用',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  `update_by` varchar(50) DEFAULT NULL COMMENT '修改者',
  `relationId` varchar(50) DEFAULT NULL COMMENT '关联ID',
  `noticePoliceId` int(11) DEFAULT NULL COMMENT '消息ID',
  `type` varchar(2) DEFAULT NULL COMMENT '类型 0区域 1公司',
  `updateflag` varchar(3) DEFAULT NULL COMMENT '修改更新标志',
  PRIMARY KEY (`id`),
  KEY `newsnotice_recipient_key` (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=56 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

-- ----------------------------
-- Table structure for sys_attachment
-- ----------------------------
DROP TABLE IF EXISTS `sys_attachment`;
CREATE TABLE `sys_attachment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `active` bit(1) DEFAULT NULL COMMENT '是否可用',
  `create_time` datetime DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  `update_by` varchar(50) DEFAULT NULL,
  `path` varchar(200) DEFAULT NULL COMMENT '附件地址',
  `businessid` int(11) DEFAULT NULL COMMENT '业务ID',
  `businesstype` varchar(3) DEFAULT NULL COMMENT '业务类型 001公安消息附件',
  `fileName` varchar(100) DEFAULT NULL COMMENT '上传文件名',
  `fileSize` int(11) DEFAULT NULL COMMENT '文件大小',
  `updateflag` varchar(3) DEFAULT NULL COMMENT '修改更新标志',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=448 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

delete from `config`  where `key` = 'MSG_ATTACHMENT';
INSERT INTO `config` (`key`, `value`, `name`, `create_time`, `update_time`, `update_by`) VALUES ('MSG_ATTACHMENT', '1', '消息是否需要上传附件', '2018-03-08 14:13:13', '2018-03-08 14:13:15', 'system');


