ALTER TABLE `security_person`
ADD COLUMN `socialSecurity`  varchar(5) NULL COMMENT '五险一金' AFTER `personType`;

#保安员工作经验
CREATE TABLE `person_experience` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `person_id` int(11) DEFAULT NULL COMMENT '保安员ID',
  `active` bit(1) DEFAULT NULL COMMENT '是否可用',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `update_by` varchar(255) DEFAULT NULL COMMENT '修改者',
  `company_name` varchar(255) DEFAULT NULL COMMENT '公司名称',
  `company_address` varchar(500) DEFAULT NULL COMMENT '公司地址',
  `post` varchar(500) DEFAULT NULL COMMENT '职务',
  `department` varchar(255) DEFAULT NULL COMMENT '部门',
  `work_content` varchar(500) DEFAULT NULL COMMENT '工作内容',
  `start_date` varchar(50) DEFAULT NULL COMMENT '任职开始时间',
  `end_date` varchar(255) DEFAULT NULL COMMENT '任职结束时间',
  `can_del` bit(1) DEFAULT NULL COMMENT '是否可删除（由系统内产生的工作经验不允许删除）',
  PRIMARY KEY (`id`),
  KEY `ak_personexperience_key` (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

ALTER TABLE `security_company_person`
MODIFY COLUMN `role_id`  int(11) NULL AFTER `org_id`;

ALTER TABLE `user_role`
ADD COLUMN `roleType`  varchar(11) NULL COMMENT '1、role,2、policeRole' AFTER `userid`;
update user_role set roleType=2;
insert INTO user_role(native_code, active, create_time, update_time, update_by, roleid, userid,roleType)
select a.native_code,1,now(),now(),a.update_by,a.role_id,b.user_id,1 from security_company_person a,security_person b where a.active =1 and a.person_id=b.id
and b.user_id not in (select ur.userid from user_role ur);