﻿
DROP TABLE IF EXISTS `operation`;
CREATE TABLE `operation` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `native_code` int(11) NOT NULL,
  `code` varchar(20) NOT NULL,
  `name` varchar(20) NOT NULL,
  `module_id` int(11) NOT NULL,
  `active` bit(1) NOT NULL,
  `create_time` datetime NOT NULL,
  `update_time` datetime NOT NULL,
  `update_by` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_operation_module` (`module_id`),
  KEY `fk_operation_native` (`native_code`),
  CONSTRAINT `fk_operation_module` FOREIGN KEY (`module_id`) REFERENCES `module` (`id`),
  CONSTRAINT `fk_operation_native` FOREIGN KEY (`native_code`) REFERENCES `native` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=213 DEFAULT CHARSET=utf8;
  
ALTER TABLE `permission` DROP INDEX `fk_permission_module_id`;
delete from `module`;

INSERT INTO `module` VALUES ('1', '3502', 'search', '一键搜', null, '1', '', '\0', '', '', '', '2017-02-28 22:53:42', '2017-02-28 22:53:45', 'system', '1');
INSERT INTO `module` VALUES ('2', '3502', 'person_ctr', '人员中心', null, '2', '', '\0', '', '', '', '2017-03-01 10:28:44', '2017-03-01 10:28:46', 'system', '1');
INSERT INTO `module` VALUES ('3', '3502', 'task_ctr', '任务中心', null, '3', '', '\0', '', '', '', '2017-03-01 10:29:07', '2017-03-01 10:29:10', 'system', '1');
INSERT INTO `module` VALUES ('4', '3502', 'ungentask_ctr', '紧急任务', null, '5', '', '\0', '', '', '', '2017-03-01 21:09:22', '2017-03-01 21:09:25', 'system', '1');
INSERT INTO `module` VALUES ('5', '3502', 'approval_ctr', '待办事项', null, '6', '\0', '\0', '', '', '', '2017-03-01 10:29:32', '2017-03-01 10:29:34', 'system', '1');
INSERT INTO `module` VALUES ('6', '3502', 'complaint_ctr', '投诉建议', null, '7', '\0', '\0', '', '', '', '2017-03-01 10:29:54', '2017-03-01 10:29:57', 'system', '1');
INSERT INTO `module` VALUES ('25', '3502', 'search', '一键搜', null, '1', '', '\0', '', '', '', '2017-02-28 22:53:42', '2017-02-28 22:53:45', 'system', '2');
INSERT INTO `module` VALUES ('26', '3502', 'person_ctr', '人员中心', null, '2', '', '\0', '', '', '', '2017-03-01 10:28:44', '2017-03-01 10:28:46', 'system', '2');
INSERT INTO `module` VALUES ('27', '3502', 'task_ctr', '任务中心', null, '3', '', '\0', '', '', '', '2017-03-01 10:29:07', '2017-03-01 10:29:10', 'system', '2');
INSERT INTO `module` VALUES ('28', '3502', 'company_ctr', '安保公司中心', null, '4', '', '\0', '', '', '\0', '2017-03-01 21:09:22', '2017-03-01 21:09:25', 'system', '2');
INSERT INTO `module` VALUES ('29', '3502', 'safety_srv', '保障服务', null, '5', '\0', '\0', '', '', '\0', '2017-03-01 10:29:32', '2017-03-01 10:29:34', 'system', '2');
INSERT INTO `module` VALUES ('30', '3502', 'person_mgr', '人员管理', null, '6', '\0', '\0', '', '', '', '2017-03-01 10:29:54', '2017-03-01 10:29:57', 'system', '2');
INSERT INTO `module` VALUES ('31', '3502', 'org_mgr', '组织架构', null, '7', '\0', '\0', '', '', '', '2017-03-01 10:30:20', '2017-03-01 10:30:22', 'system', '2');
INSERT INTO `module` VALUES ('32', '3502', 'role_mgr', '角色权限', null, '8', '\0', '\0', '', '', '', '2017-03-01 10:30:53', '2017-03-01 10:30:59', 'system', '2');
INSERT INTO `module` VALUES ('33', '3502', 'company_info', '公司信息', null, '9', '\0', '\0', '', '', '', '2017-03-01 10:30:57', '2017-03-01 10:31:02', 'system', '2');
INSERT INTO `module` VALUES ('64', '3502', 'xhmanager_ctr', '保安协会管理', null, '8', '\0', '\0', null, null, '', '2017-06-30 17:08:00', '2017-06-30 17:08:04', 'system', '1');
INSERT INTO `module` VALUES ('65', '3502', 'jdmanager', '监督检查情况管理', null, '9', '\0', '\0', null, null, '', '2017-06-30 17:41:19', '2017-06-30 17:41:21', 'system', '1');
INSERT INTO `module` VALUES ('66', '3502', 'sponsorlicense', '设立保安服务公司行政许可证管理', null, '10', '\0', '\0', null, null, '', '2017-06-30 17:52:38', '2017-06-30 17:52:41', 'system', '1');
INSERT INTO `module` VALUES ('67', '3502', 'sponsorlicense', '设立保安培训单位行政许可证管理', null, '11', '\0', '\0', null, null, '', '2017-06-30 17:55:58', '2017-05-01 17:55:55', 'system', '1');
INSERT INTO `module` VALUES ('68', '3502', 'subsidiary', '保安服务公司设立分公司备案管理', null, '12', '\0', '\0', null, null, '', '2017-05-01 17:59:19', '2017-06-30 17:59:22', 'system', '1');
INSERT INTO `module` VALUES ('69', '3502', 'crosscompany', '跨区域经营保安服务备案管理', null, '13', '\0', '\0', null, null, '', '2017-06-30 18:00:19', '2017-06-30 18:00:21', 'system', '1');
INSERT INTO `module` VALUES ('70', '3502', 'confesscompany', '自招单位备案管理', '', '14', '\0', '\0', '', '', '', '2017-06-30 18:00:19', '2017-06-30 18:00:21', 'system', '1');
INSERT INTO `module` VALUES ('71', '3502', 'legalchange', '保安服务公司的法定代表人变更管理', '', '15', '\0', '\0', '', '', '', '2017-06-30 18:00:19', '2017-06-30 18:00:21', 'system', '1');
INSERT INTO `module` VALUES ('72', '3502', 'personcertificate', '保安员证管理', '', '16', '\0', '\0', '', '', '', '2017-06-30 18:00:19', '2017-06-30 18:00:21', 'system', '1');
INSERT INTO `module` VALUES ('73', '3502', 'statistics', '培训统计管理', '', '17', '\0', '\0', '', '', '', '2017-06-30 18:00:19', '2017-06-30 18:00:21', 'system', '1');
INSERT INTO `module` VALUES ('74', '3502', 'yearreport', '年度报告管理', '', '18', '\0', '\0', '', '', '', '2017-06-30 18:00:19', '2017-06-30 18:00:21', 'system', '1');
INSERT INTO `module` VALUES ('75', '3502', 'orgManager', '机构管理', '', '19', '\0', '\0', '', '', '', '2017-06-30 18:00:19', '2017-06-30 18:00:21', 'system', '1');
INSERT INTO `module` VALUES ('76', '3502', 'userManager', '用户管理', '', '20', '\0', '\0', '', '', '', '2017-06-30 18:00:19', '2017-06-30 18:00:21', 'system', '1');
INSERT INTO `module` VALUES ('77', '3502', 'roleManager', '角色管理', '', '21', '\0', '\0', '', '', '', '2017-06-30 18:00:19', '2017-06-30 18:00:21', 'system', '1');
INSERT INTO `module` VALUES ('78', '3502', 'companyManager', '保安公司管理', '', '22', '\0', '\0', '', '', '', '2017-06-30 18:00:19', '2017-06-30 18:00:21', 'system', '1');
INSERT INTO `module` VALUES ('80', '3502', 'company_ctr', '安保公司中心', '', '4', '', '\0', '', '', '', '2017-03-01 21:09:22', '2017-03-01 21:09:25', 'system', '1');
INSERT INTO `module` VALUES ('81', '3502', 'securityTraincompany', '自行招用保安员单位管理', '', '23', '\0', '\0', '', '', '', '2017-06-30 18:00:19', '2017-06-30 18:00:21', 'system', '1');
INSERT INTO `module` VALUES ('82', '3502', 'securityConfesscpy', '保安培训单位信息管理', '', '24', '\0', '\0', '', '', '', '2017-06-30 18:00:19', '2017-06-30 18:00:21', 'system', '1');
INSERT INTO `module` VALUES ('83', '3502', 'task', '任务管理', '', '10', '\0', '\0', '', '', '', '2017-03-01 10:30:57', '2017-03-01 10:31:02', 'system', '2');
INSERT INTO `module` VALUES ('84', '3502', 'team', '应急小队', '', '11', '\0', '\0', '', '', '', '2017-03-01 10:30:57', '2017-03-01 10:31:02', 'system', '2');
INSERT INTO `module` VALUES ('85', '3502', 'ld', '劳动合同', '', '12', '\0', '\0', '', '', '', '2017-03-01 10:30:57', '2017-03-01 10:31:02', 'system', '2');
INSERT INTO `module` VALUES ('86', '3502', 'fwht', '服务合同', '', '13', '\0', '\0', '', '', '', '2017-03-01 10:30:57', '2017-03-01 10:31:02', 'system', '2');
INSERT INTO `module` VALUES ('87', '3502', 'kqjx', '跨区经营', '', '14', '\0', '\0', '', '', '', '2017-03-01 10:30:57', '2017-03-01 10:31:02', 'system', '2');
INSERT INTO `module` VALUES ('88', '3502', 'hw', '海外经营', '', '15', '\0', '\0', '', '', '', '2017-03-01 10:30:57', '2017-03-01 10:31:02', 'system', '2');
INSERT INTO `module` VALUES ('89', '3502', 'jl', '保安员奖励', '', '16', '\0', '\0', '', '', '', '2017-03-01 10:30:57', '2017-03-01 10:31:02', 'system', '2');
INSERT INTO `module` VALUES ('90', '3502', 'cf', '保安员惩罚', '', '17', '\0', '\0', '', '', '', '2017-03-01 10:30:57', '2017-03-01 10:31:02', 'system', '2');
INSERT INTO `module` VALUES ('91', '3502', 'hrhs', '好人好事', '', '18', '\0', '\0', '', '', '', '2017-03-01 10:30:57', '2017-03-01 10:31:02', 'system', '2');
INSERT INTO `module` VALUES ('92', '3502', 'bay', '保安员证报名', '', '19', '\0', '\0', '', '', '', '2017-03-01 10:30:57', '2017-03-01 10:31:02', 'system', '2');
INSERT INTO `module` VALUES ('93', '3502', 'bzfw', '保障服务', '', '20', '\0', '\0', '', '', '', '2017-03-01 10:30:57', '2017-03-01 10:31:02', 'system', '2');
INSERT INTO `module` VALUES ('94', '3502', 'pxgl', '培训管理', '', '21', '\0', '\0', '', '', '', '2017-03-01 10:30:57', '2017-03-01 10:31:02', 'system', '2');
INSERT INTO `module` VALUES ('95', '3502', 'clgl', '车辆管理', '', '22', '\0', '\0', '', '', '', '2017-03-01 10:30:57', '2017-03-01 10:31:02', 'system', '2');
INSERT INTO `module` VALUES ('96', '3502', 'qzgl', '枪支管理', '', '23', '\0', '\0', '', '', '', '2017-03-01 10:30:57', '2017-03-01 10:31:02', 'system', '2');
INSERT INTO `module` VALUES ('97', '3502', 'jfgl', '技防管理', '', '24', '\0', '\0', '', '', '', '2017-03-01 10:30:57', '2017-03-01 10:31:02', 'system', '2');
INSERT INTO `module` VALUES ('98', '3502', 'fgs', '保安服务公司设立分公司备案', '', '25', '\0', '\0', '', '', '', '2017-03-01 10:30:57', '2017-03-01 10:31:02', 'system', '2');
INSERT INTO `module` VALUES ('99', '3502', 'pxdw', '保安培训单位许可证申请', '', '26', '\0', '\0', '', '', '', '2017-03-01 10:30:57', '2017-03-01 10:31:02', 'system', '2');
INSERT INTO `module` VALUES ('100', '3502', 'kq', '跨区域经营备案', '', '27', '\0', '\0', '', '', '', '2017-03-01 10:30:57', '2017-03-01 10:31:02', 'system', '2');
INSERT INTO `module` VALUES ('101', '3502', 'frbg', '法人变更备案', '', '28', '\0', '\0', '', '', '', '2017-03-01 10:30:57', '2017-03-01 10:31:02', 'system', '2');
INSERT INTO `module` VALUES ('102', '3502', 'ndbg', '年度报告备案', '', '29', '\0', '\0', '', '', '', '2017-03-01 10:30:57', '2017-03-01 10:31:02', 'system', '2');
INSERT INTO `module` VALUES ('103', '3502', 'spjd', '审批进度', '', '30', '\0', '\0', '', '', '', '2017-03-01 10:30:57', '2017-03-01 10:31:02', 'system', '2');
INSERT INTO `module` VALUES ('104', '3502', 'ungentask_ctr', '紧急任务', '', '31', '\0', '\0', '', '', '', '2017-03-01 21:09:22', '2017-03-01 21:09:25', 'system', '2');
INSERT INTO `module` VALUES ('105', '3502', 'fgs', '分公司', '', '32', '\0', '\0', '', '', '', '2017-03-01 21:09:22', '2017-03-01 21:09:25', 'system', '2');
INSERT INTO `module` VALUES ('106', '3502', 'czr', '出资人', '', '33', '\0', '\0', '', '', '', '2017-03-01 21:09:22', '2017-03-01 21:09:25', 'system', '2');
INSERT INTO `module` VALUES ('107', '3502', 'glc', '管理层', '', '34', '\0', '\0', '', '', '', '2017-03-01 21:09:22', '2017-03-01 21:09:25', 'system', '2');
INSERT INTO `module` VALUES ('108', '3502', 'fp', '发票管理', '', '35', '\0', '\0', '', '', '', '2017-03-01 21:09:22', '2017-03-01 21:09:25', 'system', '2');


-- ----------------------------
-- Records of operation
-- ----------------------------
INSERT INTO `operation` VALUES ('1', '3502', 'read', '查看', '1', '', '2017-02-28 22:54:18', '2017-02-28 22:54:20', 'system');
INSERT INTO `operation` VALUES ('2', '3502', 'read', '查看', '2', '', '2017-03-01 13:01:19', '2017-03-01 13:01:22', 'system');
INSERT INTO `operation` VALUES ('3', '3502', 'read', '查看', '3', '', '2017-03-01 13:01:45', '2017-03-01 13:01:48', 'system');
INSERT INTO `operation` VALUES ('4', '3502', 'read', '查看', '4', '', '2017-03-01 13:02:14', '2017-03-01 13:02:16', 'system');
INSERT INTO `operation` VALUES ('5', '3502', 'read', '查看', '5', '', '2017-03-01 13:02:49', '2017-03-01 13:02:53', 'system');
INSERT INTO `operation` VALUES ('8', '3502', 'save', '查看', '6', '', '2017-03-01 21:21:21', '2017-03-01 21:21:23', 'system');
INSERT INTO `operation` VALUES ('22', '3502', 'read', '查看', '25', '', '2017-02-28 22:54:18', '2017-02-28 22:54:20', 'system');
INSERT INTO `operation` VALUES ('23', '3502', 'read', '查看', '26', '', '2017-03-01 13:01:19', '2017-03-01 13:01:22', 'system');
INSERT INTO `operation` VALUES ('24', '3502', 'read', '查看', '27', '', '2017-03-01 13:01:45', '2017-03-01 13:01:48', 'system');
INSERT INTO `operation` VALUES ('25', '3502', 'read', '查看', '28', '', '2017-03-01 13:02:14', '2017-03-01 13:02:16', 'system');
INSERT INTO `operation` VALUES ('26', '3502', 'read', '购买', '29', '', '2017-03-01 13:02:49', '2017-03-01 13:02:53', 'system');
INSERT INTO `operation` VALUES ('28', '3502', 'read', '查看', '30', '', '2017-03-01 21:20:46', '2017-03-01 21:20:48', 'system');
INSERT INTO `operation` VALUES ('29', '3502', 'save', '新增', '30', '', '2017-03-01 21:21:21', '2017-03-01 21:21:23', 'system');
INSERT INTO `operation` VALUES ('30', '3502', 'update', '修改', '30', '', '2017-03-01 21:21:42', '2017-03-01 21:21:44', 'system');
INSERT INTO `operation` VALUES ('31', '3502', 'delete', '离职', '30', '', '2017-03-01 21:22:03', '2017-03-01 21:22:10', 'system');
INSERT INTO `operation` VALUES ('32', '3502', 'import', '导入', '30', '', '2017-03-01 21:22:35', '2017-03-01 21:22:38', 'system');
INSERT INTO `operation` VALUES ('33', '3502', 'read', '查看', '31', '', '2017-03-01 21:23:05', '2017-03-01 21:23:08', 'system');
INSERT INTO `operation` VALUES ('34', '3502', 'save', '新增', '31', '', '2017-03-01 21:23:30', '2017-03-01 21:23:35', 'system');
INSERT INTO `operation` VALUES ('35', '3502', 'update', '修改', '31', '', '2017-03-01 21:23:51', '2017-03-01 21:23:54', 'system');
INSERT INTO `operation` VALUES ('36', '3502', 'delete', '删除', '31', '', '2017-03-01 21:24:14', '2017-03-01 21:24:19', 'system');
INSERT INTO `operation` VALUES ('37', '3502', 'read', '查看', '32', '', '2017-03-01 21:24:40', '2017-03-01 21:24:42', 'system');
INSERT INTO `operation` VALUES ('38', '3502', 'save', '新增', '32', '', '2017-03-01 21:25:13', '2017-03-01 21:25:16', 'system');
INSERT INTO `operation` VALUES ('39', '3502', 'update', '修改', '32', '', '2017-03-01 21:25:34', '2017-03-01 21:25:36', 'system');
INSERT INTO `operation` VALUES ('40', '3502', 'delete', '删除', '32', '', '2017-03-01 21:25:53', '2017-03-01 21:25:55', 'system');
INSERT INTO `operation` VALUES ('42', '3502', 'update', '修改', '33', '', '2017-03-01 21:26:47', '2017-03-01 21:26:49', 'system');
INSERT INTO `operation` VALUES ('43', '3502', 'end', '结束', '4', '', '2017-06-29 23:17:47', '2017-06-29 23:17:50', 'system');
INSERT INTO `operation` VALUES ('53', '3502', 'create', '创建', '4', '', '2017-06-29 23:23:20', '2017-06-29 23:23:22', 'system');
INSERT INTO `operation` VALUES ('54', '3502', 'approval', '审批', '5', '', '2017-06-29 23:30:20', '2017-06-29 23:30:23', 'system');
INSERT INTO `operation` VALUES ('56', '3502', 'add', '新增', '64', '', '2017-06-30 17:09:27', '2017-06-30 17:09:29', 'system');
INSERT INTO `operation` VALUES ('59', '3502', 'view', '查看', '64', '', '2017-06-30 17:09:49', '2017-06-30 17:09:51', 'system');
INSERT INTO `operation` VALUES ('60', '3502', 'del', '删除', '64', '', '2017-06-30 17:14:15', '2017-06-30 17:14:18', 'system');
INSERT INTO `operation` VALUES ('61', '3502', 'edit', '修改', '64', '', '2017-06-30 17:14:38', '2017-06-30 17:14:40', 'system');
INSERT INTO `operation` VALUES ('62', '3502', 'view', '查看', '65', '', '2017-06-30 17:41:51', '2017-06-30 17:41:54', 'system');
INSERT INTO `operation` VALUES ('63', '3502', 'add', '新增', '65', '', '2017-06-30 17:42:37', '2017-06-30 17:42:39', 'system');
INSERT INTO `operation` VALUES ('64', '3502', 'edit', '修改', '65', '', '2017-06-30 17:42:37', '2017-06-30 17:42:39', 'system');
INSERT INTO `operation` VALUES ('65', '3502', 'del', '删除', '65', '', '2017-06-30 17:50:11', '2017-06-30 17:50:12', 'system');
INSERT INTO `operation` VALUES ('66', '3502', 'view', '查看', '65', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('67', '3502', 'view', '查看', '67', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('68', '3502', 'view', '查看', '68', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('69', '3502', 'view', '查看', '69', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('70', '3502', 'view', '查看', '70', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('71', '3502', 'view', '查看', '71', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('72', '3502', 'view', '查看', '72', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('73', '3502', 'view', '查看', '73', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('74', '3502', 'view', '查看', '74', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('75', '3502', 'view', '查看', '75', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('76', '3502', 'add', '新增', '75', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('77', '3502', 'edit', '修改', '75', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('78', '3502', 'del', '删除', '75', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('79', '3502', 'copy', '复制', '75', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('80', '3502', 'view', '查看', '76', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('81', '3502', 'add', '新增', '76', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('82', '3502', 'edit', '修改', '76', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('83', '3502', 'reset', '重置密码', '76', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('84', '3502', 'del', '删除', '76', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('85', '3502', 'view', '查看', '77', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('86', '3502', 'add', '新增', '77', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('87', '3502', 'edit', '修改', '77', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('88', '3502', 'copy', '复制', '77', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('89', '3502', 'del', '删除', '77', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('90', '3502', 'view', '查看', '78', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('91', '3502', 'edit', '修改', '78', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('92', '3502', 'del', '删除', '78', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('93', '3502', 'reset', '重置密码', '78', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('94', '3502', 'import', '导入', '78', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('95', '3502', 'out', '导出', '78', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('96', '3502', 'add', '新增', '78', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('97', '3502', 'view', '查看', '80', '', '2017-07-01 07:07:34', '2017-07-01 07:07:36', 'system');
INSERT INTO `operation` VALUES ('98', '3502', 'view', '查询', '81', '', '2017-08-13 14:27:27', '2017-08-13 14:27:29', 'system');
INSERT INTO `operation` VALUES ('99', '3502', 'add', '新增', '81', '', '2017-08-13 14:27:27', '2017-08-13 14:27:29', 'system');
INSERT INTO `operation` VALUES ('100', '3502', 'edit', '修改', '81', '', '2017-08-13 14:27:27', '2017-08-13 14:27:29', 'system');
INSERT INTO `operation` VALUES ('101', '3502', 'view', '查询', '82', '', '2017-08-13 14:27:27', '2017-08-13 14:27:29', 'system');
INSERT INTO `operation` VALUES ('102', '3502', 'add', '新增', '82', '', '2017-08-13 14:27:27', '2017-08-13 14:27:29', 'system');
INSERT INTO `operation` VALUES ('103', '3502', 'edit', '修改', '82', '', '2017-08-13 14:27:27', '2017-08-13 14:27:29', 'system');
INSERT INTO `operation` VALUES ('104', '3502', 'del', '删除', '81', '', '2017-08-13 14:27:27', '2017-08-13 14:27:29', 'system');
INSERT INTO `operation` VALUES ('105', '3502', 'del', '删除', '82', '', '2017-08-13 14:27:27', '2017-08-13 14:27:29', 'system');
INSERT INTO `operation` VALUES ('106', '3502', 'out', '导出', '30', '', '2017-03-01 21:22:35', '2017-03-01 21:22:38', 'system');
INSERT INTO `operation` VALUES ('107', '3502', 'add', '新增', '83', '', '2017-03-01 21:22:35', '2017-03-01 21:22:38', 'system');
INSERT INTO `operation` VALUES ('108', '3502', 'edit', '修改', '83', '', '2017-03-01 21:22:35', '2017-03-01 21:22:38', 'system');
INSERT INTO `operation` VALUES ('109', '3502', 'view', '查看', '83', '', '2017-03-01 21:22:35', '2017-03-01 21:22:38', 'system');
INSERT INTO `operation` VALUES ('110', '3502', 'del', '删除', '83', '', '2017-03-01 21:22:35', '2017-03-01 21:22:38', 'system');
INSERT INTO `operation` VALUES ('111', '3502', 'add', '新增', '84', '', '2017-03-01 21:22:35', '2017-03-01 21:22:38', 'system');
INSERT INTO `operation` VALUES ('112', '3502', 'view', '查看', '84', '', '2017-03-01 21:22:35', '2017-03-01 21:22:38', 'system');
INSERT INTO `operation` VALUES ('113', '3502', 'add', '新增', '85', '', '2017-03-01 21:22:35', '2017-03-01 21:22:38', 'system');
INSERT INTO `operation` VALUES ('114', '3502', 'xq', '续签', '85', '', '2017-03-01 21:22:35', '2017-03-01 21:22:38', 'system');
INSERT INTO `operation` VALUES ('115', '3502', 'bg', '变更', '85', '', '2017-03-01 21:22:35', '2017-03-01 21:22:38', 'system');
INSERT INTO `operation` VALUES ('116', '3502', 'jc', '解除', '85', '', '2017-03-01 21:22:35', '2017-03-01 21:22:38', 'system');
INSERT INTO `operation` VALUES ('117', '3502', 'add', '新增', '86', '', '2017-03-01 21:22:35', '2017-03-01 21:22:38', 'system');
INSERT INTO `operation` VALUES ('118', '3502', 'xq', '续签', '86', '', '2017-03-01 21:22:35', '2017-03-01 21:22:38', 'system');
INSERT INTO `operation` VALUES ('119', '3502', 'bg', '变更', '86', '', '2017-03-01 21:22:35', '2017-03-01 21:22:38', 'system');
INSERT INTO `operation` VALUES ('120', '3502', 'jc', '解除', '86', '', '2017-03-01 21:22:35', '2017-03-01 21:22:38', 'system');
INSERT INTO `operation` VALUES ('121', '3502', 'view', '查看', '85', '', '2017-03-01 21:22:35', '2017-03-01 21:22:38', 'system');
INSERT INTO `operation` VALUES ('122', '3502', 'view', '查看', '86', '', '2017-03-01 21:22:35', '2017-03-01 21:22:38', 'system');
INSERT INTO `operation` VALUES ('123', '3502', 'read', '查看', '87', '', '2017-03-01 21:24:40', '2017-03-01 21:24:42', 'system');
INSERT INTO `operation` VALUES ('124', '3502', 'save', '新增', '87', '', '2017-03-01 21:25:13', '2017-03-01 21:25:16', 'system');
INSERT INTO `operation` VALUES ('125', '3502', 'update', '修改', '87', '', '2017-03-01 21:25:34', '2017-03-01 21:25:36', 'system');
INSERT INTO `operation` VALUES ('126', '3502', 'delete', '删除', '87', '', '2017-03-01 21:25:53', '2017-03-01 21:25:55', 'system');
INSERT INTO `operation` VALUES ('127', '3502', 'read', '查看', '88', '', '2017-03-01 21:24:40', '2017-03-01 21:24:42', 'system');
INSERT INTO `operation` VALUES ('128', '3502', 'save', '新增', '88', '', '2017-03-01 21:25:13', '2017-03-01 21:25:16', 'system');
INSERT INTO `operation` VALUES ('129', '3502', 'update', '修改', '88', '', '2017-03-01 21:25:34', '2017-03-01 21:25:36', 'system');
INSERT INTO `operation` VALUES ('130', '3502', 'delete', '删除', '88', '', '2017-03-01 21:25:53', '2017-03-01 21:25:55', 'system');
INSERT INTO `operation` VALUES ('131', '3502', 'read', '查看', '89', '', '2017-03-01 21:24:40', '2017-03-01 21:24:42', 'system');
INSERT INTO `operation` VALUES ('132', '3502', 'save', '新增', '89', '', '2017-03-01 21:25:13', '2017-03-01 21:25:16', 'system');
INSERT INTO `operation` VALUES ('133', '3502', 'update', '修改', '89', '', '2017-03-01 21:25:34', '2017-03-01 21:25:36', 'system');
INSERT INTO `operation` VALUES ('134', '3502', 'delete', '删除', '89', '', '2017-03-01 21:25:53', '2017-03-01 21:25:55', 'system');
INSERT INTO `operation` VALUES ('135', '3502', 'read', '查看', '90', '', '2017-03-01 21:24:40', '2017-03-01 21:24:42', 'system');
INSERT INTO `operation` VALUES ('136', '3502', 'save', '新增', '90', '', '2017-03-01 21:25:13', '2017-03-01 21:25:16', 'system');
INSERT INTO `operation` VALUES ('137', '3502', 'update', '修改', '90', '', '2017-03-01 21:25:34', '2017-03-01 21:25:36', 'system');
INSERT INTO `operation` VALUES ('138', '3502', 'delete', '删除', '90', '', '2017-03-01 21:25:53', '2017-03-01 21:25:55', 'system');
INSERT INTO `operation` VALUES ('139', '3502', 'read', '查看', '91', '', '2017-03-01 21:24:40', '2017-03-01 21:24:42', 'system');
INSERT INTO `operation` VALUES ('140', '3502', 'save', '新增', '91', '', '2017-03-01 21:25:13', '2017-03-01 21:25:16', 'system');
INSERT INTO `operation` VALUES ('141', '3502', 'update', '修改', '91', '', '2017-03-01 21:25:34', '2017-03-01 21:25:36', 'system');
INSERT INTO `operation` VALUES ('142', '3502', 'delete', '删除', '91', '', '2017-03-01 21:25:53', '2017-03-01 21:25:55', 'system');
INSERT INTO `operation` VALUES ('143', '3502', 'read', '查看', '92', '', '2017-03-01 21:24:40', '2017-03-01 21:24:42', 'system');
INSERT INTO `operation` VALUES ('144', '3502', 'save', '新增', '92', '', '2017-03-01 21:25:13', '2017-03-01 21:25:16', 'system');
INSERT INTO `operation` VALUES ('145', '3502', 'update', '修改', '92', '', '2017-03-01 21:25:34', '2017-03-01 21:25:36', 'system');
INSERT INTO `operation` VALUES ('146', '3502', 'delete', '删除', '92', '', '2017-03-01 21:25:53', '2017-03-01 21:25:55', 'system');
INSERT INTO `operation` VALUES ('147', '3502', 'read', '查看', '93', '', '2017-03-01 21:24:40', '2017-03-01 21:24:42', 'system');
INSERT INTO `operation` VALUES ('149', '3502', 'save', '购买', '94', '', '2017-03-01 21:25:13', '2017-03-01 21:25:16', 'system');
INSERT INTO `operation` VALUES ('150', '3502', 'read', '查看', '95', '', '2017-03-01 21:24:40', '2017-03-01 21:24:42', 'system');
INSERT INTO `operation` VALUES ('151', '3502', 'save', '新增', '95', '', '2017-03-01 21:25:13', '2017-03-01 21:25:16', 'system');
INSERT INTO `operation` VALUES ('152', '3502', 'update', '修改', '95', '', '2017-03-01 21:25:34', '2017-03-01 21:25:36', 'system');
INSERT INTO `operation` VALUES ('153', '3502', 'delete', '删除', '95', '', '2017-03-01 21:25:53', '2017-03-01 21:25:55', 'system');
INSERT INTO `operation` VALUES ('154', '3502', 'delete', '删除', '96', '', '2017-03-01 21:25:53', '2017-03-01 21:25:55', 'system');
INSERT INTO `operation` VALUES ('155', '3502', 'save', '新增', '96', '', '2017-03-01 21:25:13', '2017-03-01 21:25:16', 'system');
INSERT INTO `operation` VALUES ('156', '3502', 'update', '修改', '96', '', '2017-03-01 21:25:34', '2017-03-01 21:25:36', 'system');
INSERT INTO `operation` VALUES ('157', '3502', 'read', '查看', '96', '', '2017-03-01 21:24:40', '2017-03-01 21:24:42', 'system');
INSERT INTO `operation` VALUES ('158', '3502', 'read', '查看', '97', '', '2017-03-01 21:24:40', '2017-03-01 21:24:42', 'system');
INSERT INTO `operation` VALUES ('159', '3502', 'save', '新增', '97', '', '2017-03-01 21:25:13', '2017-03-01 21:25:16', 'system');
INSERT INTO `operation` VALUES ('160', '3502', 'update', '修改', '97', '', '2017-03-01 21:25:34', '2017-03-01 21:25:36', 'system');
INSERT INTO `operation` VALUES ('161', '3502', 'delete', '删除', '97', '', '2017-03-01 21:25:53', '2017-03-01 21:25:55', 'system');
INSERT INTO `operation` VALUES ('162', '3502', 'read', '申报', '98', '', '2017-03-01 21:24:40', '2017-03-01 21:24:42', 'system');
INSERT INTO `operation` VALUES ('166', '3502', 'read', '申报', '99', '', '2017-03-01 21:24:40', '2017-03-01 21:24:42', 'system');
INSERT INTO `operation` VALUES ('170', '3502', 'read', '申报', '100', '', '2017-03-01 21:24:40', '2017-03-01 21:24:42', 'system');
INSERT INTO `operation` VALUES ('177', '3502', 'read', '申报', '101', '', '2017-03-01 21:24:40', '2017-03-01 21:24:42', 'system');
INSERT INTO `operation` VALUES ('178', '3502', 'read', '申报', '102', '', '2017-03-01 21:24:40', '2017-03-01 21:24:42', 'system');
INSERT INTO `operation` VALUES ('182', '3502', 'read', '查看', '103', '', '2017-03-01 21:24:40', '2017-03-01 21:24:42', 'system');
INSERT INTO `operation` VALUES ('183', '3502', 'delete', '重命名', '32', '', '2017-03-01 21:25:53', '2017-03-01 21:25:55', 'system');
INSERT INTO `operation` VALUES ('184', '3502', 'jj', '查看', '104', '', '2017-03-01 21:22:35', '2017-03-01 21:22:38', 'system');
INSERT INTO `operation` VALUES ('185', '3502', 'save', '新增', '105', '', '2017-03-01 21:25:13', '2017-03-01 21:25:16', 'system');
INSERT INTO `operation` VALUES ('186', '3502', 'update', '修改', '105', '', '2017-03-01 21:25:34', '2017-03-01 21:25:36', 'system');
INSERT INTO `operation` VALUES ('187', '3502', 'delete', '删除', '105', '', '2017-03-01 21:25:53', '2017-03-01 21:25:55', 'system');
INSERT INTO `operation` VALUES ('188', '3502', 'read', '查看', '105', '', '2017-03-01 21:24:40', '2017-03-01 21:24:42', 'system');
INSERT INTO `operation` VALUES ('189', '3502', 'save', '新增', '106', '', '2017-03-01 21:25:13', '2017-03-01 21:25:16', 'system');
INSERT INTO `operation` VALUES ('190', '3502', 'update', '修改', '106', '', '2017-03-01 21:25:34', '2017-03-01 21:25:36', 'system');
INSERT INTO `operation` VALUES ('191', '3502', 'delete', '删除', '106', '', '2017-03-01 21:25:53', '2017-03-01 21:25:55', 'system');
INSERT INTO `operation` VALUES ('192', '3502', 'read', '查看', '106', '', '2017-03-01 21:24:40', '2017-03-01 21:24:42', 'system');
INSERT INTO `operation` VALUES ('193', '3502', 'save', '新增', '107', '', '2017-03-01 21:25:13', '2017-03-01 21:25:16', 'system');
INSERT INTO `operation` VALUES ('194', '3502', 'update', '修改', '107', '', '2017-03-01 21:25:34', '2017-03-01 21:25:36', 'system');
INSERT INTO `operation` VALUES ('195', '3502', 'delete', '删除', '107', '', '2017-03-01 21:25:53', '2017-03-01 21:25:55', 'system');
INSERT INTO `operation` VALUES ('196', '3502', 'read', '查看', '107', '', '2017-03-01 21:24:40', '2017-03-01 21:24:42', 'system');
INSERT INTO `operation` VALUES ('197', '3502', 'edit', '维护', '108', '', '2017-03-01 21:24:40', '2017-03-01 21:24:42', 'system');
INSERT INTO `operation` VALUES ('198', '3502', 'log', '日志', '95', '', '2017-03-01 21:25:53', '2017-03-01 21:25:55', 'system');
INSERT INTO `operation` VALUES ('199', '3502', 'gh', '归还', '95', '', '2017-03-01 21:25:53', '2017-03-01 21:25:55', 'system');
INSERT INTO `operation` VALUES ('200', '3502', 'pc', '派出', '95', '', '2017-03-01 21:25:53', '2017-03-01 21:25:55', 'system');
INSERT INTO `operation` VALUES ('201', '3502', 'zx', '注销', '96', '', '2017-03-01 21:24:40', '2017-03-01 21:24:42', 'system');
INSERT INTO `operation` VALUES ('202', '3502', 'ly', '领用', '96', '', '2017-03-01 21:24:40', '2017-03-01 21:24:42', 'system');
INSERT INTO `operation` VALUES ('203', '3502', 'gh', '归还', '96', '', '2017-03-01 21:24:40', '2017-03-01 21:24:42', 'system');
INSERT INTO `operation` VALUES ('204', '3502', 'log', '日志', '96', '', '2017-03-01 21:24:40', '2017-03-01 21:24:42', 'system');
INSERT INTO `operation` VALUES ('205', '3502', 'ys', '遗失', '96', '', '2017-03-01 21:24:40', '2017-03-01 21:24:42', 'system');
INSERT INTO `operation` VALUES ('206', '3502', 'del', '删除', '86', '', '2017-03-01 21:22:35', '2017-03-01 21:22:38', 'system');
INSERT INTO `operation` VALUES ('207', '3502', 'import', '导入', '75', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('208', '3502', 'out', '导出', '75', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('209', '3502', 'import', '导入', '65', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('210', '3502', 'out', '导出', '65', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('211', '3502', 'import', '导入', '5', '', '2017-06-29 23:30:20', '2017-06-29 23:30:23', 'system');
INSERT INTO `operation` VALUES ('212', '3502', 'out', '导出', '5', '', '2017-06-29 23:30:20', '2017-06-29 23:30:23', 'system');

-- 插入admin角色的权限信息
INSERT INTO permission (native_code,role_id,module_id,operation_id,roletype) SELECT '3502',1,module_id,id,'1' FROM operation t where module_id in( select id from module where moduletype=1);
-- 更新角色关系
update user_role set roleid =1 where roleid=584;
-- 插入admin与角色的关系
INSERT INTO `user_role` ( `native_code`, `active`, `create_time`, `update_time`, `update_by`, `roleid`, `userid`) VALUES ( '3502', '', '2017-07-09 13:45:57', '2017-07-09 13:45:57', 'xmga', '1', '3');


