package com.bcxin.ars.service.task;

import com.bcxin.ars.dto.*;
import com.bcxin.ars.dto.task.TaskDetailSearchDto;
import com.bcxin.ars.dto.task.TaskDto;
import com.bcxin.ars.dto.task.TaskListDto;
import com.bcxin.ars.model.SecurityPerson;
import com.bcxin.ars.model.task.Task;
import com.bcxin.ars.model.task.TaskPerson;

import java.io.File;
import java.util.List;
import java.util.Map;

/**
 * 任务服务
 * @author Ethan
 */
public interface TaskService {

	/**
	 * 任务一键搜服务
	 * @para`m dto
	 * @return
	 */
	TaskSearchDto search(TaskSearchDto dto);

	/**
	 * 任务搜索服务 支持保安员管理权限
	 * @para`m dto
	 * @return
	 */
	TaskSearchDto searchForPersonManage(TaskSearchDto dto);

	/**
	 * 任务管理
	 * @param dto
	 * @return
	 */
	TaskSearchDto searchForManage(TaskSearchDto dto);
	
	/**
	 * 根据ID获取任务
	 * @param id
	 * @return
	 */
	Task findById(Long id);

	/**
	 * 根据紧急ID获取任务
	 * @param id
	 * @return
	 */
	Task findUrgentById(Long id);


	/**
	 * 根据人员ID获取紧急任务列表
	 * @param dto 人员ID
	 * @return
	 */
	public List<Task> findUrgentByPersnId(UrgentTaskDTO dto);
	/**
	 * 新增或更新任务
	 * @param task
	 * @return
	 */
	void saveOrUpdate(Task task);
	
	/**
	 * 根据当前系统时间更新任务状态
	 */
	void updateStatus();
	
	/**
	 * 
	 * <b>Function </b> 修改任务中人员的接受状态
	 * 
	 * @param taskPerson
	 * @注意事项 </b>
	 * <b>
	 */
	void updateAcceptStatus(TaskPerson taskPerson);
	
	/**
	 * 删除任务
	 * @param task
	 * @return
	 */
	void delete(Task task);

	/**
	 * 删除排班信息
	 * @param task
	 */
	void deletePersonList(Task task);

	/**
	 * 根据保安员查询任务列表
	 * @param person
	 * @return
	 */
	List<Task> findByPerson(SecurityPerson person);
	
	/**
	 * 
	 * <b>Function </b> 根据用户ID和接收状态查询任务
	 * 
	 * @return
	 * @注意事项 </b>
	 * <b>
	 */
	List<Task> findByPersonAcceptStatus(Long personId, Integer acceptStatus);

	//List<Task> findTaskListByPersonid(Long personId);

	/**
	 * app任务列表查询
	 * @param searchDto
	 * @return
	 */
	TaskSearchDto findTaskListByPersonid(TaskSearchDto searchDto);

	/**
	 * 任务地区画像
	 * @return
	 */
	List<ReportData> findAreaReport();

	/**
	 * 任务类型画像
	 * @return
	 */
	Map<String, String[]> findCatalogReport();

	/**
	 * 任务人员等级画像
	 * @return
	 */
	List<ReportData> findLevelReport();
	/**
	 * 生成已接收的子任务
	 * <b>Function </b> 
	 * 
	 * @注意事项 </b>
	 * <b>
	 */
	void autoCreateTaskFeedback();

	void checkTaskDateSchedule(Long taskId, Long personId, Long scheduleId, Long taskTypeId, String taskDate);

	/**
	 * 
	 * <b>Function </b> 根据用户ID,任务状态，分钟数查询
	 * 
	 * @param personId
	 * @param taskStatus
	 * @param minutes
	 * @return
	 * @author LinQingLin 
	 * @date 2017年3月9日 下午5:55:07
	 * @注意事项 </b>
	 * <b>
	 */
	List<Task> findTaskList(Long personId, Long taskStatus, Integer minutes);

	Task findDetailByIdPerson(Long taskId, Long personId);

	TaskSearchDto searchForFeedback(TaskSearchDto dto);

	/**
	 * 查询紧急任务，当前用户是保安公司的话，那么查询保安公司相关的紧急任务，公关则查询全部
	 * @return
	 */
	UrgentTaskDTO findUrgentTask(UrgentTaskDTO dto);
	/***
	 * 保存保安人员与任务的关系
	 * @param taskid
	 * @param personid
	 */
	void saveUrgentTaskPerson(Long taskid, Long personid);

	/***
	 * 保存保安人员与任务的关系
	 * @param task 任务
	 * @param person 人员
	 */
	boolean saveUrgentTaskPerson(Task task, SecurityPerson person);

	/***
	 * 结束紧急任务
	 * @param taskid 任务主键
	 */
	void endUrgentTask(Long taskid);
	public void endUrgentTaskMessage(Long taskid);
	/***
	 * 根据人员ID和任务ID获取信息
	 * @param personId 人员
	 * @param taskId 任务
	 * @return
	 */
	TaskPerson findByPersonIdAndTaskId(Long personId, Long taskId);

	/**
	 * 获取公司热力
	 * @param companyid
	 * @return
	 */
	List<HotMap> findCompanyHot(Long companyid);
	/**
	 * 获取人员热力
	 * @param personid
	 * @return
	 */
	List<HotMap> findPersonHot(Long personid);

	/**
	 * 紧急任务推送
	 * <b>Function </b> 
	 * 
	 * @author LinQingLin 
	 * @date 2017年6月14日 下午4:16:06
	 * @注意事项 </b>
	 * <b>
	 */
	void sendUrgentTask();

	/**
	 * 查询需要迁移的数据
	 * <b>Function </b> 
	 * 
	 * @param dto
	 * @return
	 * @author LinQingLin 
	 * @date 2017年7月4日 下午1:48:01
	 * @注意事项 </b>
	 * <b>
	 */
	List<Task> searchForDataSynchronization(DataSynchronizationSearchDto dto);

	void saveOrUpdateForDS(Task task);

	void exportTask(Task data, File file);

	Map<String, Object> importTask(File excel) throws Exception;



	void updateEndStatus();

	TaskDto findTaskDetail(TaskDetailSearchDto taskDetailDto);
	
	/**************************************V1.0.9APP版本****************************************************/
	/**
	 * app任务列表查询
	 * @param searchDto
	 * @return
	 */
	TaskSearchDto findTaskListByPersonid_V109(TaskSearchDto searchDto);
	/**
	 * app任务详情
	 * @param searchDto
	 * @return
	 */
	TaskDto findTaskDetailV109(TaskDetailSearchDto taskDetailDto);
}
