package com.bcxin.ars.service.task;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.page.task.ComTaskSearchDto;
import com.bcxin.ars.dto.task.ComTaskDto;
import com.bcxin.ars.model.task.ComTask;
import com.bcxin.ars.model.task.ComTaskPer;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;

import java.util.List;

/**
 * 驻勤点service接口
 * @author linqinglin
 * @date 2019/10/11 0011 11:07
 */
public interface ComTaskService {

    /**
     * 分页查询
     * @param dto
     * @param page
     */
    void search(ComTaskSearchDto dto, AjaxPageResponse<ComTaskDto> page);

    /**
     * 根据 id 查询
     * 只查询部分字段及转码后给页面展示
     * @param id
     * @return
     */
    ComTaskDto findDetailById(Long id);

    /**
     * 根据 id 查询
     * 查询全部字段
     * @param id
     * @return
     */
    ComTask findById(Long id);

    /**
     * 保存
     * @param comTask
     */
    void save(ComTask comTask);

    /**
     * 批量导入
     * @param list
     */
    void importBatch(List<ComTask> list);

    /**
     * 外导内数据查询
     * @param dto
     * @return
     */
    List<ComTask> searchForDataSynchronization(DataSynchronizationSearchDto dto);

    /**
     * 根据合同id查询
     * @param contractId
     * @return
     */
    List<ComTask> findByContractId(String contractId);

    /**
     * 根据人员获取驻勤点信息
     * @param perId
     * @return
     */
    List<ComTask> findByPerId(Long perId);

    /**
     * 定时器更新驻勤状态和合同状态
     */
    void updateStatusV2();

    void addPersons(ComTask comTask,String perIdListStr);

    void removePersons(ComTask comTask,String perIdListStr);

    void delete(ComTask comTask);

    void deleteBatch(Long[] taskIdList);

    /**
     * 根据公司ID获取有资格的驻勤点
     * @param comId
     * @return
     */
    List<ComTask> findByComId(String comId);

}
