package com.bcxin.ars.service.task;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.page.task.ComShiftPageSearchDto;
import com.bcxin.ars.dto.task.ComShiftDto;
import com.bcxin.ars.model.task.ComShift;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;

import java.util.List;

/**
 * 企业班次Service接口
 *
 * @author linqinglin
 * @Date 2020-03-26 09:39:32
 */
public interface ComShiftService {

   /****
     * 删除
     * @param comShift
     * @return
     */
    int delete(ComShift comShift);

    /****
     * 保存
     * @param comShift
     * @return
     */
    int save(ComShiftDto comShift);

    /****
     * 选择性修改
     * @param comShift
     * @return
     */
    void updateSelective(ComShift comShift);

    /****
     * 主键查询
     * @param id
     * @return
     */
    ComShift findById(Long id);

    /**
     * 分页查询
     * @param searchDto
     * @param page
     * @return
     */
    void searchForPage(ComShiftPageSearchDto searchDto, AjaxPageResponse<ComShift> page);

    /**
     * 外导内查询
     * @param searchDto
     * @return
     */
    List<ComShift> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

    /**
     * 内导外查询
     * @param startDate
     * @return
     */
    List<ComShift> findDSOutList(String startDate);

    /**
     * 批量保存
     * @param list
     */
    void importBatch(List<ComShift> list);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<ComShift> findByBatchId(List<ComShift> list);
}
