package com.bcxin.ars.service.sb;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.certificate.GradeAndCertificateDto;
import com.bcxin.ars.dto.sb.PersonGradeSearchDto;
import com.bcxin.ars.model.sb.PersonGrade;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;

import java.util.List;

/**
 * 等级证报名
 * @author linqinglin
 * @date 2019/12/31 0031 15:29
 */
public interface PersonGradeService {

    /**
     * 分页查询
     * @param searchDto
     * @param page
     */
    void searchForPage(PersonGradeSearchDto searchDto, AjaxPageResponse page);


    void searchForPageBySubsity(PersonGradeSearchDto searchDto, AjaxPageResponse page);
    /**
     * 根据主键id查询
     * @param id
     * @return
     */
    PersonGrade findById(Long id);

    /**
     * 保存 没有就插入，有就更新
     * @param personGrade
     */
    void save(PersonGrade personGrade);

    /**
     * 根据主键选择性修改（null值不修改）
     * @param personGrade
     */
    void updateSelective(PersonGrade personGrade);

    /**
     * 批量保存 外网同步到内网
     * @param list
     */
    void importBatch(List<PersonGrade> list);

    /**
     * 批量保存 内网同步到外网
     * @param list
     */
    void importBatchForDSIn2Out(List<PersonGrade> list);

    /**
     * @Decription:搜索同步到内网的数据
     * @param dto
     * @return
     */
    List<PersonGrade> searchForDataSynchronization(DataSynchronizationSearchDto dto);

    /**
     * 内导外搜索数据
     * @param startDate
     * @return
     */
    List<PersonGrade> findDSOutList(String startDate);

    /**
     * 批量修改
     * @param list
     */
    void batchUpdate(List<PersonGrade> list);

    /**
     * 批量根据人员id查询报名状态与证书类型
     * @param personIds
     * @return
     */
    List<GradeAndCertificateDto> checkPersonRegister(Long[] personIds);

    List<GradeAndCertificateDto> checkPersonRegisterV2(Long[] personIds);

    int checkPersonGradeCer(PersonGrade personGrade);

    /**
     * 批量确认等级证成绩
     * @param list
     */
    void batchUpdateScore(List<PersonGrade> list);

    /**
     * 等级证报名补贴比对结果同步百课堂
     * @param gradeList
     */
    void compareStatusToBKT(List<PersonGrade> gradeList);

    /**
     * 修改比对信息
     *
     * @param personGrade
     */
    void updateCompareInfo(PersonGrade personGrade);

    /**
     * 等级证报名
     *
     * @param gradeCertificate 等级证
     * @return businessId -> 等级证表添加后的id
     */
    AjaxResult gradeCertificateApply(String gradeCertificate);

    /**
     * 同步等级证信息
     *
     * @param personGrades 等级证信息
     * @return idNumber:true/false
     */
    AjaxResult syncGradeCertificateInformation(String personGrades);

    /**
     * 撤销报名等级证
     *
     * @param gradeCertificateId 等级证id
     * @return 成功信息
     */
    AjaxResult cancelGradeCertificateApply(String gradeCertificateId);

    /**
     * 批量查询人员是否能报名等级证
     *
     * @param idNumbers 身份证集合
     * @return {@link AjaxResult}
     */
    AjaxResult canSignUpGradeCertificate(String idNumbers);

}
