package com.bcxin.ars.service.sb;

import com.bcxin.ars.dto.OrderDetailDTO;
import com.bcxin.ars.model.sb.OrderDetail;

import java.util.List;

/**
 * Created by 苏 on 2017/5/19.
 */
public interface OrderDetailService {
	/**
	 *
	 * @Decription:根据id查询
	 * @author：zhongjianhui
	 * @method  fingById
	 * @date：2018/8/26 11:00
	 * @params： * @param id
	 * @return com.bcxin.ars.model.sb.OrderDetail
	 */
	OrderDetail fingById(Long id);
	/**
	 *
	 * @Decription:新增订单信息
	 * @author：zhongjianhui
	 * @method  fingById
	 * @date：2018/8/26 11:00
	 * @params： * @param id
	 * @return com.bcxin.ars.model.sb.OrderDetail
	 */
	void insert(OrderDetail orderDetail);
	/**
	 *
	 * @Decription:更新订单信息
	 * @author：zhongjianhui
	 * @method  fingById
	 * @date：2018/8/26 11:00
	 * @params： * @param id
	 * @return com.bcxin.ars.model.sb.OrderDetail
	 */
	void update(OrderDetail orderInfo);
	/**
	 *
	 * @Decription:根据订单信息查询订单详细信息
	 * @author：zhongjianhui
	 * @method  fingById
	 * @date：2018/8/26 11:00
	 * @params： * @param id
	 * @return com.bcxin.ars.model.sb.OrderDetail
	 */
	List<OrderDetail> selectOrderDetailByInfoId(Long orderInfoId);
	/**
	 *
	 * @Decription:订单详情更新保安员资格证
	 * @author：zhongjianhui
	 * @method  insertBatchCetificate
	 * @date：2018/8/26 11:00
	 * @params： * @param id
	 * @return com.bcxin.ars.model.sb.OrderDetail
	 */
	void insertBatchCetificate(List<OrderDetailDTO> orderDetail);

}
