package com.bcxin.ars.service.sb;

import com.bcxin.ars.dto.ActivityRepairApprovalDto;
import com.bcxin.ars.dto.ActivityRepairApprovalSearchDto;
import com.bcxin.ars.dto.ActivityRepairDto;
import com.bcxin.ars.model.PageResult;
import com.bcxin.ars.model.sb.Personcertificate;
import com.bcxin.ars.model.sys.Approval;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;

import java.util.List;
import java.util.Map;

/**
 * @author linqinglin
 * @date 2018/09/26 0026 9:44
 */
public interface ActivityRepairService {

    /**
     * 重置流程
     * @param personcertificateId
     */
    void resetProcess(Long personcertificateId);

    /**
     * 重启流程
     * @param personcertificateId
     */
    void restartProcess(Long personcertificateId);
    /**
     * 跳流程 仅适用于旧审批
     * @param activityRepairDto
     */
    void skipProcess(ActivityRepairDto activityRepairDto);

    /**
     * 流程打回
     * @param personIds
     */
    void batchRepulse(Long[] personIds);

    /**
     * 流程打回+缴费完不能打回
     * @param personIds
     */
    void batchRepulseAndNotFeeState(Long[] personIds);

    /**
     * 旧审批转新审批
     * @param approval
     */
    void approvalOldToNew(Approval approval);

    /**
     * 旧审批转新审批
     * @param approvalId
     */
    void approvalOldToNew(Long approvalId);

    int getApproveSeq(Approval approval);

    PageResult searchApprovalList(Map<Object, Object> p);

    List<Personcertificate> checkReturn(Long[] perIds);

    List<Long> checkCanReturnPerson(Long[] perIds);

    void jumpNextProcess(Long approvalId) throws Exception;

    void repulseProcess(Long approvalId) throws Exception;

    void reStartProcess(Long approvalId) throws Exception;

    void getFinger(Long personId);

    /***
     * 审批流程修复查询
     * @param dto 查询条件参数
     * @param ajaxPageResponse 返回数据对象
     * @return 查询列表
     */
    void search(ActivityRepairApprovalSearchDto dto, AjaxPageResponse<ActivityRepairApprovalDto> ajaxPageResponse);
}
