package com.bcxin.ars.service.certificate;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.certificate.SecurityCerDto;
import com.bcxin.ars.dto.certificate.SecurityCertificateSearchDto;
import com.bcxin.ars.dto.page.SecurityCertificateDto;
import com.bcxin.ars.dto.page.SecurityCertificatePageSearchDto;
import com.bcxin.ars.model.SecurityPerson;
import com.bcxin.ars.model.certificate.SecurityCertificate;
import com.bcxin.ars.model.sb.Personcertificate;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;

import java.io.IOException;
import java.util.List;
import java.util.Map;

public interface SecurityCertificateService {

	List<String> batchUpdateState(String idNums,String isState,String makeCard) throws IOException;

	List<String> batchexportAppPhoto(List<Map<String, String>> idList) throws IOException;

	SecurityCertificate findById(Long id);

	void saveOrUpdate(SecurityCertificate securityCertificate);

	SecurityCertificateSearchDto search(SecurityCertificateSearchDto dto);

	void delete(SecurityCertificate securityCertificate);
	/**
	 * 根据申请ID查询证书信息，
	 * @param securitypersonid 保报iD
	 * @return
	 */
	SecurityCertificate findBySecuritypersonid(long securitypersonid);
	/**
	 * 根据申请ID查询证书信息
	 * @param securitypersonid 报名ID
	 * @param type 打印地址类型
	 * @return
	 */
	SecurityCertificate findBySecuritypersonid(long securitypersonid,String type);
	/**
	 * 批量打印
	 * @param dto
	 * @return
	 */
	List<SecurityCertificate> findBySecuritypersonidArr(SecurityCertificateSearchDto dto);

	/**
	 * 批量更新打印状态
	 * @param idArray
	 */
	void updatePrintedByidArr(Long[] idArray);


	/**
	 * 更新打印状态并记录日志
	 * @param securitypersonid
	 */
	void updatePrintedByLog(Long securitypersonid,String printType);


	/**
	 * 批量更新打印状态
	 * @param idArray
	 * @param snapshotIdArr
	 */
	void updatePrinted(Long[] idArray,Long[] snapshotIdArr,String printType);
	/**
	 * 更新打印次数
	 * @param personCertificate
	 */
	void updatePrinteCount(SecurityCertificate personCertificate);

	List<SecurityCertificate>  findDetail(SecurityCertificateSearchDto dto);

	List<SecurityCertificate> searchUpdateflagForExport();

	void outerSaveOrUpdateForDS(SecurityCertificate cert);

	/**
	 * 外到内更新
	 * @param cert
	 */
	void saveOrUpdateForDS(SecurityCertificate cert);

	/**
	 * 查询需要生成同步文件的保安员资格证记录
	 * @param dto
	 * @return
	 */
	List<SecurityCertificate> searchForDataSynchronization(DataSynchronizationSearchDto dto);

	String setPhotoData(SecurityCertificate securityCertificate);

	String getPhotoUrl(SecurityCertificate securityCertificate);

	String setPhotoDataV1(SecurityCertificate securityCertificate,String headStr);

	/**
	 * @athour wjb
	 * @time  2018年8月21日09:48:48
	 * @param decodeCertificateId
	 * @param certificateId 加密的ID
	 * @param path 访问路径
	 * @desc  查询保安员证书信息，包括返回照片跟二维码
	 * @return SecurityCertificate
	 */
	SecurityCertificate findBySecuritypersonidWithPhotoAndQR(long decodeCertificateId, String certificateId, String path);

	/**
	 * @athour wjb
	 * @time  2018年8月21日16:41:24
	 * @param personId
	 * @desc  查询保安员证书信息（APP）
	 * @return SecurityCertificate
	 */
	SecurityCertificate findBySecuritypersonidForApp(long personId);

	void getPersonImg(Long[] idArrays) throws IOException;

	String getPersonImg(Long personId) throws IOException;


	/**
	 * 批量证书领取状态
	 * @param  保安员资格证ID列表
	 * @return 无
	 * @desc edit 2019-03-30 subh 14:33
	 */
	void updateReceiveState(Long[] idArr);

	/***
	 * 培训机构保安员证书查询
	 * @param dto 查询条件参数
	 * @param ajaxPageResponse 返回对象
	 * @return 查询列表
	 */
	void searchForTrain(SecurityCertificateSearchDto dto, AjaxPageResponse<Personcertificate> ajaxPageResponse);

	/**
	 *获取同步到外网的数据列表
	 * @param startDate 开始日期
	 */
	List<SecurityCertificate> findDSOutList(String startDate);

	/**
	 * 批量导入
	 * @param list
	 */
	void importBatch(List<SecurityCertificate> list);

	/**
	 * 保安员资格申报审批通过生成证书同步保安员表
	 * @param detail 保安员证书信息
	 */
	AjaxResult updateSecurityPersonCertificateInfo(SecurityCertificate detail);

	AjaxResult pushPersonCertificateToSAAS(SecurityCertificate SecurityCertificate);

	/**
	 * 修改
	 * 仅信息的修改
	 * @param securityCertificate
	 */
	void edit(SecurityCertificate securityCertificate);

	/**
	 * 分页查询
	 * @param dto
	 * @param page
	 */
	void searchForPage(SecurityCertificatePageSearchDto dto, AjaxPageResponse<SecurityCertificateDto> page);

	/**
	 * 获取详情
	 * @param id
	 * @return
	 */
	SecurityCertificate getDetail(Long id);

	void batchSaveElectronCerUrlForOldData();


	/***
	 * 关联旧数据
	 * @param person 人员信息
	 */
	void relationOldCert(SecurityPerson person);

	/**
	 * 陕西批量查询人口库地址
	 * @param dto
	 * @return
	 */
	List<SecurityCertificate> findBySecuritypersonidArrBatch(SecurityCertificateSearchDto dto);

	/**
	 * 获取电子证书二维码（快照）
	 * @param snapshotId
	 * @return
	 * @throws Exception
	 */
	String getQRCode(String snapshotId) throws Exception;
	String getQRCodeForThirdParty(String snapshotId) throws Exception;

	/**
	 * 获取电子证书地址（快照）
	 * @param snapshotId
	 * @return
	 * @throws Exception
	 */
	String getElectronCerUrl(String snapshotId) throws Exception;

	/**
	 * 打印证书查询
	 * @param securitypersonid
	 * @param type
	 * @return
	 */
	SecurityCertificate previewById(Long id, String type);

	/**
	 * 保存证书快照
	 * @param securityCertificate
	 * @param personId
	 * @param photo
	 * @return
	 */
	Long savePerCerSnapshot(SecurityCertificate securityCertificate, String photo);

	/**
	 * 批量打印证书查询
	 * @param dto
	 * @return
	 */
	List<SecurityCertificate> previewByIdArr(SecurityCertificateSearchDto dto);

	/**
	 * 是否已持证
	 * @param idNum
	 * @return
	 */
	Boolean checkCerStatus(String idNum);
	/**
	 * 是否可报名
	 * @param idNum
	 * @return
	 */
	AjaxResult checkStatusForApply(String idNum);

	void updateSnapshotId(SecurityCertificate securityCertificate);
	void updateBatchSnapshotId(List<SecurityCertificate> list);
	List<String> updateIsDraw(List<String> idNums);

	List<SecurityCertificate> findAddressByIdArr(Long[] idArr);

	void reCer(Long cerId);

    AjaxResult checkyearAndday(String idNum);

	AjaxResult searchForPublicQuery(String idnum);

	/**
	 * 校验人员是否可报资格证
	 *
	 * @param idNumbers 身份证集合
	 * @return {身份证,true/false}
	 */
	AjaxResult canSignUpSecurityCertificate(String idNumbers);

	/**
	 * 校验人员是否可报资格证
	 *
	 * @param idNumber 身份证
	 * @return {@link Boolean} true/false
	 */
	boolean checkCanApplySecurityCertificate(String idNumber);

	SecurityCerDto findByIdNum(String idNum);
}
