package com.bcxin.ars.service.certificate;

import com.bcxin.ars.dto.certificate.CompanyCertificateSearchDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.certificate.CompanyCertificate;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;

import java.util.List;

public interface CompanyCertificateService {

	CompanyCertificate findById(long id);
	/***
	 * 根据id获取证书并生成相应类型
	 * @param id
	 * @return
	 */
	CompanyCertificate findById(long id,String type);
	CompanyCertificate findByIdV2(long id,String type);
	void saveOrUpdate(CompanyCertificate companyCertificate);
	/***
	 * 生成项目变更信息
	 * @param companyCertificate
	 */
	void saveOrUpdateForLegalchange(CompanyCertificate companyCertificate);

	/**
	 *
	 * @Decription:修改保安公司证书
	 * @author：zhongjianhui
	 * @method  updateAndCreatePDF
	 * @date：2019/1/22 15:50
	 * @params： * @param companyCertificate
	 * @return void
	 */
	void updateAndCreatePDF(CompanyCertificate companyCertificate);
	CompanyCertificateSearchDto search(CompanyCertificateSearchDto dto);

	void delete(CompanyCertificate companyCertificate);

	CompanyCertificate findBySponsorLicenseId(Long sponsorlicenseid);


	void updateCompanyCertificate(CompanyCertificate companyCertificate);

	CompanyCertificate findByCompanyname(String companyname);

	CompanyCertificate findByCompanyId(Long companyId);


	List<CompanyCertificate> findByXkzh(String xkzh);

	List<CompanyCertificate> findDataByXkzhHistory(String xkzh);

    void updatePrintedByid(Long id);

	/**
	 * 查找变更的数据
	 * @param dto
	 * @return
	 */
	CompanyCertificateSearchDto searchLegalangeChange(CompanyCertificateSearchDto dto);

	/**
	 * 批量生成pdf文件
	 */
	void createPdfBatch ();

    void searchForPage(CompanyCertificateSearchDto dto, AjaxPageResponse<CompanyCertificate> page);

    void saveForRepair(CompanyCertificate companyCertificate);

}
