package com.bcxin.ars.service;

import java.util.List;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.model.SecurityCompanySchedule;

/**
 * 安保公司班次数据类
 * @author Ethan
 */
public interface SecurityCompanyScheduleService {
	
	/**
	 * 获取指定安保公司的班次
	 * @return
	 */
	List<SecurityCompanySchedule> findByCompanyId(Long companyId);
	
	/**
	 * 根据Id获取班次信息
	 * @param id
	 * @return
	 */
	SecurityCompanySchedule findById(Long id);
	
	/**
	 * 新增或更新班次信息
	 * @param schedule
	 * @return
	 */
	void saveOrUpdate(SecurityCompanySchedule schedule);
	
	/**
	 * 删除指定班次
	 * @param schedule
	 */
	void delete(SecurityCompanySchedule schedule);

	long findByCompanyIdWithTask(long id);

	List<SecurityCompanySchedule> searchForDataSynchronization( DataSynchronizationSearchDto searchDto);

	void saveOrUpdateForDS(SecurityCompanySchedule schedule);
	
}
