package com.bcxin.ars.service;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.SbSubsidiaryBaseSearchDto;
import com.bcxin.ars.model.SbSubsidiaryBase;

import java.util.List;

/**
 * 子公司管理类
 * @author Ethan
 */
public interface SbSubsidiaryBaseService {


	/**
	 * 新增或更新子公司基础信息
	 * @param sbSubsidiaryBase
	 */
	void saveOrUpdate(SbSubsidiaryBase sbSubsidiaryBase);

	/**
	 * 根据ID获取子公司基础信息
	 * @param id
	 * @return
	 */
	public SbSubsidiaryBase findById(long id);

	/**
	 * 删除子公司基础信息
	 * @param sbSubsidiaryBase
	 * @return
	 */
	void delete(SbSubsidiaryBase sbSubsidiaryBase);


	/**
	 * 查询子公司基础信息
	 * @param dto
	 * @return
	 */
	public SbSubsidiaryBaseSearchDto search(SbSubsidiaryBaseSearchDto dto);

	List<SbSubsidiaryBase> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

	void saveOrUpdateForDS(SbSubsidiaryBase sbSubsidiaryBase);


}
