package com.bcxin.ars.service;
import java.util.List;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.SbRewardSearchDto;
import com.bcxin.ars.model.SbReward;

/**
 * 子公司管理类
 * @author Ethan
 */
public interface SbRewardService {


	/**
	 * 新增或更新保安奖励信息
	 * @param sbReward
	 */
	void saveOrUpdate(SbReward sbReward);

	/**
	 * 根据ID获取保安奖励信息
	 * @param id
	 * @return
	 */
	public SbReward findById(long id);

	/**
	 * 删除保安奖励信息
	 * @param sbReward
	 * @return
	 */
	void delete(SbReward sbReward);



	/**
	 * 查询保安奖励信息
	 * @param dto
	 * @return
	 */
	public SbRewardSearchDto search(SbRewardSearchDto dto);

	List<SbReward> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

	void saveOrUpdateForDS(SbReward sbReward);

	/**
	 * 新增或更新保安奖励信息 saas
	 * @param sbRewardList
	 */
	void saveOrUpdateForSAAS(List<SbReward> sbRewardList);

	/**
	 * 查询保安奖励信息 saas
	 * @param awardId
	 * @return
	 */
	List<SbReward> findByAwardId(Long awardId);

	/**
	 * 删除保安奖励信息 saas
	 * @param awardId
	 * @return
	 */
	void deleteByawardId(Long awardId);
}
