package com.bcxin.ars.service;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.ProblemPersonReportDto;
import com.bcxin.ars.dto.ProblemPersonSearchDto;
import com.bcxin.ars.model.ProblemPerson;
import com.bcxin.ars.model.SecurityCompany;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;

import java.util.List;
import java.util.Map;

public interface ProblemPersonService {

	void saveOrUpdate(ProblemPerson problemPerson);
	
	void delete(ProblemPerson problemPerson);
	
	ProblemPerson findById(Long id);

	/***
	 * 问题人员查询
	 * @param searchDto 查询参数
	 * @param page 返回对象
	 */
	void search(ProblemPersonSearchDto searchDto, AjaxPageResponse page);

	/***
	 * 公安已处理，企业未处理问题人员查询
	 * @param searchDto 查询参数
	 * @param page 返回对象
	 */
	void searchall(ProblemPersonSearchDto searchDto, AjaxPageResponse page);

    /***
     * 内网更新，不用更新 ：阅读状态、更新时候、更新标识、单位处理状态、单位处理意见，SaaS消息ID
     * @param problemPerson
     */
	void saveDispose(ProblemPerson problemPerson);
    /***
     * 公司保安处理意见,外网更新，只更新 ：更新时候、更新标识、单位处理状态、单位处理意见
     * @param problemPerson 问题人员信息
     */
    void saveCompanyDispose(ProblemPerson problemPerson);

	ProblemPersonReportDto getDataReport(ProblemPersonSearchDto searchDto);

	void saveOrUpdateForDS(ProblemPerson problemPerson);

	List<ProblemPerson> findProblemPersonList();

	/**
	 *获取同步到外网的数据列表
	 * @param startDate 开始日期
	 */
	List<ProblemPerson> findDSOutList(String startDate);

	/**
	 * @Decription:批量保存修改
	 * @param list
	 * @return
	 */
	void importBatch(List<ProblemPerson> list);

	/***
	 * 查询问题人员类型
	 * @return
	 */
	List<String> queryProblemType(String personType);
    /***
     * 查询问题人员类型用于企业
     * @return
     */
    List<String> queryProblemTypeForCompanyId(Long companyId);


    /***
     * 外到内数据摆渡查询
     * @param dto
     * @return
     */
    List<ProblemPerson> searchForDataSynchronization(DataSynchronizationSearchDto dto);


	/**
	 * 根据saas的消息id列表批量更新已读状态
	 * @param newIds
	 */
    void updateReadstateByidArr(Long[] newIds);

    /***
     * 统计问题人员
     * @return
     */
    Map<Object, Object> countAlarm();


    Long getUnDisposeQty();
}
