package com.bcxin.ars.service;

import com.bcxin.ars.dto.*;
import com.bcxin.ars.dto.sb.PoliceSearchDto;
import com.bcxin.ars.model.Police;
import com.bcxin.ars.model.User;

import java.util.List;

/**
 * 机构管理信息
 * @author Ethan
 */
public interface PoliceService {

	/**
	 * 新增或更新机构管理信息
	 * @param police
	 */
	void saveOrUpdate(Police police);

	/**
	 * 更新用户
	 * @param police
	 */
	void updatenum(Police police);

	/**
	 * 根据ID获取机构管理信息
	 * @param id
	 * @return
	 */
	public Police findById(long id);

	/**
	 * 根据机构名称查询
	 * @param orgname
	 * @return
	 */
	Police findByOrgname(String orgname);

	/**
	 * 删除机构管理信息
	 * @param police
	 * @return
	 */
	void delete(Police police);

	/**
	 * 查询机构管理信息
	 * @param dto
	 * @return
	 */
	PoliceSearchDto search(PoliceSearchDto dto);

	PoliceSearchDto searchAll(PoliceSearchDto dto);

	List<Tree> searchForTree(PoliceSearchDto searchDto);

	List<LayTree> searchForLayTree(PoliceSearchDto dto);

	List<MenuTree> searchForMenuTree(PoliceSearchDto dto);

	PoliceSearchDto searchArea(PoliceSearchDto dto);

	List<Police> findByParentOrg(Long  parentorg);

	List<Police> searchParentorg(Police police);

	List<TreeView> searchForTreeView(PoliceSearchDto policeSearchDto);

	List<TreeView> searchForTreeViewByprint(PoliceSearchDto policeSearchDto);
	/**
	 *
	 * @Decription:查询一级机构
	 * @author：zhongjianhui
	 * @method  searchPoliceForTreeViewByprint
	 * @date：2018/11/28 14:34
	 * @params： * @param policeSearchDto
	 * @return java.util.List<com.bcxin.ars.dto.TreeView>
	 */
	List<TreeView> searchPoliceForTreeViewByprint(PoliceSearchDto policeSearchDto);

	/***
	 * 根据ID获取区域列表
	 * @param user
	 * @return
	 */
	List<Police>  findByAreaUserId(User user);

	List<Police> findAll();

	void saveOrUpdateForDS(Police police);

	/**
	 * 根据区域编码查询police
	 * @param police
	 * @return
	 */
	List<Police>  findPoliceByAreacode(Police police);

	void autoExportPolice();

	OrgUserDto findOrgUserForDS(String startDate);

	void saveOrUpdateForImport(Police police);

	List<Police> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

	/**
	 * 更新 是否导出isexport标志位
	 * @param policeSearchDto
	 */
    void updateExport(PoliceSearchDto policeSearchDto);

	/**
	 * 与saas对接
	 *  机构查询
	 * @param policeSearchDto
	 * @return
	 */
    List<PoliceDto> searchForSaas(PoliceSearchDto policeSearchDto);

	/**
	 *获取同步到外网的数据列表
	 * @param startDate 开始日期
	 */
	List<Police> findDSOutList(String startDate);

	/**
	 * @Decription:批量保存修改
	 * @param list
	 * @return
	 */
	void importBatch(List<Police> list);



	/***
	 * 根据用户ID获取数据权限机构编码列表
	 * @param userId 用户ID
	 * @return  机构编码列表
	 */
	List<Police>  findDataPoliceForUserID(Long userId);

    /**
     * 获取当前最小级机构
     * @param areaCode
     * @param businessTypeCode
     * @param sponsorlicenseType
     * @return 最小级的机构
     */
    Police getApprovalMinOrgTypePolice(String areaCode,String businessTypeCode,String sponsorlicenseType);

	/***
	 * 查询机构树型结构
	 * @param policeSearchDto 参数
	 * @return
	 */
	List<TreeView> findAllForTreeViewPower(PoliceSearchDto policeSearchDto);
    /***
     * 根据类型获取机构列表
     * @param type
     * @return
     */
    List<Police> findByType( String type);
}
