package com.bcxin.ars.service;

import com.bcxin.ars.dto.PerBlackListDto;
import com.bcxin.ars.dto.page.PersonBlackListDto;
import com.bcxin.ars.dto.page.PersonBlackListPageSearchDto;
import com.bcxin.ars.model.PersonBlackList;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;

import java.util.Date;
import java.util.List;

/**
 * 行业黑名单service接口
 * @author linqinglin
 * @date 2019/05/13 0013 9:54
 */
public interface PersonBlackListService {

    /**
     * 根据主键id查询
     * @param id
     * @return
     */
    PersonBlackList findById(Long id);

    /**
     * 新增修改
     * @param detail
     */
    void update(PersonBlackList detail);

    /**
     * 删除
     * @param detail
     */
    void delete(PersonBlackList detail);

    /***
     * 公安用户管理查询
     * @param dto 查询条件参数
     * @param ajaxPageResponse 返回数据对象
     * @return 查询列表
     */
    List<PersonBlackList> searchForPage(PersonBlackListPageSearchDto dto, AjaxPageResponse<PersonBlackListDto> ajaxPageResponse);
    /***
     * 根据id批量查询
     * @param list
     */
    List<PersonBlackList> findByBatchId(List<PersonBlackList> list);

    /**
     * 批量保存
     * @param list
     */
    void saveBatch(List<PersonBlackList> list);

    /**
     * 定时抽取行业黑名单
     * @param startTime
     * @param endTime
     * @return
     */
    List<PerBlackListDto> findBlackPersonList(Date startTime, Date endTime);
}
