package com.bcxin.ars.service;

import java.util.List;
import java.util.Map;

import com.bcxin.ars.model.Native;

/**
 * 区域服务类
 * @author 15725
 *
 */
public interface NativeService {
	
	/**
	 * 根据指定编号获取区域信息
	 * @param code
	 * @return
	 */
	Native findByCode(Long code);
	
	/**
	 * 获取省数据
	 * @return
	 */
	List<Native> findProvince();
	
	/**
	 * 根据编号获取其下级区域
	 * @param code
	 * @return
	 */
	List<Native> findByParentCode(Long code);
	
	/**
	 * 获取全部省市区
	 * @return
	 */
	List<Native> findAll();
	
	/**
	 * 获取全部省市县数据
	 * @return
	 */
	Map<Long, List<Native>> findMap();
	
}
