package com.bcxin.ars.service;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.model.CyAssociation;
import com.bcxin.ars.dto.page.CyAssociationPageSearchDto;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;

import java.util.List;

/**
 * 保安协会Service接口
 *
 * @author linqinglin
 * @Date 2020-08-05 22:14:24
 */
public interface CyAssociationService {

    /****
     * 删除
     * @param cyAssociation
     * @return
     */
    int delete(CyAssociation cyAssociation);

    /****
     * 保存
     * @param cyAssociation
     * @return
     */
    int save(CyAssociation cyAssociation);

    /****
     * 选择性修改
     * @param cyAssociation
     * @return
     */
    void updateSelective(CyAssociation cyAssociation);

    /****
     * 主键查询
     * @param id
     * @return
     */
    CyAssociation findById(Long id);

    /**
     * 分页查询
     * @param searchDto
     * @param page
     * @return
     */
    void searchForPage(CyAssociationPageSearchDto searchDto, AjaxPageResponse<CyAssociation> page);

    /**
     * 外导内查询
     * @param searchDto
     * @return
     */
    List<CyAssociation> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

    /**
     * 内导外查询
     * @param startDate
     * @return
     */
    List<CyAssociation> findDSOutList(String startDate);

    /**
     * 批量保存
     * @param list
     */
    void importBatch(List<CyAssociation> list);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<CyAssociation> findByBatchId(List<CyAssociation> list);
}
