package com.bcxin.ars.service;

import com.bcxin.ars.dto.page.ConfigPageSearchDto;
import com.bcxin.ars.model.Config;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;

import java.util.List;

/**
 * 配置服务类
 * @author Ethan
 */
public interface ConfigService {

	/**
	 * 获取全部配置
	 * @return
	 */
	List<Config> findAll();
	
	/**
	 * 根据Key获取配置
	 * @param key
	 * @return
	 */
	Config findByKey(String key);

	/**
	 * 根据Key获取配置（优先从缓存读取）
	 * @param key
	 * @return
	 */
	Config getConfigByKey(String key);

    String getValueByKey(String key);

    Config findByKeyAndName(String key, String name);


	/***
	 * 更新
	 * @param config
	 * @return
	 */
	void update(Config config);

	/**
	 * 根据key模糊查询
	 * @param key
	 * @return
	 */
	List<Config> findByLikeKey(String key);

	/**
	 *获取同步到外网的数据列表
	 * @param startDate 开始日期
	 */
	List<Config> findDSOutList(String startDate);

	/**
	 * @Decription:批量保存修改
	 * @param list
	 * @return
	 */
	void importBatch(List<Config> list);

	/****
	 * 删除
	 * @param config
	 * @return
	 */
	void delete(Config config);

	/****
	 * 保存
	 * @param config
	 * @return
	 */
	void save(Config config);

	/****
	 * 主键查询
	 * @param id
	 * @return
	 */
	Config findById(Long id);

	/**
	 * 分页查询
	 * @param searchDto
	 * @param page
	 * @return
	 */
	void searchForPage(ConfigPageSearchDto searchDto, AjaxPageResponse<Config> page);

	/****
	 * 启用
	 * @param config
	 * @return
	 */
	void use(Config config);
}
