package com.bcxin.ars.service;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.model.CommonComplaint;
import com.bcxin.ars.dto.page.CommonComplaintPageSearchDto;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 市民意见建议Service接口
 *
 * @author linqinglin
 * @Date 2020-08-07 10:39:15
 */
public interface CommonComplaintService {

	/****
	 * 删除
	 * @param commonComplaint
	 * @return
	 */
	int delete(CommonComplaint commonComplaint);

	/****
	 * 保存
	 * @param commonComplaint
	 * @return
	 */
	int save(CommonComplaint commonComplaint);

	/****
	 * 选择性修改
	 * @param commonComplaint
	 * @return
	 */
	void updateSelective(CommonComplaint commonComplaint);

	/****
	 * 主键查询
	 * @param id
	 * @return
	 */
	CommonComplaint findById(Long id);

	/**
	 * 分页查询
	 * @param searchDto
	 * @param page
	 * @return
	 */
	void searchForPage(CommonComplaintPageSearchDto searchDto, AjaxPageResponse<CommonComplaint> page);

	/**
	 * 外导内查询
	 * @param searchDto
	 * @return
	 */
	List<CommonComplaint> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

	/**
	 * 内导外查询
	 * @param startDate
	 * @return
	 */
	List<CommonComplaint> findDSOutList(String startDate);

	/**
	 * 批量保存
	 * @param list
	 */
	void importBatch(List<CommonComplaint> list);

	/**
	 * 批量查询
	 * @param list
	 * @return
	 */
	List<CommonComplaint> findByBatchId(List<CommonComplaint> list);
}
