package com.bcxin.ars.hbase.impl;

import com.alibaba.fastjson.JSONArray;
import com.bcxin.ars.hbase.HBaseService;
import com.bcxin.ars.hbase.util.CipherDESUtil;
import com.bcxin.ars.hbase.util.Constants;
import com.bcxin.ars.hbase.util.Encodes;
import com.bcxin.ars.model.task.TaskFeedback;
import com.bcxin.ars.model.task.TaskTrack;
import com.bcxin.ars.service.task.TaskFeedbackService;
import com.bcxin.ars.util.DateUtil;
import com.google.common.io.Files;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.*;
import org.apache.hadoop.hbase.util.Bytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.hadoop.hbase.HbaseTemplate;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.io.*;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * Created by lenovo on 2017/6/1.
 */
@Service
public class HBaseServiceImpl implements HBaseService {
    private static final Logger logger = LoggerFactory.getLogger(HBaseServiceImpl.class);
    /***
     * 文件名
     */
    public static String filename;
    /**
     * 字符串长度
     */
    public static final int strleng = 20;
    @Resource(name="htemplate")
    private HbaseTemplate hbaseTemplate;
    @Value("${hbase-folder}")
    private String hbaseFolder;

    private Connection hconnection = null;
    @Autowired
    private TaskFeedbackService feedbackService;
    public  HBaseServiceImpl(){
    }

    public HbaseTemplate getHbaseTemplate() {
        return hbaseTemplate;
    }

    public void setHbaseTemplate(HbaseTemplate hbaseTemplate) {
        try{
            hconnection = ConnectionFactory.createConnection(hbaseTemplate.getConfiguration());
        }catch (Exception e){
            logger.error(e.getMessage(),e);
        }
        this.hbaseTemplate = hbaseTemplate;
    }
    public static String addZeroForNum(String str, int strLength) {
        int strLen = str.length();
        if (strLen < strLength) {
            while (strLen < strLength) {
                StringBuffer sb = new StringBuffer();
                sb.append("0").append(str);// 左补0
                str = sb.toString();
                strLen = str.length();
            }
        }

        return str;
    }

    public static  void main(String[] arg ) throws ParseException {

     //   System.out.println( new StringBuilder("112313").reverse().toString());
        /*java.text.DateFormat format2 = new java.text.SimpleDateFormat("yyyyMMddHHmmss");
        SimpleDateFormat sdf2 =   new SimpleDateFormat( "yyyy-MM-dd HH:mm:ss" );
        Date d2 = sdf2.parse("2016-09-01"+" 23:59:59");
       String endtime = format2.format(d2);;
        System.out.println(endtime);*/
       new HBaseServiceImpl().read();
    }

    public void read(){
        String filePath = hbaseFolder;	//路径
        File fhbase = new File(filePath);
        if (!fhbase.exists()) {
            try {
                fhbase.createNewFile();
            } catch (IOException e) {
                logger.error(e.getMessage(),e);
            }
        }

        File fhbases[] = fhbase.listFiles();

        for (int i = 0; i < fhbases.length; i++) {
            File fbase = fhbases[i];
            if(fbase.getName().contains(".txt")){
                try {
                    BufferedReader br = new BufferedReader(new FileReader(fbase));
                    StringBuffer content = new StringBuffer();
                    //获取文件内容
                    String lineTxt = null;
                    while((lineTxt = br.readLine()) != null){//使用readLine方法，一次读一行
                        content.append(lineTxt);
                        String jsonStr = new String(CipherDESUtil.decrypt(Encodes.decodeHex(lineTxt.toString()), Constants.APPROVAL_KEY));
                        TaskTrack track = JSONArray.parseObject(jsonStr, TaskTrack.class);
                    }
                    br.close();
                } catch (Exception  e) {
                    logger.error(e.getMessage(),e);
                    continue;
                }
            }
        }
    }

    /**
     * 获取文件大小，以MB为单位
     * @param file
     * @return
     */
    public static double GetFileSize(File file) {
        double size = 0;
        if (file.exists() && file.isFile()) {
            long fileS = file.length();
            DecimalFormat df = new DecimalFormat("#.00");
            size = (double) fileS / 1048576;
        }
        return size;
    }
    /**
     * 文件末尾追加文件：使用FileWriter    
     */
    public static void appendMethodB(String fullFilePath, String content) {
        try {
            RandomAccessFile rf = new RandomAccessFile(fullFilePath, "rw");
            long fileLength = rf.length();
            // 将本件指针移到文本末尾
            rf.seek(fileLength);
            // 文本文件追加文本，换行符
            rf.writeBytes(content + "\r\n");
            rf.close();
            //打开一个写文件器，构造函数中的第二个参数true表示以追加形式写文件
            //      FileWriter writer = new FileWriter(fullFilePath, true);
            //   writer.write(content+"\r\n");
            //     writer.write(content+System.getProperty("line.separator"));
            //     writer.close();
        } catch (IOException e) {
            logger.error(e.getMessage(),e);
        } finally {
        }

    }
    //生成文件方法
    private void writeTxtFile(String readStr,String filename){
        try{
            //公安端
            String nowStr = DateUtil.getCurrentDate();
            String filePath = hbaseFolder + nowStr+"/";	//路径
            String fileType = ".txt";
            File file = new File(filePath);
            if (!file.exists()) {
                file.mkdirs();
                logger.debug("文件夹已创建");
            }
            String fullFilePath = filePath+filename+fileType;
            //文件处理：写入文件
            File newFile = new File(fullFilePath);;
            //如果文件大小大于300M，则重新生成一个文件
           // if(GetFileSize(newFile)>300){
                //复制
                //copyDir(temphbaseFolder+filename+fileType,hbaseFolder+filename+fileType);

                filename=new java.text.SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()).substring(0,19).replaceAll(" ","-").replaceAll(":","-");
                fullFilePath = filePath+filename+fileType;
                newFile = new File(fullFilePath);
            //}
            //如果存在，则追加,不存在则新建
            if(newFile.exists()){
                appendMethodB(fullFilePath,readStr);
            }else{
                Files.write((readStr+System.getProperty("line.separator")).getBytes(), newFile);
            }
        }catch(Exception e){
            logger.error(e.getMessage(),e);
        }
    }
    @Override
    public void save(TaskTrack track) throws Exception {
        /*hbaseTemplate.execute("track",new TableCallback<Object>() {
            @Override
            public Object doInTable(HTableInterface table) throws Throwable {
                java.text.DateFormat format2 = new java.text.SimpleDateFormat("yyyyMMddHHmmss");
                String s2 = format2.format(new Date());
                String rowkey = addZeroForNum(track.getTaskFeedbackId().toString(), 20) + s2;
                Put p = new Put(Bytes.toBytes(rowkey.toString()));
                //经度 纬度
                p.addColumn(Bytes.toBytes("data"), Bytes.toBytes("latitude"), Bytes.toBytes(track.getLatitude()));
                p.addColumn(Bytes.toBytes("data"), Bytes.toBytes("longitude"), Bytes.toBytes(track.getLongitude()));
                //当前日期
                java.text.DateFormat format1 = new java.text.SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
                String s = format1.format(new Date());
                p.addColumn(Bytes.toBytes("data"), Bytes.toBytes("updateTime"), Bytes.toBytes(s));
                table.put(p);
                return null;
            }
        });*/
       /* Long feedbackId = null;
        TaskFeedback taskFeedback = feedbackService.findByIdRand();
        if(taskFeedback!=null){
            feedbackId =taskFeedback.getId();

        }*/
            //连接
            if (hconnection == null) {
                hconnection = ConnectionFactory.createConnection(hbaseTemplate.getConfiguration());
            }
            Table table = null;
            try {
                TableName tableName = TableName.valueOf("track");
                table =hconnection.getTable(tableName);
                //当前时间
                Date nowdate=  new Date();
                //8位时间戳
                java.text.DateFormat format2 = new java.text.SimpleDateFormat("yyyyMMddHHmmss");
                String s2 = format2.format(nowdate);
                //主键  20位taskFeedbackId+12位时间戳
                String rowkey = addZeroForNum(new StringBuilder(track.getTaskFeedbackId().toString()).reverse().toString(),strleng)+s2;
                Put p = new Put(Bytes.toBytes(rowkey.toString()));
                //经度 纬度
                p.addColumn(Bytes.toBytes("data"), Bytes.toBytes("latitude"), Bytes.toBytes(track.getLatitude()));
                p.addColumn(Bytes.toBytes("data"), Bytes.toBytes("longitude"), Bytes.toBytes(track.getLongitude()));
                //当前日期
                java.text.DateFormat format1 = new java.text.SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String s = format1.format(nowdate);
                p.addColumn(Bytes.toBytes("data"), Bytes.toBytes("updateTime"), Bytes.toBytes(s));
                //当前时间
                track.setUpdateTime(nowdate);
                table.put(p);

                if(filename==null){
                    filename=new java.text.SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()).substring(0,19).replaceAll(" ","-").replaceAll(":","-");
                }
                //存到2017-07-03   20:16:23.txt,  判断文件大小是否大于300M
                if( track != null){
                    try {
                        String trackStr = JSONArray.toJSONString(track);
                        //System.out.println(trackStr);
                        String content = CipherDESUtil.parseByte2HexStr(CipherDESUtil.encrypt(trackStr.getBytes(), Constants.APPROVAL_KEY));
                        writeTxtFile(content,filename);
                    }catch(Exception e){
                        logger.error(e.getMessage(),e);
                    }
                }

            } catch (IOException e) {
                logger.error(e.getMessage(),e);
                throw new IOException(e);
            } finally {
                if (table != null) {
                    try {
                        table.close();
                    } catch (IOException e) {
                        logger.error(e.getMessage(),e);
                        throw new IOException(e);
                    }
                }
            }
        }

    public void saveTrack(TaskTrack track) throws Exception {
        /*hbaseTemplate.execute("track",new TableCallback<Object>() {
            @Override
            public Object doInTable(HTableInterface table) throws Throwable {
                java.text.DateFormat format2 = new java.text.SimpleDateFormat("yyyyMMddHHmmss");
                String s2 = format2.format(new Date());
                String rowkey = addZeroForNum(track.getTaskFeedbackId().toString(), 20) + s2;
                Put p = new Put(Bytes.toBytes(rowkey.toString()));
                //经度 纬度
                p.addColumn(Bytes.toBytes("data"), Bytes.toBytes("latitude"), Bytes.toBytes(track.getLatitude()));
                p.addColumn(Bytes.toBytes("data"), Bytes.toBytes("longitude"), Bytes.toBytes(track.getLongitude()));
                //当前日期
                java.text.DateFormat format1 = new java.text.SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
                String s = format1.format(new Date());
                p.addColumn(Bytes.toBytes("data"), Bytes.toBytes("updateTime"), Bytes.toBytes(s));
                table.put(p);
                return null;
            }
        });*/
        //连接
        if (hconnection == null) {
            hconnection = ConnectionFactory.createConnection(hbaseTemplate.getConfiguration());
        }
        Table table = null;
        try {
            TableName tableName = TableName.valueOf("track");
            table =hconnection.getTable(tableName);
            //当前时间
            Date nowdate=  new Date();
            //8位时间戳
            java.text.DateFormat format2 = new java.text.SimpleDateFormat("yyyyMMddHHmmss");
            String s2 = format2.format(nowdate);
            //主键  20位taskFeedbackId+12位时间戳
            String rowkey = addZeroForNum(new StringBuilder(track.getTaskFeedbackId().toString()).reverse().toString(),strleng)+s2;
            Put p = new Put(Bytes.toBytes(rowkey.toString()));
            //经度 纬度
            p.addColumn(Bytes.toBytes("data"), Bytes.toBytes("latitude"), Bytes.toBytes(track.getLatitude()));
            p.addColumn(Bytes.toBytes("data"), Bytes.toBytes("longitude"), Bytes.toBytes(track.getLongitude()));
            //当前日期
            java.text.DateFormat format1 = new java.text.SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String s = format1.format(track.getUpdateTime());
            p.addColumn(Bytes.toBytes("data"), Bytes.toBytes("updateTime"), Bytes.toBytes(s));
            table.put(p);
        } catch (IOException e) {
            logger.error(e.getMessage(),e);
            throw new IOException(e);
        } finally {
            if (table != null) {
                try {
                    table.close();
                } catch (IOException e) {
                    logger.error(e.getMessage(),e);
                    throw new IOException(e);
                }
            }
        }
    }
    @Override
    public List<TaskTrack> findByFeedbackId(Long feedbackId) throws Exception{
        //连接
        if (hconnection == null) {
            hconnection = ConnectionFactory.createConnection(hbaseTemplate.getConfiguration());
        }
        //如果没有任务ID
        TaskFeedback feedback =  feedbackService.findById(feedbackId);
        if(feedback==null){
            return null;
        }
        //过滤条件，按子任务ID查
        Scan scan = new Scan();
        java.text.DateFormat format2 = new java.text.SimpleDateFormat("yyyyMMddHHmmss");
        String starttime = format2.format(feedback.getStartTime());
        String endtime ="";
        if(feedback.getEndTime()!=null) {
            endtime = format2.format(feedback.getEndTime());
        }else{
            SimpleDateFormat sdf2 =   new SimpleDateFormat( "yyyy-MM-dd HH:mm:ss" );
            Date d2 = sdf2.parse(feedback.getTaskDate()+" 23:59:59");
            endtime = format2.format(d2);
        }
        //开始时间
        scan.setStartRow(Bytes.toBytes(addZeroForNum(new StringBuilder(feedbackId.toString()).reverse().toString(),strleng)+starttime));
        //结束时间
        scan.setStopRow(Bytes.toBytes(addZeroForNum(new StringBuilder(feedbackId.toString()).reverse().toString(),strleng)+endtime));
        Table table = null;
        ResultScanner rs = null;
        List<TaskTrack> list = new ArrayList<TaskTrack>();
        try {
            TableName tableName = TableName.valueOf("track");
            table =hconnection.getTable(tableName);
            rs = table.getScanner(scan);
            for(Result result : rs){
                TaskTrack track = new TaskTrack();
                //经度 纬度
                track.setLatitude(Bytes.toString(result.getValue(Bytes.toBytes("data"), Bytes.toBytes("latitude"))));
                track.setLongitude(Bytes.toString(result.getValue(Bytes.toBytes("data"), Bytes.toBytes("longitude"))));
                //更新日期
                SimpleDateFormat sdf =   new SimpleDateFormat( "yyyy-MM-dd HH:mm:ss" );
                String s =  Bytes.toString(result.getValue(Bytes.toBytes("data"), Bytes.toBytes("updateTime")));
                if(s!=null &&!"".equals(s)) {
                    Date d = sdf.parse(s);
                    track.setUpdateTime(d);
                    list.add(track);
                }
            }
        } catch (IOException e) {
            logger.error(e.getMessage(),e);
            throw new IOException(e);
        }finally{
            if(rs!=null) {
                rs.close();
            }
        }
        return list;
    }
    public TaskFeedbackService getFeedbackService() {
        return feedbackService;
    }
    public void setFeedbackService(TaskFeedbackService feedbackService) {
        this.feedbackService = feedbackService;
    }

    /***
     * 复制
     * @param oldPath
     * @param newPath
     * @throws IOException
     */
    public static void copyDir(String oldPath, String newPath) throws IOException {
        File file = new File(oldPath);
        String[] filePath = file.list();

        if (!(new File(newPath)).exists()) {
            (new File(newPath)).mkdir();
        }

        for (int i = 0; i < filePath.length; i++) {
            if ((new File(oldPath + File.separator + filePath[i])).isDirectory()) {
                copyDir(oldPath  + File.separator  + filePath[i], newPath  + File.separator + filePath[i]);
            }

            if (new File(oldPath  + File.separator + filePath[i]).isFile()) {
                File from = new File(oldPath + File.separator + filePath[i]);
                File to = new File(newPath + File.separator + filePath[i]);
                Files.copy(from, to);
            }
        }
    }
}
