package com.bcxin.rest.web.apis.controllers;
import cn.hutool.core.util.StrUtil;
import com.bcxin.Infrastructures.Pageable;
import com.bcxin.Infrastructures.components.CacheV2Provider;
import com.bcxin.Infrastructures.enums.CredentialType;
import com.bcxin.api.interfaces.identities.IdentityRpcProvider;
import com.bcxin.api.interfaces.identities.requests.BindWechatRequest;
import com.bcxin.api.interfaces.tenants.EmployeeRpcProvider;
import com.bcxin.api.interfaces.tenants.OrganizationRpcProvider;
import com.bcxin.api.interfaces.tenants.UserRpcProvider;
import com.bcxin.api.interfaces.tenants.criterias.OrganizationCriteria;
import com.bcxin.api.interfaces.tenants.requests.tenantUsers.*;
import com.bcxin.api.interfaces.tenants.responses.*;
import com.bcxin.rest.web.apis.responses.ApiDepartmentTreeGetResponse;
import com.bcxin.rest.web.apis.utils.CacheUtil;
import com.bcxin.rest.web.apis.utils.IPUtils;
import io.swagger.annotations.*;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 公共查询
 */
@Api("公共查询")
@RestController
@RequestMapping("/public")
public class PublicController extends ControllerAbstract {
    private final UserRpcProvider userRpcProvider;
    private final OrganizationRpcProvider organizationRpcProvider;

    public PublicController(UserRpcProvider userRpcProvider,
                            OrganizationRpcProvider organizationRpcProvider) {
        this.userRpcProvider = userRpcProvider;
        this.organizationRpcProvider = organizationRpcProvider;
    }


    /**
     * 北京监管外网资格证查询
     * @param queryRequest
     * @return
     */
    @PostMapping("/qualification-credentials")
    public ResponseEntity<Collection<QualificationCredentialResponse>> getQualificationCredentials(
            @RequestBody QueryCredentialRequest queryRequest) {
        /**
         * todo: 添加鉴权操作
         */
        if (StringUtils.isEmpty(queryRequest.getAreaCode())) {
            return this.ok(new ArrayList<>());
        }
        if (queryRequest.getCredentialType() == null) {
            queryRequest.setCredentialType(CredentialType.QualificationCer);
        }

        if (StringUtils.isEmpty(queryRequest.getIdnum())) {
            return this.ok(new ArrayList<>());
        }

        List<QualificationCredentialResponse> response =
                this.userRpcProvider.getQualificationCredentials(queryRequest);

        return this.ok(response);
    }

    /**
     * 北京监管外网服务公司查询
     * @param queryRequest
     * @return
     */
    @PostMapping("/company-info")
    public ResponseEntity companyInfo(@RequestBody OrganizationCriteria queryRequest) {
        Pageable<CompanyCredentialResponse> response = this.organizationRpcProvider.getCompanies(queryRequest);
        return this.ok(response);
    }


}
