/*
 Navicat Premium Data Transfer

 Source Server         : localhost
 Source Server Type    : MySQL
 Source Server Version : 50740
 Source Host           : localhost:3306
 Source Schema         : obpm2_security

 Target Server Type    : MySQL
 Target Server Version : 50740
 File Encoding         : 65001

 Date: 09/05/2023 20:01:03
*/

SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for tenant_organization_requests
-- ----------------------------
DROP TABLE IF EXISTS `tenant_organization_requests`;
CREATE TABLE `tenant_organization_requests`  (
  `id` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `industry_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '行业类型',
  `institutional_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '机构类型',
  `content` longtext CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '内网许可审批的请求内容',
  `status` tinyint(11) NULL DEFAULT NULL COMMENT '1通过/0未通过',
  `number` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '系统生成的注册编码(系统通过该地址获取注册填充的内容)',
  `created_time` timestamp(0) NULL DEFAULT NULL,
  `referenceId` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '注册成功之后引用tenant_organizations.id',
  `industry_ode` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `reference_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of tenant_organization_requests
-- ----------------------------
INSERT INTO `tenant_organization_requests` VALUES ('0vem2Ezi8WTmaYiF1K6--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京市昌平区南邵镇官高村股份经济合作社\",\n\"companyType\":\"6\",\n\"legalName\":\" 杨加华\",\n\"legalCardNumber\":\"11022119620214501X\",\n\"legalPhone\":\" 13910393730\",\n\"chargeName\":\" 历迎春\",\n\"chargePhone\":\" 18510186086\",\n\"chargeCardNumber\":\" 110221197501236629\",\n\"creditCode\":\" N2110114102701369G\",\n\"recordPeronNum\":\" 6.0000000000\",\n\"address\":\"北京市昌平区南邵镇官高村北\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队/昌平分局\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('1o8qshi34rQG12tXxTZ--__0TXoiEr3uNf7rO0sduB', NULL, NULL, '{\"companyName\":\"中海国际保安服务（北京）有限公司\",\r\n\"companyType\":\"4\",\r\n\"phone\":\" 13603348801\",\r\n\"legalName\":\" 苑光辉\",\r\n\"legalCardNumber\":\"130802197608065011\",\r\n\"legalPhone\":\" 13603348801\",\r\n\"registeredCapital\":\"0E-10\",\r\n\"businessScope\":\"01;02;03\",\r\n\"address\":\"北京市大兴区金科巷2号1号楼2层204A室\",\r\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队//大兴分局\"\r\n}', 1, '1o8qshi34rQG12tXxTZ--__0TXoiEr3uNf7rO0sduB', '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('1wmpD8jeUinoDYekELj--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京众康物业管理有限公司\",\n\"companyType\":\"8\",\n\"legalName\":\" 蒋三兴\",\n\"legalCardNumber\":\"342221197711077034\",\n\"legalPhone\":\" 18612464848\",\n\"chargeName\":\" 范翠茹\",\n\"chargePhone\":\" 13161574971\",\n\"chargeCardNumber\":\" 230103195703211323\",\n\"creditCode\":\" 91110108MA01LEDB3B\",\n\"recordPeronNum\":\" 3.0000000000\",\n\"address\":\"北京市延庆区中关村延庆园长城路2号楼Ｃ座241室\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队/海淀分局\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('25xY9ZkJY1C8VIC3JZX--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京风华国乐物业管理有限公司\",\n\"companyType\":\"4\",\n\"legalName\":\" 张永升\",\n\"legalCardNumber\":\"230833197406050370\",\n\"legalPhone\":\" 15811498908\",\n\"chargeName\":\" 魏军\",\n\"chargePhone\":\" 13911484555\",\n\"chargeCardNumber\":\" 230307197208094014\",\n\"creditCode\":\" 91110115MA018DT959\",\n\"recordPeronNum\":\" 6.0000000000\",\n\"address\":\"北京市大兴区兴华园小区11号楼\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队/大兴分局/清源路派出所\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('2hmh8xYcMZu2g2yUkfd--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京大唐物业管理有限公司\",\n\"companyType\":\"3\",\n\"legalName\":\" 姜杰松\",\n\"legalCardNumber\":\"379008197710017814\",\n\"legalPhone\":\" 13910609175\",\n\"chargeName\":\" 姜杰松\",\n\"chargePhone\":\" 13910609175\",\n\"chargeCardNumber\":\" 379008197710017814\",\n\"creditCode\":\" 91110108700224531T\",\n\"recordPeronNum\":\" 17.0000000000\",\n\"address\":\"北京市海淀区学院路40号\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队/海淀分局/花园路派出所\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('3ahZO2jMD4KjwW56AMz--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京科住物业管理有限公司\",\n\"companyType\":\"3\",\n\"legalName\":\" 邹立民\",\n\"legalCardNumber\":\"110224197506132617\",\n\"legalPhone\":\" 13552253253\",\n\"chargeName\":\" 李国英\",\n\"chargePhone\":\" 13581580428\",\n\"chargeCardNumber\":\" 132201199006131431\",\n\"creditCode\":\" 911101081021188353\",\n\"recordPeronNum\":\" 22.0000000000\",\n\"address\":\"北京市海淀区中关村南三街15号综合楼9层907\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队/海淀分局/上地派出所\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('4R5nN1IHqbLiy7yZi3H--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京铂颐都物业管理有限公司\",\n\"companyType\":\"8\",\n\"legalName\":\" 洪昌贵\",\n\"legalCardNumber\":\"420124194801082337\",\n\"legalPhone\":\" 13521632668\",\n\"chargeName\":\" 洪昌贵\",\n\"chargePhone\":\" 13521632668\",\n\"chargeCardNumber\":\" 420124194801082337\",\n\"creditCode\":\" 91110400MA02B12L6A\",\n\"recordPeronNum\":\" 11.0000000000\",\n\"address\":\"北京市北京经济技术开发区荣华北路2号院10号楼10层1004\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队/大兴分局\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('4usdTjtYJHjIU3El7v9--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京国联晟丰物业管理有限公司\",\n\"companyType\":\"8\",\n\"legalName\":\" 唐元梅\",\n\"legalCardNumber\":\"342626197911052708\",\n\"legalPhone\":\" 13366638318\",\n\"chargeName\":\" 石仁龙\",\n\"chargePhone\":\" 13671335496\",\n\"chargeCardNumber\":\" 342626199505141413\",\n\"creditCode\":\" 91110112397365541X\",\n\"recordPeronNum\":\" 4.0000000000\",\n\"address\":\"北京市通州区经济开发区东区靓丽三街9号-49\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队/通州分局\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('4ylEZ0Kxpm0vyAz40Pk--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京天鸿宝地物业管理经营有限公司\",\n\"companyType\":\"8\",\n\"legalName\":\" 董贤钧\",\n\"legalCardNumber\":\"110102195206282338\",\n\"legalPhone\":\" 13701210800\",\n\"chargeName\":\" 董希\",\n\"chargePhone\":\" 13810951235\",\n\"chargeCardNumber\":\" 110221198308182424\",\n\"creditCode\":\" 91110108101140088B\",\n\"recordPeronNum\":\" 7.0000000000\",\n\"address\":\"北京市海淀区恩济花园13号楼五层\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队/昌平分局\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('5eLgF7zdnanW3mEC8bc--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京极简一站式魏公村口腔门诊部有限公司\",\n\"companyType\":\"9\",\n\"legalName\":\" 余冰洁\",\n\"legalCardNumber\":\"513101199008236022\",\n\"legalPhone\":\" 18031555670\",\n\"chargeName\":\" 张迈\",\n\"chargePhone\":\" 18031555670\",\n\"chargeCardNumber\":\" 130322199202073529\",\n\"creditCode\":\" 91110108MA01Y06E68\",\n\"recordPeronNum\":\" 2.0000000000\",\n\"address\":\"北京市海淀区紫竹院街道魏公村5号一层101-107号，二层201-207号，三层301-305号\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队/海淀分局/海淀派出所\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('5TXE6UtJ5EId7J70j0y--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京市昌平区育德幼儿园\",\n\"companyType\":\"4\",\n\"legalName\":\" 张明明\",\n\"legalCardNumber\":\"152221199603221629\",\n\"legalPhone\":\" 15811319025\",\n\"chargeName\":\" 宝海\",\n\"chargePhone\":\" 13366751318\",\n\"chargeCardNumber\":\" 152222198102196316\",\n\"creditCode\":\" 52110114MJ03523479\",\n\"recordPeronNum\":\" 6.0000000000\",\n\"address\":\"北京市昌平区回龙观街道新康园小区内\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队/昌平分局\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('65QaYbyL8P6lV8puocj--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京云水遥山居餐饮有限公司\",\n\"companyType\":\"4\",\n\"legalName\":\" 余盛翰\",\n\"legalCardNumber\":\"320922197812017312\",\n\"legalPhone\":\" 18600688899\",\n\"chargeName\":\" 袁立明\",\n\"chargePhone\":\" 13843918884\",\n\"chargeCardNumber\":\" 220602198501260015\",\n\"creditCode\":\" 91110114MA00FFX85W\",\n\"recordPeronNum\":\" 2.0000000000\",\n\"address\":\"北京市昌平区十三陵镇碓臼峪村70号\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队//昌平分局\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('67pyRDzQ4n3jN8lvhYQ--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京宝旺印务有限公司\",\n\"companyType\":\"8\",\n\"legalName\":\" 薛尚州\",\n\"legalCardNumber\":\"33032719891204185X\",\n\"legalPhone\":\" 18611117961\",\n\"chargeName\":\" 邓开荣\",\n\"chargePhone\":\" 13911680147\",\n\"chargeCardNumber\":\" 230103197002222424\",\n\"creditCode\":\" 911101157020407346\",\n\"recordPeronNum\":\" 14.0000000000\",\n\"address\":\"北京市顺义区北务西路36号院1号楼\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队/顺义分局/北务派出所\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('879pDcq0uMqv1iUZezK--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京市昌平区文德幼儿园\",\n\"companyType\":\"9\",\n\"legalName\":\" 许新悦\",\n\"legalCardNumber\":\"150102197002242541\",\n\"legalPhone\":\" 18611172277\",\n\"chargeName\":\" 龚敏芳\",\n\"chargePhone\":\" 13436597976\",\n\"chargeCardNumber\":\" 350524198310050041\",\n\"creditCode\":\" 52110114306493098W\",\n\"recordPeronNum\":\" 7.0000000000\",\n\"address\":\"北京市昌平区回龙观瑞旗家园7号楼\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队/昌平分局/回龙观派出所\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('8DFjmJIWA11TtBevY7z--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京皇城股骨头坏死专科医院\",\n\"companyType\":\"6\",\n\"legalName\":\" 黄辉\",\n\"legalCardNumber\":\"220203195903222143\",\n\"legalPhone\":\" 13716476262\",\n\"chargeName\":\" 陈泓池\",\n\"chargePhone\":\" 18611787450\",\n\"chargeCardNumber\":\" 220204198502210010\",\n\"creditCode\":\" 911101147400937839\",\n\"recordPeronNum\":\" 7.0000000000\",\n\"address\":\"北京市昌平区西关路27号\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队/昌平分局/昌平派出所\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('9pm6pZWWWpjpFxqbNBZ--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京华远福禄酒店管理有限公司\",\n\"companyType\":\"1\",\n\"legalName\":\" 彭世军\",\n\"legalCardNumber\":\"412932197007083612\",\n\"legalPhone\":\" 15001364890\",\n\"chargeName\":\" 顾燕京\",\n\"chargePhone\":\" 13426120980\",\n\"chargeCardNumber\":\" 110101196604171535\",\n\"creditCode\":\" 911101140984898435\",\n\"recordPeronNum\":\" 1.0000000000\",\n\"address\":\"北京市昌平区回龙观建材城西路87号院4号楼\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队//昌平分局\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('a4Tu9PasOVJJTAowd7C--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京蓝海长青规划设计研究有限公司\",\n\"companyType\":\"4\",\n\"legalName\":\" 孔海梅\",\n\"legalCardNumber\":\"13042219780827062X\",\n\"legalPhone\":\" 15133069379\",\n\"chargeName\":\" 刘志强\",\n\"chargePhone\":\" 13911915920\",\n\"chargeCardNumber\":\" 110221197708057230\",\n\"creditCode\":\" 91110108MA006M9FXW\",\n\"recordPeronNum\":\" 5.0000000000\",\n\"address\":\"北京海淀区闵庄路42号院1号楼\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队/海淀分局\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('AaSjHYMmwvMZ7x7RHnr--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"上海明华智慧城市运营管理有限公司\",\n\"companyType\":\"8\",\n\"legalName\":\" 李涛\",\n\"legalCardNumber\":\"310106196610152436\",\n\"legalPhone\":\" 13341807000\",\n\"chargeName\":\" 史严\",\n\"chargePhone\":\" 13341806750\",\n\"chargeCardNumber\":\" 310107197301140010\",\n\"creditCode\":\" 91310101132324744R\",\n\"recordPeronNum\":\" 48.0000000000\",\n\"address\":\"上海市黄浦区延安东路110号底层\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队/海淀分局\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('aegjUteqrTR3rMx3DN3--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"新大正物业集团股份有限公司\",\n\"companyType\":\"7\",\n\"legalName\":\" 李茂顺\",\n\"legalCardNumber\":\"512901196612130418\",\n\"legalPhone\":\" 13693091025\",\n\"chargeName\":\" 张建伟\",\n\"chargePhone\":\" 13910595594\",\n\"chargeCardNumber\":\" 110106197710222419\",\n\"creditCode\":\" 915001032030285054\",\n\"recordPeronNum\":\" 27.0000000000\",\n\"address\":\"重庆市渝中区虎踞路78号1-1#\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队/海淀分局/西北旺派出所\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('ASclfBtr6jSqGnT8TKH--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京宾至嘉宁国际物业管理集团有限公司\",\n\"companyType\":\"8\",\n\"legalName\":\" 李林泽\",\n\"legalCardNumber\":\"371721200101170377\",\n\"legalPhone\":\" 15562087573\",\n\"chargeName\":\" 张植涛\",\n\"chargePhone\":\" 13717539618\",\n\"chargeCardNumber\":\" 13092119830605501X\",\n\"creditCode\":\" 91370100663524374T\",\n\"recordPeronNum\":\" 8.0000000000\",\n\"address\":\"北京市海淀区羊坊店路18号2幢13层 1331\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队/海淀分局\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('BlsdsvGt5Nl67EkIqNZ--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京怀柔大屯幼儿园\",\n\"companyType\":\"9\",\n\"legalName\":\" 李素芸\",\n\"legalCardNumber\":\"110227196112150323\",\n\"legalPhone\":\" 13716286010\",\n\"chargeName\":\" 尹鑫\",\n\"chargePhone\":\" 13810639263\",\n\"chargeCardNumber\":\" 110227198605230021\",\n\"creditCode\":\" 51220116339780915E\",\n\"recordPeronNum\":\" 2.0000000000\",\n\"address\":\"北京市怀柔区怀柔镇大屯村103号\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队/怀柔分局\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('BYY0sPwhdFLKBcum6xG--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京万科物业服务有限公司金域华府物业服务中心\",\n\"companyType\":\"8\",\n\"legalName\":\" 白宏毅\",\n\"legalCardNumber\":\"210622197408031612\",\n\"legalPhone\":\" 13840416456\",\n\"chargeName\":\" 孙国宗\",\n\"chargePhone\":\" 13633197205\",\n\"chargeCardNumber\":\" 130535198802081416\",\n\"creditCode\":\" 9110114057354993K\",\n\"recordPeronNum\":\" 11.0000000000\",\n\"address\":\"北京市昌平区龙域北街6号院1号楼104室\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队/昌平分局/回龙观派出所\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('cDr460n30LvGWGGZAeA--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京瑞赢酒店物业管理有限公司\",\n\"companyType\":\"4\",\n\"legalName\":\" 王龙贵\",\n\"legalCardNumber\":\"340102196207204013\",\n\"legalPhone\":\" 13910982023\",\n\"chargeName\":\" 杨建立\",\n\"chargePhone\":\" 13501033540\",\n\"chargeCardNumber\":\" 110227197708163613\",\n\"creditCode\":\" 911101027001397166\",\n\"recordPeronNum\":\" 9.0000000000\",\n\"address\":\"北京市朝阳区望京东园523号楼4层10502\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队/昌平分局\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('CIyImM1x4isrP4h6Sis--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"智达基业物业管理（北京）有限公司\",\n\"companyType\":\"8\",\n\"legalName\":\" 齐小红\",\n\"legalCardNumber\":\"650102197005255629\",\n\"legalPhone\":\" 17710851525\",\n\"chargeName\":\" 曹怀福\",\n\"chargePhone\":\" 18613361148\",\n\"chargeCardNumber\":\" 110107196602160013\",\n\"creditCode\":\" 91110107686917381G\",\n\"recordPeronNum\":\" 4.0000000000\",\n\"address\":\"石景山区八大处高科技园区西井路3号3号楼2234房间\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队/石景山分局\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('cJsp0uRKM6pEcMStHo6--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京外研社国际会议中心有限公司\",\n\"companyType\":\"3\",\n\"legalName\":\" 王勇\",\n\"legalCardNumber\":\"330106197106180073\",\n\"legalPhone\":\" 13520316807\",\n\"chargeName\":\" 蔡利君\",\n\"chargePhone\":\" 13701194460\",\n\"chargeCardNumber\":\" 320624196412303813\",\n\"creditCode\":\" 91110115772558848D\",\n\"recordPeronNum\":\" 7.0000000000\",\n\"address\":\"大兴区黄村镇芦城工业开发区创新路2号\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队/大兴分局/黄村镇派出所\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('cQJtjPslFAJXOmBOg6c--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京卡尔安娜家托育服务有限公司\",\n\"companyType\":\"8\",\n\"legalName\":\" 王瑞\",\n\"legalCardNumber\":\"510103197304152828\",\n\"legalPhone\":\" 13910028241\",\n\"chargeName\":\" 于泽天\",\n\"chargePhone\":\" 13141392004\",\n\"chargeCardNumber\":\" 230203198907151210\",\n\"creditCode\":\" 91110105MA04EA522J\",\n\"recordPeronNum\":\" 6.0000000000\",\n\"address\":\"北京市朝阳区崔各庄乡观唐东路5号浩华宫2号\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队/朝阳分局\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('cS9ob0d1tTeCWjrHNVG--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京民福桃源置业有限公司\",\n\"companyType\":\"8\",\n\"legalName\":\" 宫兴泽\",\n\"legalCardNumber\":\"131082197309098576\",\n\"legalPhone\":\" 18610864286\",\n\"chargeName\":\" 田君玲\",\n\"chargePhone\":\" 15910653397\",\n\"chargeCardNumber\":\" 132430197511126127\",\n\"creditCode\":\" 91110114670569976Q\",\n\"recordPeronNum\":\" 15.0000000000\",\n\"address\":\"北京市昌平区兴寿镇兴寿村村南\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队/昌平分局\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('DzDcVFXmGbUQ5bVcxez--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京乡村高尔夫俱乐部\",\n\"companyType\":\"6\",\n\"legalName\":\" 李永新\",\n\"legalCardNumber\":\"110222197106020330\",\n\"legalPhone\":\" 13601062858\",\n\"chargeName\":\" 李永新\",\n\"chargePhone\":\" 13161582915\",\n\"chargeCardNumber\":\" 110222197106020330\",\n\"creditCode\":\" 91110113102516745H\",\n\"recordPeronNum\":\" 13.0000000000\",\n\"address\":\"北京市顺义区马坡地区向阳闸南潮白河西侧\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队/顺义分局\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('Egt6ozN1jOxpO5M3HJt--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京市怀柔区二十一世纪实验幼儿园\",\n\"companyType\":\"4\",\n\"legalName\":\" 卓文涛\",\n\"legalCardNumber\":\"110108198511054931\",\n\"legalPhone\":\" 13683389783\",\n\"chargeName\":\" 孙自颖\",\n\"chargePhone\":\" 13120346779\",\n\"chargeCardNumber\":\" 110227198811272126\",\n\"creditCode\":\" 52110116MJ0378213U\",\n\"recordPeronNum\":\" 3.0000000000\",\n\"address\":\"北京市怀柔区雁栖镇顶秀美泉家园甲65号\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队/怀柔分局\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('eo0pqjc4cigQf2AVPcj--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"上海明华智慧城市运营管理有限公司\",\n\"companyType\":\"8\",\n\"legalName\":\" 李涛\",\n\"legalCardNumber\":\"310106196610152436\",\n\"legalPhone\":\" 13341807000\",\n\"chargeName\":\" 胡志平\",\n\"chargePhone\":\" 13341806838\",\n\"chargeCardNumber\":\" 310113196512035715\",\n\"creditCode\":\" 91310101132324744R\",\n\"recordPeronNum\":\" 34.0000000000\",\n\"address\":\"上海市黄浦区延安东路110号底层\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队/海淀分局\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('EqK3QBVqrVOz6KEvhGj--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京信卫物业管理有限公司\",\n\"companyType\":\"2\",\n\"legalName\":\" 徐建东\",\n\"legalCardNumber\":\"D489109(1)\",\n\"legalPhone\":\" 15011318551\",\n\"chargeName\":\" 石岩\",\n\"chargePhone\":\" 13611182583\",\n\"chargeCardNumber\":\" 110101197907091510\",\n\"creditCode\":\" 91110113671701529T\",\n\"recordPeronNum\":\" 39.0000000000\",\n\"address\":\"北京市顺义区空港街道丽来花园3区108栋101-01室\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队/顺义分局\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('eUl3lVplNJi6gnsoHGw--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京邢家坞新村物业有限公司\",\n\"companyType\":\"7\",\n\"legalName\":\" 王永\",\n\"legalCardNumber\":\"110225197105232015\",\n\"legalPhone\":\" 13811774682\",\n\"chargeName\":\" 龚蕾\",\n\"chargePhone\":\" 18210242240\",\n\"chargeCardNumber\":\" 110111198202040323\",\n\"creditCode\":\" 91110111MA01R8PY4G\",\n\"recordPeronNum\":\" 10.0000000000\",\n\"address\":\"北京市房山区良乡镇邢家坞村三区1号\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队/房山分局\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('fK6IlWlArsNNWzVmY8w--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京榕树之家教育咨询有限公司\",\n\"companyType\":\"8\",\n\"legalName\":\" 刘沛筝\",\n\"legalCardNumber\":\"412727199205200717\",\n\"legalPhone\":\" 13693370913\",\n\"chargeName\":\" 刘言明\",\n\"chargePhone\":\" 13716358283\",\n\"chargeCardNumber\":\" 412727195909050712\",\n\"creditCode\":\" 91110114589070326R\",\n\"recordPeronNum\":\" 1.0000000000\",\n\"address\":\"北京市昌平区东小口镇天通苑东苑三区2号楼2幢\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队/昌平分局\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('FoG4qNxpWI9KK1tjyD5--__Cf9cHA3xWKgzDNL80xE', NULL, NULL, '{\"companyName\":\"北京都豪鼎盛保安服务有限公司\",\n\"legalName\":\" 李志强\",\n\"legalCardNumber\":\"372301197603211414\",\n\"legalPhone\":\" 13522477555\",\n\"address\":\"北京市怀柔区迎宾中路36号二层\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队/怀柔分局/怀柔镇派出所\"\n}', 1, 'FoG4qNxpWI9KK1tjyD5--__Cf9cHA3xWKgzDNL80xE', '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('g43mW0BuL05vgnMkrF4--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京市朝阳区二十一世纪金茂府幼儿园\",\n\"companyType\":\"4\",\n\"legalName\":\" 卓文涛\",\n\"legalCardNumber\":\"110108198511054931\",\n\"legalPhone\":\" 13683389783\",\n\"chargeName\":\" 王坤\",\n\"chargePhone\":\" 13691591300\",\n\"chargeCardNumber\":\" 110103197211051900\",\n\"creditCode\":\" 52110105359003822C\",\n\"recordPeronNum\":\" 5.0000000000\",\n\"address\":\"北京市朝阳区茂兴东路9号院\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队/朝阳分局/双井派出所\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('h1RKC9DEcsQsxKvXBsf--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京初心教育咨询有限责任公司\",\n\"companyType\":\"8\",\n\"legalName\":\" 李敏\",\n\"legalCardNumber\":\"220182198206113543\",\n\"legalPhone\":\" 15901238621\",\n\"chargeName\":\" 闫利花\",\n\"chargePhone\":\" 17777814636\",\n\"chargeCardNumber\":\" 142321197807200066\",\n\"creditCode\":\" 91110114317925511P\",\n\"recordPeronNum\":\" 1.0000000000\",\n\"address\":\"北京市昌平区天通苑北二区甲3号\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队/昌平分局\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('h904QlODk8zvAHbsxCh--__Cf9cHA3xWKgzDNL80xE', NULL, NULL, '{\"companyName\":\"北京精武卫保安服务有限责任公司\",\n\"legalName\":\" 张长运\",\n\"legalCardNumber\":\"372901197704237851\",\n\"legalPhone\":\" 13911383195\",\n\"address\":\"北京市昌平区北七家镇西沙各庄村东北京山水人间快捷酒店(内)三层301\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队/怀柔分局\"\n}', 1, 'h904QlODk8zvAHbsxCh--__Cf9cHA3xWKgzDNL80xE', '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('hfO1NovvWF64cAkdIke--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京华磊众诚宾馆有限公司\",\n\"companyType\":\"9\",\n\"legalName\":\" 宋华磊\",\n\"legalCardNumber\":\"372402197608053218\",\n\"legalPhone\":\" 17701357888\",\n\"chargeName\":\" 张婷\",\n\"chargePhone\":\" 15011516042\",\n\"chargeCardNumber\":\" 140522199406021520\",\n\"creditCode\":\" 911101090612818894\",\n\"recordPeronNum\":\" 2.0000000000\",\n\"address\":\"北京市门头沟双峪路39-2\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队/门头沟分局\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('hM40KQaQNHPEyLAUG7J--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京市大兴区西红门镇金星庄村幼儿园\",\n\"companyType\":\"9\",\n\"legalName\":\" 于希萍\",\n\"legalCardNumber\":\"110224196307061823\",\n\"legalPhone\":\" 18518792315\",\n\"chargeName\":\" 王李丽\",\n\"chargePhone\":\" 18518792315\",\n\"chargeCardNumber\":\" 142636198802091425\",\n\"creditCode\":\" N21101151028703654\",\n\"recordPeronNum\":\" 6.0000000000\",\n\"address\":\"北京市大兴区西红门镇金星庄村委会南侧\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队/大兴分局\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('HNzzs4U22jX1TiIwpl6--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京希尔物公司有限管理\",\n\"companyType\":\"4\",\n\"legalName\":\" 韩伟\",\n\"legalCardNumber\":\"321284198311017417\",\n\"legalPhone\":\" 15810389280\",\n\"chargeName\":\" 韩伟\",\n\"chargePhone\":\" 15810389280\",\n\"chargeCardNumber\":\" 321284198311017417\",\n\"creditCode\":\" 91110228750134112Q\",\n\"recordPeronNum\":\" 8.0000000000\",\n\"address\":\"北京市海淀区中关村东路18号\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队/海淀分局\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('hP8ivCrzLIqtqOBJqsp--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京福瑞美林汽车销售服务有限公司\",\n\"companyType\":\"8\",\n\"legalName\":\" 王小明\",\n\"legalCardNumber\":\"110108196803140090\",\n\"legalPhone\":\" 18210968706\",\n\"chargeName\":\" 齐东波\",\n\"chargePhone\":\" 15330011783\",\n\"chargeCardNumber\":\" 130429198311303210\",\n\"creditCode\":\" 91110108076557366T\",\n\"recordPeronNum\":\" 3.0000000000\",\n\"address\":\"北京市海淀区西四环北路10号院1号楼1101\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队/海淀分局\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('IUexwFLm2e4scfwzl28--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京市恒慧通肉类食品有限公司\",\n\"companyType\":\"4\",\n\"legalName\":\" 鹿菊荣\",\n\"legalCardNumber\":\"410723195711210066\",\n\"legalPhone\":\" 18610233919\",\n\"chargeName\":\" 李文全\",\n\"chargePhone\":\" 18611359017\",\n\"chargeCardNumber\":\" 412728197302070034\",\n\"creditCode\":\" 91110113102544578B\",\n\"recordPeronNum\":\" 5.0000000000\",\n\"address\":\"北京市顺义区高丽营镇金马工业区23号\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队/顺义分局\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('J4rCFRh8GaBsRmbx48R--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京万客物业管理服务有限责任公司\",\n\"companyType\":\"8\",\n\"legalName\":\"  赵祥\",\n\"legalCardNumber\":\"140603197806132817\",\n\"legalPhone\":\" 13947226667\",\n\"chargeName\":\" 赵祥\",\n\"chargePhone\":\" 13947226667\",\n\"chargeCardNumber\":\" 140603197806132817\",\n\"creditCode\":\" 91110105MA0055E31F\",\n\"recordPeronNum\":\" 4.0000000000\",\n\"address\":\"北京市朝阳区八里庄北里129号院9号楼3单元9层901室\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队//朝阳分局\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('J9mz28buY3HF3TKvpNa--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京安恒泰物业管理有限公司\",\n\"companyType\":\"3\",\n\"legalName\":\" 王汝江\",\n\"legalCardNumber\":\"110102196211050114\",\n\"legalPhone\":\" 13801152625\",\n\"chargeName\":\" 明航\",\n\"chargePhone\":\" 18612567912\",\n\"chargeCardNumber\":\" 500382198609121490\",\n\"creditCode\":\" 91110102633701739D\",\n\"recordPeronNum\":\" 38.0000000000\",\n\"address\":\"北京市西城区三里河一区3号院2号楼1层\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队/西城分局/月坛派出所\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('JQ7p2Pgn22yoHSZyNuM--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京新华顺航物业管理有限公司\",\n\"companyType\":\"2\",\n\"legalName\":\" 杨晓晨\",\n\"legalCardNumber\":\"13073119860725003X\",\n\"legalPhone\":\" 18601116186\",\n\"chargeName\":\" 陈冠余\",\n\"chargePhone\":\" 13901253766\",\n\"chargeCardNumber\":\" 110227199201251218\",\n\"creditCode\":\" 91110113558548235N\",\n\"recordPeronNum\":\" 51.0000000000\",\n\"address\":\"北京市顺义区首都机场货运北路3号院7幢\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队/顺义分局\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('JsNz125tB4dH1QDuCFy--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京市门头沟区爱暮家老年养护中心\",\n\"companyType\":\"9\",\n\"legalName\":\" 姚雪\",\n\"legalCardNumber\":\"210824197410220424\",\n\"legalPhone\":\" 13501386788\",\n\"chargeName\":\" 赵云松\",\n\"chargePhone\":\" 13910385600\",\n\"chargeCardNumber\":\" 110107197309090049\",\n\"creditCode\":\" 52110109318072354K\",\n\"recordPeronNum\":\" 1.0000000000\",\n\"address\":\"北京市门头沟区圈外大街73号\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队/门头沟分局/东辛房派出所\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('JVqIMkhxhOyi9144wle--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"智达基业物业管理（北京）有限公司）\",\n\"companyType\":\"8\",\n\"legalName\":\" 齐小红\",\n\"legalCardNumber\":\"650102197005255629\",\n\"legalPhone\":\" 17710851525\",\n\"chargeName\":\" 曹怀福\",\n\"chargePhone\":\" 18613361148\",\n\"chargeCardNumber\":\" 110107196602160013\",\n\"creditCode\":\" 91110107686917381G\",\n\"recordPeronNum\":\" 8.0000000000\",\n\"address\":\"石景山区八大处高科技园区西区西井路3号3号楼2234房间\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队/石景山分局\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('Jy1iMcuwnljC486m6lS--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"智达基业物业管理（北京）有限公司\",\n\"companyType\":\"4\",\n\"legalName\":\" 齐小红\",\n\"legalCardNumber\":\"650102197005255629\",\n\"legalPhone\":\" 17710851525\",\n\"chargeName\":\" 刘莹\",\n\"chargePhone\":\" 18911281115\",\n\"chargeCardNumber\":\" 130324198804124213\",\n\"creditCode\":\" 91110107686917381G\",\n\"recordPeronNum\":\" 4.0000000000\",\n\"address\":\"北京市石景山区八大处高科技园区西井路3号3号楼2234房间\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队/石景山分局\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('JZ59DOaxDCjAD7Ux7eF--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"百泰生物药业有限公司\",\n\"companyType\":\"1\",\n\"legalName\":\" 白先宏\",\n\"legalCardNumber\":\"110108194812016818\",\n\"legalPhone\":\" 13436384346\",\n\"chargeName\":\" 刘林瑞\",\n\"chargePhone\":\" 18811301193\",\n\"chargeCardNumber\":\" 142303199508167610\",\n\"creditCode\":\" 91110302717747363U\",\n\"recordPeronNum\":\" 5.0000000000\",\n\"address\":\"北京市大兴区经济技术开发区荣京东街2号\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队/大兴分局\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('KB3XkvElHYxNs3ChE3z--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京市红达教育科技有限公司\",\n\"companyType\":\"4\",\n\"legalName\":\" 杨金昊\",\n\"legalCardNumber\":\"130823199204112513\",\n\"legalPhone\":\" 18600636211\",\n\"chargeName\":\" 杨金昊\",\n\"chargePhone\":\" 18600636211\",\n\"chargeCardNumber\":\" 130823199204112513\",\n\"creditCode\":\" 91110114MA00HH54U\",\n\"recordPeronNum\":\" 6.0000000000\",\n\"address\":\"北京市昌平区回龙观镇回龙观村南龙兴园中区11号\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队/昌平分局\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('LCtSS3TjKG2xUk4Ck2J--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"海南海航航空物业服务有限公司\",\n\"companyType\":\"4\",\n\"legalName\":\" 高建\",\n\"legalCardNumber\":\"230521198101121310\",\n\"legalPhone\":\" 18608945799\",\n\"chargeName\":\" 张占杰\",\n\"chargePhone\":\" 13739732333\",\n\"chargeCardNumber\":\" 132234198008113010\",\n\"creditCode\":\" 9146018MAA9A29787\",\n\"recordPeronNum\":\" 24.0000000000\",\n\"address\":\"海南省海口市美兰区国兴大道7号海航大厦21层\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队/顺义分局\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('lHpbXZN3gdjbQpa3R5W--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京市昌平区育龙幼儿园\",\n\"companyType\":\"4\",\n\"legalName\":\" 任颖辉\",\n\"legalCardNumber\":\"110108196511242781\",\n\"legalPhone\":\" 13910902512\",\n\"chargeName\":\" 任东辉\",\n\"chargePhone\":\" 18519752785\",\n\"chargeCardNumber\":\" 110108197309242715\",\n\"creditCode\":\" 521101147877570067\",\n\"recordPeronNum\":\" 6.0000000000\",\n\"address\":\"北京市昌平区回龙观龙跃苑一区17号\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队/昌平分局\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('lVOH51JTShh3ToYGph5--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京特兰蒂柯咪教育科技有限公司\",\n\"companyType\":\"2\",\n\"legalName\":\" 许龙\",\n\"legalCardNumber\":\"130722198706015717\",\n\"legalPhone\":\" 13371658880\",\n\"chargeName\":\" 	 孙晓茜\",\n\"chargePhone\":\" 18511107111\",\n\"chargeCardNumber\":\" 130722198805105726\",\n\"creditCode\":\" 91110108MA01NL713R\",\n\"recordPeronNum\":\" 2.0000000000\",\n\"address\":\"北京市海淀区杏石口路西山商业大厦C座二层202\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队/海淀分局\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('LYSVluojcSlCIvaIiA5--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京阳光迅驰投资管理有限公司\",\n\"companyType\":\"4\",\n\"legalName\":\" 刘文武\",\n\"legalCardNumber\":\"530111197211242094\",\n\"legalPhone\":\" 13114299478\",\n\"chargeName\":\" 王爱民\",\n\"chargePhone\":\" 13114299478\",\n\"chargeCardNumber\":\" 321028196806013417\",\n\"creditCode\":\" 91110108775462278N\",\n\"recordPeronNum\":\" 10.0000000000\",\n\"address\":\"北京市海淀区海淀北一街2号\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队/海淀分局\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('mume9vIH2rXoYKa89QO--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京华夏顺鑫物业管理有限公司\",\n\"companyType\":\"8\",\n\"legalName\":\" 周尧尧\",\n\"legalCardNumber\":\"340823199305017055\",\n\"legalPhone\":\" 18519378933\",\n\"chargeName\":\" 李超\",\n\"chargePhone\":\" 13381231208\",\n\"chargeCardNumber\":\" 372325198510054435\",\n\"creditCode\":\" 91110114MA01H0L0F\",\n\"recordPeronNum\":\" 4.0000000000\",\n\"address\":\"北京市昌平区沙河镇七里渠南村530号3号楼2层208室\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队/昌平分局\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('ntD6OBdcnYNOljZb5Yp--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京市朝阳区朝花幼儿园\",\n\"companyType\":\"9\",\n\"legalName\":\" 邹国祥\",\n\"legalCardNumber\":\"110108197106149318\",\n\"legalPhone\":\" 18519298588\",\n\"chargeName\":\" 李洋\",\n\"chargePhone\":\" 18519298085\",\n\"chargeCardNumber\":\" 11010619751111241X\",\n\"creditCode\":\" 121101050696421914\",\n\"recordPeronNum\":\" 180.0000000000\",\n\"address\":\"北京市朝阳区来广营乡清河营东路4号院1号楼\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队/朝阳分局\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('o8yFv4w47HQG45vdiP4--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京招商局物业管理有限公司\",\n\"companyType\":\"8\",\n\"legalName\":\" 王雨龙\",\n\"legalCardNumber\":\"110108196505306371\",\n\"legalPhone\":\" 13910996080\",\n\"chargeName\":\" 秦伟立\",\n\"chargePhone\":\" 13601362623\",\n\"chargeCardNumber\":\" 11010519730827111X\",\n\"creditCode\":\" 91110105700004838H\",\n\"recordPeronNum\":\" 18.0000000000\",\n\"address\":\"北京市朝阳区建国路112号4层401单元\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队/丰台分局\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('PgH9jYonW0MXkkVDaCz--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京日出东升物业服务有限公司\",\n\"companyType\":\"8\",\n\"legalName\":\" 班鑫克\",\n\"legalCardNumber\":\"110102196404243326\",\n\"legalPhone\":\" 18801281936\",\n\"chargeName\":\" 张致勇\",\n\"chargePhone\":\" 13146473829\",\n\"chargeCardNumber\":\" 342623196802021095\",\n\"creditCode\":\" 91110108318233955N\",\n\"recordPeronNum\":\" 10.0000000000\",\n\"address\":\"北京市海淀区中关村街道东升园公寓小区7号楼1层101室\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队/海淀分局\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('pusc3df26DcjB6cJTwC--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"深圳市万泽物业管理有限公司\",\n\"companyType\":\"8\",\n\"legalName\":\" 李旭升\",\n\"legalCardNumber\":\"440500196812300014\",\n\"legalPhone\":\" 18038135437\",\n\"chargeName\":\" 何建平\",\n\"chargePhone\":\" 15801468663\",\n\"chargeCardNumber\":\" 110108196010305764\",\n\"creditCode\":\" 91440300708435085W\",\n\"recordPeronNum\":\" 10.0000000000\",\n\"address\":\"深圳市福田区福强路2016号云顶翠峰二期8栋1楼\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队/海淀分局/恩济庄派出所\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('Q3KaSjBAwZuPGuI58uq--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京天天维他保健食品有限公司\",\n\"companyType\":\"4\",\n\"legalName\":\" 梁庆福\",\n\"legalCardNumber\":\"142433198101071018\",\n\"legalPhone\":\" 13501256616\",\n\"chargeName\":\" 王振先\",\n\"chargePhone\":\" 18801269131\",\n\"chargeCardNumber\":\" 110111197609086716\",\n\"creditCode\":\" 91110302700065913A\",\n\"recordPeronNum\":\" 3.0000000000\",\n\"address\":\"北京北京经济技术开发区宏达中路十二号\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队/大兴分局\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('QyS6VKamvaDn0qy7Xib--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京天人三和物业管理有限公司\",\n\"companyType\":\"8\",\n\"legalName\":\" 熬明洁\",\n\"legalCardNumber\":\"152123199105122721\",\n\"legalPhone\":\" 13283459892\",\n\"chargeName\":\" 张伏才\",\n\"chargePhone\":\" 18310428244\",\n\"chargeCardNumber\":\" 220202198606263931\",\n\"creditCode\":\" 91110101556840451W\",\n\"recordPeronNum\":\" 2.0000000000\",\n\"address\":\"北京市朝阳区惠新东街甲2号楼-3至25层101内16层1603A室\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队/昌平分局/松园派出所\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('QZTWAnF9aPzY4o8rKbm--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京天鸿宝地物业管理经营有限公司\",\n\"companyType\":\"8\",\n\"legalName\":\" 董贤钧\",\n\"legalCardNumber\":\"110102195206282338\",\n\"legalPhone\":\" 13701210800\",\n\"chargeName\":\" 管俊\",\n\"chargePhone\":\" 13520773163\",\n\"chargeCardNumber\":\" 140202199003095558\",\n\"creditCode\":\" 91110108101140088B\",\n\"recordPeronNum\":\" 86.0000000000\",\n\"address\":\"北京市海淀区万寿路甲1号恩济花园13号楼\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队/朝阳分局\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('rEvbyNajypD94mE50PE--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京丰一印象国际教育文化有限公司\",\n\"companyType\":\"4\",\n\"legalName\":\" 李迎春\",\n\"legalCardNumber\":\"110106197002062792\",\n\"legalPhone\":\" 13910920088\",\n\"chargeName\":\" 谭玥\",\n\"chargePhone\":\" 15810017498\",\n\"chargeCardNumber\":\" 110108198606281221\",\n\"creditCode\":\" 91110108MA00G05140\",\n\"recordPeronNum\":\" 4.0000000000\",\n\"address\":\"北京市朝阳区东三环南路19号院1号楼-2至15层101内五层A507号\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队/海淀分局\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('ShqgAgAwYv1FQGJSHRp--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"勤好（北京）物业管理有限公司\",\n\"companyType\":\"8\",\n\"legalName\":\" 刘凯敏\",\n\"legalCardNumber\":\"370721196606181020\",\n\"legalPhone\":\" 13681296887\",\n\"chargeName\":\" 刘源\",\n\"chargePhone\":\" 15010709675\",\n\"chargeCardNumber\":\" 411327199007050313\",\n\"creditCode\":\" 91110108760975329K\",\n\"recordPeronNum\":\" 0E-10\",\n\"address\":\"北京市通州区新华西街58号院2号楼9层919\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队/通州分局\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('sLIszUv21JUjZ02lRxd--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京怀柔王化幼儿园\",\n\"companyType\":\"4\",\n\"legalName\":\" 崔志敏\",\n\"legalCardNumber\":\"110227196306120923\",\n\"legalPhone\":\" 13716093676\",\n\"chargeName\":\" 马重杰\",\n\"chargePhone\":\" 18301169619\",\n\"chargeCardNumber\":\" 110227198611290098\",\n\"creditCode\":\" 521101163063593821\",\n\"recordPeronNum\":\" 3.0000000000\",\n\"address\":\"北京市怀柔区王化村35号\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队/怀柔分局/怀柔镇派出所\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('TLK_EST011229--__Cf9cHA3xWKgzDNL80xE', NULL, NULL, '{\"companyName\":\"神之盾保安集团有限公司\",\n\"legalName\":\" 姜吉奎\",\n\"legalCardNumber\":\"370923196411120619\",\n\"legalPhone\":\" 13693020776\",\n\"address\":\"北京市顺义区北务镇政府街9号-458\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队//大兴分局\"\n}', 1, 'TLK_EST011229--__Cf9cHA3xWKgzDNL80xE', '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('TLK_EST011254--__Cf9cHA3xWKgzDNL80xE', NULL, NULL, '{\"companyName\":\"北京银盾保安服务有限公司\",\n\"legalName\":\" 王守银\",\n\"legalCardNumber\":\"372927197107267677\",\n\"legalPhone\":\" 13911126788\",\n\"address\":\"北京市昌平区北七家镇曹碾村3号\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队//密云分局\"\n}', 1, 'TLK_EST011254--__Cf9cHA3xWKgzDNL80xE', '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('TLK_EST011256--__Cf9cHA3xWKgzDNL80xE', NULL, NULL, '{\"companyName\":\"北京金色五星保安服务有限责任公司\",\n\"legalName\":\" 王芳芳\",\n\"legalCardNumber\":\"110102197912091925\",\n\"legalPhone\":\" 13141031431\",\n\"address\":\"北京市东城区沙子口路70号13号楼5层509室\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队//延庆分局//八达岭派出所\"\n}', 1, 'TLK_EST011256--__Cf9cHA3xWKgzDNL80xE', '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('TLK_EST011257--__Cf9cHA3xWKgzDNL80xE', NULL, NULL, '{\"companyName\":\"北京振远特卫保安服务有限公司\",\n\"legalName\":\" 姚国元\",\n\"legalCardNumber\":\"340403196505182812\",\n\"legalPhone\":\" 13810324508\",\n\"address\":\"北京市通州区榆景东路6号院58号楼1层101\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队//平谷分局//东高村派出所\"\n}', 1, 'TLK_EST011257--__Cf9cHA3xWKgzDNL80xE', '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('TLK_EST011258--__Cf9cHA3xWKgzDNL80xE', NULL, NULL, '{\"companyName\":\"中安保安服务有限公司\",\n\"legalName\":\" 吴刚\",\n\"legalCardNumber\":\"412926197708100019\",\n\"legalPhone\":\" 15611192666\",\n\"address\":\"北京市西城区广安门大街305号荣丰嘉园C3座0732室\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队//大兴分局\"\n}', 1, 'TLK_EST011258--__Cf9cHA3xWKgzDNL80xE', '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('TLK_EST011261--__Cf9cHA3xWKgzDNL80xE', NULL, NULL, '{\"companyName\":\"特卫中天（北京）保安服务有限公司\",\n\"legalName\":\" 孙剑\",\n\"legalCardNumber\":\"370321197801203910\",\n\"legalPhone\":\" 13911210867\",\n\"address\":\"北京市朝阳区建外街道秀水街1号建外外交公寓17号楼特天商务中心\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队//密云分局//穆家峪派出所\"\n}', 1, 'TLK_EST011261--__Cf9cHA3xWKgzDNL80xE', '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('TLK_EST011264--__Cf9cHA3xWKgzDNL80xE', NULL, NULL, '{\"companyName\":\"中朗（北京）国际保安服务有限公司\",\n\"legalName\":\" 范忠文\",\n\"legalCardNumber\":\"110106196311084835\",\n\"legalPhone\":\" 13910681388\",\n\"address\":\"北京市通州区环宇东四路147号院1号楼2层101\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队//怀柔分局//桥梓派出所\"\n}', 1, 'TLK_EST011264--__Cf9cHA3xWKgzDNL80xE', '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('TLK_EST011265--__Cf9cHA3xWKgzDNL80xE', NULL, NULL, '{\"companyName\":\"蓝盾安保集团有限公司\",\n\"legalName\":\" 刘春征\",\n\"legalCardNumber\":\"110228197802033811\",\n\"legalPhone\":\" 13601017795\",\n\"address\":\"北京市顺义区通顺路后桥段39号\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队//大兴分局//榆垡派出所\"\n}', 1, 'TLK_EST011265--__Cf9cHA3xWKgzDNL80xE', '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('TLK_EST011268--__Cf9cHA3xWKgzDNL80xE', NULL, NULL, '{\"companyName\":\"北京军荣保安服务有限公司\",\n\"legalName\":\" 左长亮\",\n\"legalCardNumber\":\"230125198208303716\",\n\"legalPhone\":\" 15210980888\",\n\"address\":\"北京军荣保安服务有限公司\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队//通州分局//梨园派出所\"\n}', 1, 'TLK_EST011268--__Cf9cHA3xWKgzDNL80xE', '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('TLK_EST011271--__Cf9cHA3xWKgzDNL80xE', NULL, NULL, '{\"companyName\":\"北京军荣保安服务有限公司\",\n\"legalName\":\" 左长亮\",\n\"legalCardNumber\":\"230125198208303716\",\n\"legalPhone\":\" 15210980888\",\n\"address\":\"北京市昌平区回龙观镇金燕龙大厦8层12\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队//丰台分局//樊家村派出所\"\n}', 1, 'TLK_EST011271--__Cf9cHA3xWKgzDNL80xE', '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('TLK_EST011273--__Cf9cHA3xWKgzDNL80xE', NULL, NULL, '{\"companyName\":\"北京蓝海保安服务有限责任公司\",\n\"legalName\":\" 骆丹\",\n\"legalCardNumber\":\"430602198103219710\",\n\"legalPhone\":\" 13811325375\",\n\"address\":\"北京市顺义区林河南大街9号院9号楼1至6层01内6层633室\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队//顺义分局//仁和派出所\"\n}', 1, 'TLK_EST011273--__Cf9cHA3xWKgzDNL80xE', '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('TLK_EST011278--__Cf9cHA3xWKgzDNL80xE', NULL, NULL, '{\"companyName\":\"北京京卫圣明保安服务有限公司\",\n\"legalName\":\" 刘文杰\",\n\"legalCardNumber\":\"11010219610626193X\",\n\"legalPhone\":\" 13901199032\",\n\"address\":\"北京市昌平区北七家镇平西府村70号（供销社）5幢511号\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队//昌平分局//昌平派出所\"\n}', 1, 'TLK_EST011278--__Cf9cHA3xWKgzDNL80xE', '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('TLK_REC0111558--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京市密云区乐巢幼儿园\",\n\"companyType\":\"9\",\n\"legalName\":\" 毛梓宸\",\n\"legalCardNumber\":\"110228199502220016\",\n\"legalPhone\":\" 13901312057\",\n\"chargeName\":\" 张建辉\",\n\"chargePhone\":\" 13426343859\",\n\"chargeCardNumber\":\" 110228197412050026\",\n\"creditCode\":\" 52110118MJ0389641B\",\n\"recordPeronNum\":\" 6.0000000000\",\n\"address\":\"北京市密云区十里堡镇双井村东\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队//密云分局//十里堡派出所\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('TLK_REC0111690--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京市通州区金宝幼儿园\",\n\"companyType\":\"4\",\n\"legalName\":\" 车立东\",\n\"legalCardNumber\":\"110223197103124966\",\n\"legalPhone\":\" 13810986937\",\n\"chargeName\":\" 刘蕊\",\n\"chargePhone\":\" 13811114949\",\n\"chargeCardNumber\":\" 110105198111197547\",\n\"creditCode\":\" 5211011208054498XF\",\n\"recordPeronNum\":\" 2.0000000000\",\n\"address\":\"运河东堤东侧运潮减河南侧交汇处8号楼、11号楼、芙蓉园515号楼\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队//通州分局//新华派出所\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('TLK_REC0111698--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京市通州区爱为·常春藤幼儿园\",\n\"companyType\":\"4\",\n\"legalName\":\" 杨剑平\",\n\"legalCardNumber\":\"220502196807010428\",\n\"legalPhone\":\" 13661187111\",\n\"chargeName\":\" 张文标\",\n\"chargePhone\":\" 18501217085\",\n\"chargeCardNumber\":\" 130626198307030290\",\n\"creditCode\":\" 52110112MJ03186591\",\n\"recordPeronNum\":\" 6.0000000000\",\n\"address\":\"通州区运河东堤东侧运潮减河南侧交汇处22、23号楼\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队//通州分局//新华派出所\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('TLK_REC0111699--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京荣特科技发展有限公司\",\n\"companyType\":\"7,8\",\n\"legalName\":\" 段志刚\",\n\"legalCardNumber\":\"110107196412261235\",\n\"legalPhone\":\" 13910018591\",\n\"chargeName\":\" 夏士明\",\n\"chargePhone\":\" 13641027859\",\n\"chargeCardNumber\":\" 230303196402114314\",\n\"creditCode\":\" 91110107790659044J\",\n\"recordPeronNum\":\" 9.0000000000\",\n\"address\":\"北京市通州区马驹桥兴华大街11号\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队//通州分局//马驹桥派出所\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('TLK_REC0111706--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"龙湾（北京）物业服务有限公司\",\n\"companyType\":\"4\",\n\"legalName\":\" 陈海涛\",\n\"legalCardNumber\":\"350204195512072032\",\n\"legalPhone\":\" 13321187798\",\n\"chargeName\":\" 任凯\",\n\"chargePhone\":\" 13810932769\",\n\"chargeCardNumber\":\" 110222198311121610\",\n\"creditCode\":\" 91110113554805214U\",\n\"recordPeronNum\":\" 40.0000000000\",\n\"address\":\"北京市顺义区龙湾屯镇府前街13号\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队//顺义分局//后沙峪派出所\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('TLK_REC0111709--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京万达嘉华酒店管理有限公司银河嘉华酒店\",\n\"companyType\":\"4\",\n\"legalName\":\" 王石海\",\n\"legalCardNumber\":\"110221197209121613\",\n\"legalPhone\":\" 18618178877\",\n\"chargeName\":\" 王世杰\",\n\"chargePhone\":\" 13581671082\",\n\"chargeCardNumber\":\" 110102198212242352\",\n\"creditCode\":\" 91110107MA0185689N\",\n\"recordPeronNum\":\" 9.0000000000\",\n\"address\":\"北京石景山区石景山路甲18号1号楼\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队//石景山分局//鲁谷派出所\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('TLK_REC0111714--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"史达德药业（北京）有限公司\",\n\"companyType\":\"1,8\",\n\"legalName\":\" 卡森派特里克克罗恩\",\n\"legalCardNumber\":\"C4KNPYZ5\",\n\"legalPhone\":\" 13601110108\",\n\"chargeName\":\" 韩涛\",\n\"chargePhone\":\" 13601110108\",\n\"chargeCardNumber\":\" 110109198110070312\",\n\"creditCode\":\" 911102286337048331\",\n\"recordPeronNum\":\" 0E-10\",\n\"address\":\"北京市密云区经济开发区云腾路15号\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队//密云分局//十里堡派出所\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('TLK_REC0111715--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京金辰顺诚物业管理有限责任公司\",\n\"companyType\":\"4\",\n\"legalName\":\" 吴立华\",\n\"legalCardNumber\":\"130633198904135262\",\n\"legalPhone\":\" 13466313212\",\n\"chargeName\":\" 计林\",\n\"chargePhone\":\" 13911774376\",\n\"chargeCardNumber\":\" 110109198602250010\",\n\"creditCode\":\" 91110107091865738C\",\n\"recordPeronNum\":\" 1.0000000000\",\n\"address\":\"北京市石景山区八角东街25号院3号楼3层306\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队//石景山分局//八角派出所\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('TLK_REC0111731--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京龙海阁物业管理有限责任公司\",\n\"companyType\":\"8\",\n\"legalName\":\" 黄伟\",\n\"legalCardNumber\":\"110108197107218522\",\n\"legalPhone\":\" 13801312115\",\n\"chargeName\":\" 于洋\",\n\"chargePhone\":\" 13693625820\",\n\"chargeCardNumber\":\" 110106197906023059\",\n\"creditCode\":\" 91110105690827485P\",\n\"recordPeronNum\":\" 5.0000000000\",\n\"address\":\"北京市朝阳区朝阳公园西路15号二层\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队//朝阳分局//麦子店派出所\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('TLK_REC0111738--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京市石景山区育才双语幼儿园\",\n\"companyType\":\"4\",\n\"legalName\":\" 李贵智\",\n\"legalCardNumber\":\"132529197004284016\",\n\"legalPhone\":\" 18801265288\",\n\"chargeName\":\" 韩春霞\",\n\"chargePhone\":\" 18801289033\",\n\"chargeCardNumber\":\" 412828198206203626\",\n\"creditCode\":\" 52110107348417915X\",\n\"recordPeronNum\":\" 4.0000000000\",\n\"address\":\"北京市石景山区古城北路菜蔬锅炉房\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队//石景山分局//新古城派出所\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('TLK_REC0111742--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京市朝阳区向日葵艺术幼儿园\",\n\"companyType\":\"9\",\n\"legalName\":\" 崔雅静\",\n\"legalCardNumber\":\"110108197305175463\",\n\"legalPhone\":\" 13701008969\",\n\"chargeName\":\" 梁璐\",\n\"chargePhone\":\" 13681032120\",\n\"chargeCardNumber\":\" 110104198110021228\",\n\"creditCode\":\" 52110105741581615F\",\n\"recordPeronNum\":\" 3.0000000000\",\n\"address\":\"北京市通惠家园E-11楼\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队//朝阳分局\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('TLK_REC0111744--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京海德堡联合口腔诊所有限公司\",\n\"companyType\":\"8\",\n\"legalName\":\" 余冰洁\",\n\"legalCardNumber\":\"513101199008236022\",\n\"legalPhone\":\" 18513625827\",\n\"chargeName\":\" 马姗姗\",\n\"chargePhone\":\" 13464669877\",\n\"chargeCardNumber\":\" 210781199406281823\",\n\"creditCode\":\" 91110102MA005PDC30\",\n\"recordPeronNum\":\" 2.0000000000\",\n\"address\":\"北京市西城区西直门内大街130号4幢1层至2层\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队//西城分局\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('TLK_REC0111746--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京凯隆天颐宾馆有限公司\",\n\"companyType\":\"8\",\n\"legalName\":\" 程宏生\",\n\"legalCardNumber\":\"342822196902271635\",\n\"legalPhone\":\" 13391831007\",\n\"chargeName\":\" 王伟\",\n\"chargePhone\":\" 13810563759\",\n\"chargeCardNumber\":\" 110223197211041068\",\n\"creditCode\":\" 911101056757168591\",\n\"recordPeronNum\":\" 4.0000000000\",\n\"address\":\"北京市朝阳区仰山路4号\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队//朝阳分局//奥运村派出所\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('TLK_REC0111758--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京新宇创新科技有限公司\",\n\"companyType\":\"4\",\n\"legalName\":\" 安晋妍\",\n\"legalCardNumber\":\"140106198804151703\",\n\"legalPhone\":\" 18618129500\",\n\"chargeName\":\" 王彬\",\n\"chargePhone\":\" 13693353616\",\n\"chargeCardNumber\":\" 110103197010250313\",\n\"creditCode\":\" 911103026662871400\",\n\"recordPeronNum\":\" 6.0000000000\",\n\"address\":\"北京市北京经济技术开发区经海二路27号院1号楼402室\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队//大兴分局//博兴路派出所\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('TLK_REC0111760--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京天创华源物业管理有限公司\",\n\"companyType\":\"8\",\n\"legalName\":\" 刘剑锋\",\n\"legalCardNumber\":\"342225199502200555\",\n\"legalPhone\":\" 18510759988\",\n\"chargeName\":\" 刘剑锋\",\n\"chargePhone\":\" 18510759988\",\n\"chargeCardNumber\":\" 342225199502200555\",\n\"creditCode\":\" 91110107MA01F4KAXF\",\n\"recordPeronNum\":\" 0E-10\",\n\"address\":\"北京市丰台区郭公庄中街20号院4号楼\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队//丰台分局\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('TLK_REC0111762--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京中京苑医学科学研究院\",\n\"companyType\":\"7\",\n\"legalName\":\" 林志荣\",\n\"legalCardNumber\":\"350321197910166035\",\n\"legalPhone\":\" 13911896118\",\n\"chargeName\":\" 王玉芹\",\n\"chargePhone\":\" 18911555099\",\n\"chargeCardNumber\":\" 110101195106100529\",\n\"creditCode\":\" 91110105756729221x\",\n\"recordPeronNum\":\" 3.0000000000\",\n\"address\":\"北京市朝阳区西大望路甲27号\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队//朝阳分局//南磨房派出所\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('TLK_REC0111765--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京市门头沟区泷悦长安红黄蓝幼儿园\",\n\"companyType\":\"4\",\n\"legalName\":\" 李海红\",\n\"legalCardNumber\":\"13280119790523282x\",\n\"legalPhone\":\" 15811257700\",\n\"chargeName\":\" 崔会欣\",\n\"chargePhone\":\" 13261919531\",\n\"chargeCardNumber\":\" 232325198803181226\",\n\"creditCode\":\" 52110109MJ02997503\",\n\"recordPeronNum\":\" 2.0000000000\",\n\"address\":\"龙兴南一路6号院1号楼\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队//门头沟分局//永定派出所\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('TLK_REC0111766--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京中环智享科技有限公司\",\n\"companyType\":\"2\",\n\"legalName\":\" 于海洋\",\n\"legalCardNumber\":\"110228199803166447\",\n\"legalPhone\":\" 18911971930\",\n\"chargeName\":\" 赵海峰\",\n\"chargePhone\":\" 18911356265\",\n\"chargeCardNumber\":\" 130822199304011035\",\n\"creditCode\":\" 91110108MA004D2B7K\",\n\"recordPeronNum\":\" 6.0000000000\",\n\"address\":\"北京市密云区经济开发区水源西路27号-2号楼1层103\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队//密云分局//十里堡派出所\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('TLK_REC0111773--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京右安太熟悉酒楼有限公司\",\n\"companyType\":\"4\",\n\"legalName\":\" 许建\",\n\"legalCardNumber\":\"110105196008240077\",\n\"legalPhone\":\" 13366399966\",\n\"chargeName\":\" 董杨\",\n\"chargePhone\":\" 13366399966\",\n\"chargeCardNumber\":\" 110101197811050028\",\n\"creditCode\":\" 92110106L08132094R\",\n\"recordPeronNum\":\" 2.0000000000\",\n\"address\":\"北京市丰台区开阳里一区4号楼\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队//丰台分局//右安门派出所\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('TLK_REC0111780--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"中物联物业集团有限公司\",\n\"companyType\":\"4\",\n\"legalName\":\" 李鑫洋\",\n\"legalCardNumber\":\"140110199504026635\",\n\"legalPhone\":\" 18500976044\",\n\"chargeName\":\" 王学兵\",\n\"chargePhone\":\" 18811308551\",\n\"chargeCardNumber\":\" 370832199510247011\",\n\"creditCode\":\" 911100007839716031\",\n\"recordPeronNum\":\" 3.0000000000\",\n\"address\":\"北京市通州区嘉创路5号1号楼7层805\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队//通州分局//台湖派出所\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('TLK_REC0111784--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京五和博澳药业股份有限公司\",\n\"companyType\":\"4\",\n\"legalName\":\" 黄岳升\",\n\"legalCardNumber\":\"330323196404085739\",\n\"legalPhone\":\" 13901075798\",\n\"chargeName\":\" 金毅群\",\n\"chargePhone\":\" 13811427510\",\n\"chargeCardNumber\":\" 620111197102161027\",\n\"creditCode\":\" 91110115554855908J\",\n\"recordPeronNum\":\" 2.0000000000\",\n\"address\":\"北京市大兴区中关村科技园区大兴生物医药产业基地天富大街30号\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队//大兴分局//北臧村派出所\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('TLK_REC0111788--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京中邮信通物业管理有限责任公司\",\n\"companyType\":\"8\",\n\"legalName\":\" 祖德旗\",\n\"legalCardNumber\":\"110103195801180973\",\n\"legalPhone\":\" 13161070588\",\n\"chargeName\":\" 陈敬超\",\n\"chargePhone\":\" 18513146214\",\n\"chargeCardNumber\":\" 412726199005051335\",\n\"creditCode\":\" 91110108699646883E\",\n\"recordPeronNum\":\" 4.0000000000\",\n\"address\":\"北京海淀区西翠路12号1号楼201室\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队//海淀分局//西三旗派出所\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('TLK_REC0111791--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京荣民房地产开发有限公司\",\n\"companyType\":\"8\",\n\"legalName\":\" 徐生兰\",\n\"legalCardNumber\":\"612722195702092128\",\n\"legalPhone\":\" 13901278385\",\n\"chargeName\":\" 王清亮\",\n\"chargePhone\":\" 15201166462\",\n\"chargeCardNumber\":\" 13053119940104041X\",\n\"creditCode\":\" 91110115MA01G4TF36\",\n\"recordPeronNum\":\" 5.0000000000\",\n\"address\":\"北京市大兴区瀛海镇瀛顺路16号兴海大厦\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队//大兴分局//瀛海派出所\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('TLK_REC0111797--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京国信好望物业管理有限公司\",\n\"companyType\":\"8\",\n\"legalName\":\" 高燕峰\",\n\"legalCardNumber\":\"110101197706283532\",\n\"legalPhone\":\" 13701215809\",\n\"chargeName\":\" 张树海\",\n\"chargePhone\":\" 13811085639\",\n\"chargeCardNumber\":\" 150424198309104011\",\n\"creditCode\":\" 9111010910237146X9\",\n\"recordPeronNum\":\" 4.0000000000\",\n\"address\":\"北京市门头沟区滨河路115号滨河大厦7层724室\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队//门头沟分局//月季园派出所\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('TLK_REC0111802--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"世茂天成物业服务集团有限公司北京第二分公司\",\n\"companyType\":\"4\",\n\"legalName\":\" 闫佩伦\",\n\"legalCardNumber\":\"320721198209083611\",\n\"legalPhone\":\" 18669863536\",\n\"chargeName\":\" 路泽敬\",\n\"chargePhone\":\" 18731622266\",\n\"chargeCardNumber\":\" 13102519891022151X\",\n\"creditCode\":\" 911101110785516465\",\n\"recordPeronNum\":\" 11.0000000000\",\n\"address\":\"北京市房山区良乡拱辰北大街1号昊天假日酒店326\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队//大兴分局//瀛海派出所\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('TLK_REC0111803--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京金三江物业管理有限公司\",\n\"companyType\":\"8\",\n\"legalName\":\" 吴珊\",\n\"legalCardNumber\":\"512929196812300043\",\n\"legalPhone\":\" 18701505134\",\n\"chargeName\":\" 曹正勇\",\n\"chargePhone\":\" 13240333808\",\n\"chargeCardNumber\":\" 513423198302054051\",\n\"creditCode\":\" 91110105744707199U\",\n\"recordPeronNum\":\" 4.0000000000\",\n\"address\":\"朝阳区仰山路4号院\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队//朝阳分局//奥运村派出所\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('TLK_REC0111811--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京市首都公路发展集团有限公司京开高速公路管理分公司\",\n\"companyType\":\"3\",\n\"legalName\":\" 冯雷\",\n\"legalCardNumber\":\"210112197004080215\",\n\"legalPhone\":\" 13901223106\",\n\"chargeName\":\" 韩宇刚\",\n\"chargePhone\":\" 13901030903\",\n\"chargeCardNumber\":\" 110105197009085819\",\n\"creditCode\":\" 91110115746705867P\",\n\"recordPeronNum\":\" 102.0000000000\",\n\"address\":\"北京市大兴区京开高速公路西红门收费站内\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队//大兴分局\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('TLK_REC0111820--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京鹏成意达酒店管理有限公司\",\n\"companyType\":\"9\",\n\"legalName\":\" 王春城\",\n\"legalCardNumber\":\"131082197612014814\",\n\"legalPhone\":\" 13269554700\",\n\"chargeName\":\" 郭朋叶\",\n\"chargePhone\":\" 15233830867\",\n\"chargeCardNumber\":\" 130427199008016923\",\n\"creditCode\":\" 91110106MA01XXAK5X\",\n\"recordPeronNum\":\" 4.0000000000\",\n\"address\":\"北京市丰台区卢沟桥乡丰管路22号院南侧商业楼\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队//丰台分局//丰益派出所\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('TLK_REC0111828--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京百安佳盛物业管理有限公司\",\n\"companyType\":\"4\",\n\"legalName\":\" 伊京林\",\n\"legalCardNumber\":\"110102196705071521\",\n\"legalPhone\":\" 13601367506\",\n\"chargeName\":\" 伊京林\",\n\"chargePhone\":\" 13601367506\",\n\"chargeCardNumber\":\" 110102196705071521\",\n\"creditCode\":\" 91110112596054324K\",\n\"recordPeronNum\":\" 6.0000000000\",\n\"address\":\"北京市通州区宋庄镇小堡村委会东200米\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队//通州分局//宋庄派出所\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('TLK_REC0111844--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京永盛富伟物业管理有限公司\",\n\"companyType\":\"2\",\n\"legalName\":\" 彭学伟\",\n\"legalCardNumber\":\"11022119840411531X\",\n\"legalPhone\":\" 13810388378\",\n\"chargeName\":\" 彭学伟\",\n\"chargePhone\":\" 13810388378\",\n\"chargeCardNumber\":\" 11022119840411531X\",\n\"creditCode\":\" 91110114MA021G366A\",\n\"recordPeronNum\":\" 1.0000000000\",\n\"address\":\"北京市昌平区百善镇孟祖村114号\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队//昌平分局//百善派出所\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('TLK_REC0111845--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"保利物业服务股份有限公司北京分公司\",\n\"companyType\":\"2\",\n\"legalName\":\" 李家特\",\n\"legalCardNumber\":\"110108196609050112\",\n\"legalPhone\":\" 13521349985\",\n\"chargeName\":\" 吴俊利\",\n\"chargePhone\":\" 18201182685\",\n\"chargeCardNumber\":\" 130435198510262332\",\n\"creditCode\":\" 91110105306502820X\",\n\"recordPeronNum\":\" 23.0000000000\",\n\"address\":\"北京市朝阳区望京东园七区19号楼8层804室\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队//海淀分局//西三旗派出所\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('twN1JWGmTgDOUOet4KB--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京市通州区城市之光幼儿园\",\n\"companyType\":\"4\",\n\"legalName\":\" 徐亚闯\",\n\"legalCardNumber\":\"413026197906080954\",\n\"legalPhone\":\" 13910383246\",\n\"chargeName\":\" 刘茹雪\",\n\"chargePhone\":\" 18801378646\",\n\"chargeCardNumber\":\" 411303198210100085\",\n\"creditCode\":\" 52110112MJ031982XE\",\n\"recordPeronNum\":\" 2.0000000000\",\n\"address\":\"北京市通州区台湖镇东石东三路9号\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队/通州分局\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('TYwhPqZjIEBn7htNyKX--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京怀柔艺彩沄岚幼儿园\",\n\"companyType\":\"4\",\n\"legalName\":\" 任建伟\",\n\"legalCardNumber\":\"110227198212010036\",\n\"legalPhone\":\" 13581868281\",\n\"chargeName\":\" 任建伟\",\n\"chargePhone\":\" 13581868281\",\n\"chargeCardNumber\":\" 110227198212010036\",\n\"creditCode\":\" 52110116MJ03789183\",\n\"recordPeronNum\":\" 3.0000000000\",\n\"address\":\"怀柔区庙城镇293号院2号楼101-104\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队/怀柔分局\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('u9zwtupuAJMLl8FBo7c--__Cf9cHA3xWKgzDNL80xE', NULL, NULL, '{\"companyName\":\"北京震远保安服务有限公司\",\n\"legalName\":\" 刘国华\",\n\"legalCardNumber\":\"110229196810060870\",\n\"legalPhone\":\" 13701237237\",\n\"address\":\"北京市昌平区回龙观西大街118号1幢15层A1511\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队/昌平分局\"\n}', 1, 'u9zwtupuAJMLl8FBo7c--__Cf9cHA3xWKgzDNL80xE', '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('UGwlylZQHWYVE6Buje4--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京天鸿宝地物业管理经营有限公司\",\n\"companyType\":\"8\",\n\"legalName\":\" 董贤钧\",\n\"legalCardNumber\":\"110102195206282338\",\n\"legalPhone\":\" 13701210800\",\n\"chargeName\":\" 强蕊\",\n\"chargePhone\":\" 13691311296\",\n\"chargeCardNumber\":\" 110111197412311625\",\n\"creditCode\":\" 9111010810101140088B\",\n\"recordPeronNum\":\" 7.0000000000\",\n\"address\":\"北京市海淀区恩济花园13号楼五层\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队/房山分局\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('vPW6WSflL60q7jCP4is--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京铂颐都物业管理有限公司\",\n\"companyType\":\"8\",\n\"legalName\":\" 洪昌贵\",\n\"legalCardNumber\":\"420124194801082337\",\n\"legalPhone\":\" 13521632668\",\n\"chargeName\":\" 洪鑫\",\n\"chargePhone\":\" 15801635595\",\n\"chargeCardNumber\":\" 420124197803192330\",\n\"creditCode\":\" 91110400MA02B12L6A\",\n\"recordPeronNum\":\" 11.0000000000\",\n\"address\":\"北京市北京经济技术开发区荣华北路2号院10号楼10层1004 \",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队/大兴分局\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('VZPbmVJr4giS31BWvLo--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京市通州区银河湾幼儿园\",\n\"companyType\":\"9\",\n\"legalName\":\" 何家鹏\",\n\"legalCardNumber\":\"413026197404180912\",\n\"legalPhone\":\" 13911896118\",\n\"chargeName\":\" 王翠\",\n\"chargePhone\":\" 13439092455\",\n\"chargeCardNumber\":\" 13010319841203032X\",\n\"creditCode\":\" 52110112MJ0318923C\",\n\"recordPeronNum\":\" 4.0000000000\",\n\"address\":\"北京市通州区台湖镇海盛四街8号院1号楼\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队/通州分局\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('wJBf3q9cTWInbFbexe7--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京市通州区张家湾欣华幼儿园\",\n\"companyType\":\"9\",\n\"legalName\":\" 	 苏委珍\",\n\"legalCardNumber\":\"330329197907110046\",\n\"legalPhone\":\" 13681147931\",\n\"chargeName\":\" 苏委珍\",\n\"chargePhone\":\" 13681147931\",\n\"chargeCardNumber\":\" 330329197907110046\",\n\"creditCode\":\" 52110112MJ0319424A\",\n\"recordPeronNum\":\" 6.0000000000\",\n\"address\":\"北京市通州区张家湾镇张湾村北商业1号、2号\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队/通州分局\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('XckzbyI6cHf4qSQVbdl--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京恒洲物业管理有限公司\",\n\"companyType\":\"4\",\n\"legalName\":\" 董国松\",\n\"legalCardNumber\":\"371426198708302810\",\n\"legalPhone\":\" 13717509110\",\n\"chargeName\":\" 王培伦\",\n\"chargePhone\":\" 18613365210\",\n\"chargeCardNumber\":\" 131025199006104539\",\n\"creditCode\":\" 91110117MA01W53T2W\",\n\"recordPeronNum\":\" 5.0000000000\",\n\"address\":\"北京市平谷区平谷镇府前西街40号205室-20533\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队/海淀分局/田村派出所\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('XTNnY60qDVBWYEzfKMQ--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京市大兴区昂立东方红幼儿园\",\n\"companyType\":\"9\",\n\"legalName\":\" 孙毅\",\n\"legalCardNumber\":\"610602196312220018\",\n\"legalPhone\":\" 13193515856\",\n\"chargeName\":\" 李志刚\",\n\"chargePhone\":\" 18519335913\",\n\"chargeCardNumber\":\" 410522197505283813\",\n\"creditCode\":\" 52110115358996711E\",\n\"recordPeronNum\":\" 4.0000000000\",\n\"address\":\"大兴区旧宫镇旧头路31号\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队/大兴分局\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('yggamNXoDAVz3kPqPD4--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京首华嘉能物业管理有限公司\",\n\"companyType\":\"2\",\n\"legalName\":\" 夏光才\",\n\"legalCardNumber\":\"130533198510266416\",\n\"legalPhone\":\" 18910373855\",\n\"chargeName\":\" 许军\",\n\"chargePhone\":\" 13973152957\",\n\"chargeCardNumber\":\" 110106196311090119\",\n\"creditCode\":\" 91110108MAO1BLXH45\",\n\"recordPeronNum\":\" 3.0000000000\",\n\"address\":\"北京市海淀区花园东路30号花园饭店5号楼2层5203\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队/海淀分局/四季青派出所\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('yLtve4EV2tjT5H898oc--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京中经世纪科技园管理股份有限公司\",\n\"companyType\":\"7\",\n\"legalName\":\" 于惠娟\",\n\"legalCardNumber\":\"410204196811053043\",\n\"legalPhone\":\" 13601326708\",\n\"chargeName\":\" 周德璋\",\n\"chargePhone\":\" 13641388419\",\n\"chargeCardNumber\":\" 340521197404183333\",\n\"creditCode\":\" 911101086336508637\",\n\"recordPeronNum\":\" 7.0000000000\",\n\"address\":\"北京市海淀区西三环北路72号\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队/昌平分局\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('YQvGLW3CbceioRw8ypg--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京中筑物业管理有限公司\",\n\"companyType\":\"4\",\n\"legalName\":\" 卫小明\",\n\"legalCardNumber\":\"110107196510292713\",\n\"legalPhone\":\" 13911159660\",\n\"chargeName\":\" 孙艳波\",\n\"chargePhone\":\" 13683290015\",\n\"chargeCardNumber\":\" 130984197701262116\",\n\"creditCode\":\" 	 91110108101966592M\",\n\"recordPeronNum\":\" 10.0000000000\",\n\"address\":\"北京市海淀区彰化路138号院2号楼2层208房屋\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队/海淀分局\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('z72iAeSFO49qkPTwBCx--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"通辽泽信希望物业服务有限公司北京分公司\",\n\"companyType\":\"2\",\n\"legalName\":\" 刘宇\",\n\"legalCardNumber\":\"152301196809091571\",\n\"legalPhone\":\" 15804758000\",\n\"chargeName\":\" 张伟\",\n\"chargePhone\":\" 18519689096\",\n\"chargeCardNumber\":\" 13068419880215231X\",\n\"creditCode\":\" 91110106MA004FUD75\",\n\"recordPeronNum\":\" 11.0000000000\",\n\"address\":\"北京市丰台区星火路9号1幢三层358是(园区）\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队/丰台分局\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('ZfpC5bI7fzExxUHdHw1--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京市昌平区奕青音乐幼儿园\",\n\"companyType\":\"9\",\n\"legalName\":\" 刘培军\",\n\"legalCardNumber\":\"320924197911198318\",\n\"legalPhone\":\" 18910013661\",\n\"chargeName\":\" 刘培军\",\n\"chargePhone\":\" 18910013661\",\n\"chargeCardNumber\":\" 320924197911198318\",\n\"creditCode\":\" 521101146843541160\",\n\"recordPeronNum\":\" 3.0000000000\",\n\"address\":\"北京市昌平区天通北苑二区甲38号楼\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队/昌平分局\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('ZOeEvphg8G6Sl7FEkfQ--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"汇成华夏（北京）物业管理有限公司\",\n\"companyType\":\"8\",\n\"legalName\":\" 郑永新\",\n\"legalCardNumber\":\"110108196308173776\",\n\"legalPhone\":\" 13801013986\",\n\"chargeName\":\" 鲁晶\",\n\"chargePhone\":\" 18206113668\",\n\"chargeCardNumber\":\" 320421198007032510\",\n\"creditCode\":\" 91110108MA01XXWT9L\",\n\"recordPeronNum\":\" 0E-10\",\n\"address\":\"北京市昌平区南口镇东大街1号3层35号\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队/海淀分局/曙光派出所\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);
INSERT INTO `tenant_organization_requests` VALUES ('zOwEIBQjRTOyAArRuOG--__Kh9sHO1jncg49KqR2MN', NULL, NULL, '{\"companyName\":\"北京天鸿宝地物业管理经营有限公司\",\n\"companyType\":\"8\",\n\"legalName\":\" 董贤钧\",\n\"legalCardNumber\":\"110102195206282338\",\n\"legalPhone\":\" 13701210800\",\n\"chargeName\":\" 管俊\",\n\"chargePhone\":\" 13520773163\",\n\"chargeCardNumber\":\" 140202199003095558\",\n\"creditCode\":\" 91110108101140088B\",\n\"recordPeronNum\":\" 22.0000000000\",\n\"address\":\"北京市海淀区万寿路甲1号恩济花园13号楼\",\n\"officePoliceAddress\":\"北京市公安局治安管理总队保安管理支队/丰台分局\"\n}', 1, NULL, '2023-05-08 19:28:28', NULL, NULL, NULL);

SET FOREIGN_KEY_CHECKS = 1;
