package com.bcxin.shared.rest.web.apis.controllers.rbacs;

import com.bcxin.api.interfaces.rbacs.RbacRoleRpcProvider;
import com.bcxin.api.interfaces.rbacs.requests.CreateRoleRequest;
import com.bcxin.api.interfaces.rbacs.requests.UpdateRoleRequest;
import com.bcxin.api.interfaces.rbacs.responses.RoleDetailGetResponse;
import com.bcxin.api.interfaces.rbacs.responses.RoleGetResponse;
import com.bcxin.rest.web.commons.ControllerAbstract;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.Collection;

@RestController
@RequestMapping("/rbac/subjects/{subjectId}/roles")
public class RoleController extends ControllerAbstract {
    private final RbacRoleRpcProvider roleRpcProvider;

    public RoleController(RbacRoleRpcProvider roleRpcProvider) {
        this.roleRpcProvider = roleRpcProvider;
    }

    @PostMapping
    public ResponseEntity post(@PathVariable String subjectId, @RequestBody CreateRoleRequest request) {
        this.roleRpcProvider.create(subjectId, request);

        return this.ok();
    }

    @PutMapping("/{id}")
    public ResponseEntity put(@PathVariable String subjectId, @PathVariable String id, @RequestBody UpdateRoleRequest request) {
        this.roleRpcProvider.update(subjectId, id, request);

        return this.ok();
    }

    @DeleteMapping("/{id}")
    public ResponseEntity delete(@PathVariable String subjectId, @PathVariable String id) {
        this.roleRpcProvider.delete(subjectId, id);

        return this.ok();
    }

    @GetMapping
    public ResponseEntity get(@PathVariable String subjectId) {
        Collection<RoleGetResponse> roleGetResponses = this.roleRpcProvider.getAll(subjectId);

        return this.ok(roleGetResponses);
    }

    @GetMapping("/{id}")
    public ResponseEntity get(@PathVariable String subjectId,@PathVariable String id) {
        RoleDetailGetResponse roleDetailGetResponse = this.roleRpcProvider.getById(subjectId, id);

        return this.ok(roleDetailGetResponse);
    }
}
