package com.bcxin.shared.rest.web.apis.controllers.rbacs;

import com.bcxin.api.interfaces.rbacs.RbacCategoryRpcProvider;
import com.bcxin.api.interfaces.rbacs.requests.BatchCategoryResourceRequest;
import com.bcxin.api.interfaces.rbacs.requests.CategoryRequest;
import com.bcxin.api.interfaces.rbacs.responses.CategoryGetResponse;
import com.bcxin.rest.web.commons.ControllerAbstract;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.Collection;

@RestController
@RequestMapping("/rbac/categories")
public class CategoryController extends ControllerAbstract {

    private final RbacCategoryRpcProvider categoryRpcProvider;

    public CategoryController(RbacCategoryRpcProvider categoryRpcProvider) {
        this.categoryRpcProvider = categoryRpcProvider;
    }

    @PostMapping
    public ResponseEntity post(@RequestBody CategoryRequest request) {
        this.categoryRpcProvider.create(request);

        return this.ok();
    }

    @PutMapping("/{id}")
    public ResponseEntity put(@PathVariable String id,
                              @RequestBody CategoryRequest request) {
        this.categoryRpcProvider.update(id, request);

        return this.ok();
    }

    @DeleteMapping("/{id}")
    public ResponseEntity delete(@PathVariable String id) {
        this.categoryRpcProvider.delete(id);

        return this.ok();
    }

    @GetMapping
    public ResponseEntity get() {
        Collection<CategoryGetResponse> responses = this.categoryRpcProvider.getAll();

        return this.ok(responses);
    }

    @PostMapping("/batch-categories-resources")
    public ResponseEntity batchCategoryResource(@RequestBody BatchCategoryResourceRequest request) {
        this.categoryRpcProvider.batch(request);

        return this.get();
    }
}
