package com.bcxin.api.interfaces.tenants.responses;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Date;

/**
 * @author huangdunye
 * 2023/5/8 17:47
 */
@Getter
@Setter
public class TenantOrganizationResponse implements Serializable {
    /**
     * 主键
     */
    @ApiModelProperty(value = "id")
    private String id;
    /**
     * 行业类型
     */
    @ApiModelProperty(value = "行业类型")
    private String industryCode;
    /**
     * 机构类型
     */
    @ApiModelProperty(value = "机构类型")
    private String institutionalCode ;
    /**
     * 内网许可审批的请求内容
     */
    @ApiModelProperty(value = "内网许可审批的请求内容")
    private TenantCompanyResponse content;
    /**
     * 审批状态
     */
    @ApiModelProperty(value = "审批状态")
    private Integer status;
    /**
     * 系统生成的注册编码 created_time
     */
    @ApiModelProperty(value = "number")
    private String number;

    /**
     * 创建时间
     */

    private Date createdTime;

    /**
     * 注册成功之后引用tenant_organizations.id
     */

    private String referenceId ;

}
