package com.bcxin.api.interfaces.tenants.responses;

import com.bcxin.Infrastructures.enums.InviteType;
import com.bcxin.Infrastructures.enums.RelationshipsStatus;
import com.bcxin.api.interfaces.ResponseAbstract;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.Getter;

import java.util.Collection;
@ApiModel(value = "组织架构")
@Getter
public class OrganizationStructureResponse extends ResponseAbstract {
    @ApiModelProperty(value ="id")
    private final long id;
    @ApiModelProperty(value ="组织id")
    private final String selectedOrganizationId;
    @ApiModelProperty(value ="组织名称")
    private final String selectedOrganizationName;
    @ApiModelProperty(value = "组织备注")
    private final String selectedOrganizationNote;
    @ApiModelProperty(value = "组织编码")
    private final String code;
    @ApiModelProperty(value = "联系人姓名")
    private final String contactName;
    @ApiModelProperty(value = "联系人电话")
    private final String contactTelephone;
    @ApiModelProperty(value = "组织类型")
    private OrganizationTypeResponse organizationType;
    @ApiModelProperty(value = "组织关系状态")
    private final RelationshipsStatus status;
    @ApiModelProperty(value = "集团id")
    private final String organizationId;
    @ApiModelProperty(value = "邀请类型")
    private final InviteType inviteType;
    @ApiModelProperty(value = "组织统计信息")
    private final OrganizationStatisticsResponse statistics;
    @ApiModelProperty(value = "下级组织列表")
    private Collection<OrganizationStructureResponse> children;

    private OrganizationStructureResponse(long id,
                                         String selectedOrganizationId,
                                         String selectedOrganizationName,
                                         String selectedOrganizationNote,
                                         String code,
                                         String contactName,
                                         String contactTelephone,
                                         OrganizationTypeResponse organizationType,
                                         RelationshipsStatus status,
                                         String organizationId,
                                         InviteType inviteType,
                                         OrganizationStatisticsResponse statistics,
                                         Collection<OrganizationStructureResponse> children) {
        this.id = id;
        this.selectedOrganizationId = selectedOrganizationId;
        this.selectedOrganizationName = selectedOrganizationName;
        this.selectedOrganizationNote = selectedOrganizationNote;
        this.code = code;
        this.contactName = contactName;
        this.contactTelephone = contactTelephone;
        this.organizationType = organizationType;
        this.status = status;
        this.organizationId = organizationId;
        this.inviteType = inviteType;
        this.statistics = statistics;
        this.children = children;
    }

    public static OrganizationStructureResponse create(long id,
                                                       String selectedOrganizationId,
                                                       String selectedOrganizationName,
                                                       String selectedOrganizationNote,
                                                       String code,
                                                       String contactName,
                                                       String contactTelephone,
                                                       OrganizationTypeResponse organizationType,
                                                       RelationshipsStatus status,
                                                       String organizationId,
                                                       InviteType inviteType,
                                                       OrganizationStatisticsResponse statistics,
                                                       Collection<OrganizationStructureResponse> children) {
        return new OrganizationStructureResponse(id,
                selectedOrganizationId,
                selectedOrganizationName,
                selectedOrganizationNote,
                code,
                contactName,
                contactTelephone,
                organizationType,
                status,
                organizationId,
                inviteType,
                statistics,
                children);
    }

    @ApiModel("组织类型信息")
    @Data
    public static class OrganizationTypeResponse extends ResponseAbstract{
        @ApiModelProperty(value = "组织类型ID")
        private final Long organizationTypeId;
        @ApiModelProperty(value = "组织类型名称")
        private final String organizationTypeName;
        @ApiModelProperty(value = "组织类型备注")
        private final String organizationTypeNote;

        private OrganizationTypeResponse(Long organizationTypeId, String organizationTypeName, String organizationTypeNote) {
            this.organizationTypeId = organizationTypeId;
            this.organizationTypeName = organizationTypeName;
            this.organizationTypeNote = organizationTypeNote;
        }

        public static OrganizationTypeResponse create(Long organizationTypeId, String organizationTypeName, String organizationTypeNote) {
            return new OrganizationTypeResponse(organizationTypeId,organizationTypeName,organizationTypeNote);
        }
    }

    @ApiModel("组织统计信息")
    @Data
    public static class OrganizationStatisticsResponse extends  ResponseAbstract{
        @ApiModelProperty(value = "组织id")
        private final String id;
        @ApiModelProperty(value = "组织社会统一信用代码")
        private final String unifySocialCreditCode;
        @ApiModelProperty(value = "员工数量")
        private final int countOfMembers;

        private OrganizationStatisticsResponse(String id, String unifySocialCreditCode, int countOfMembers) {
            this.id = id;
            this.unifySocialCreditCode = unifySocialCreditCode;
            this.countOfMembers = countOfMembers;
        }

        public static OrganizationStatisticsResponse create(String id, String unifySocialCreditCode, int countOfMembers) {
            return new OrganizationStatisticsResponse(id,unifySocialCreditCode,countOfMembers);
        }
    }
}
