package com.bcxin.api.interfaces.tenants.responses;

import cn.hutool.core.date.DateUnit;
import cn.hutool.core.util.IdcardUtil;
import com.bcxin.Infrastructures.entities.OperatorValueType;
import com.bcxin.Infrastructures.enums.*;
import com.bcxin.Infrastructures.utils.DateUtil;
import com.bcxin.api.interfaces.ResponseAbstract;
import lombok.Getter;

import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Date;

@Getter
public class EmployeeGetResponse extends ResponseAbstract {
    private final String id;
    //姓名
    private final String name;
    //手机号码
    private final String telephone;
    private final String departId;
    //部门
    private final String departName;
    //是否部门主管
    private final Boolean departLeader;
    //组织名称
    private final String organName;
    //证件类型
    private String credentialType;
    //证件号码
    private final String credentialNumber;
    //证件核验
    private String checkedStatus;
    //职业类型
    private String occupationType;
    //实名认证
    private String authenticatedStatus;
    //入职时间
    private final Date hiredDate;
    //是否持资格证：是/否，判断用户的证书信息是否有“保安资格证”类型的证书信息； 1持证 0未持证
    private final String cerStatus;
    //是否签订合同：是/否，判断用户的合同信息是否有有效的记录 1签订 0未签订
    private final String contractStatus;
    //是否持等级证
    private String gradeCerStatus;

    //职位
    private final String position;
    //实名备注
    private final String authenticatedResult;
    //性别
    private String sex;
    //出生日期
    private final Date birthdate;
    //年龄
    private Integer age;
    //民族
    private final String nation;
    //文化程度、
    private final String education;
    //政治面貌
    private final String politicsStatus;
    //户籍类型
    private final String householdType;
    //兵役情况
    private final String militaryStatus;
    //籍贯
    private final String nativePlace;
    //婚姻状况
    private final String maritalStatus;
    //身高（CM）
    private final String stature;
    //紧急联系人姓名
    private final String emergencyContact;
    //紧急联系人电话
    private final String emergencyPhone;
    //驾照等级
    private final String licenseLevel;
    //是否投保
    private String insure;
    //保安资格证号
    private final String cerNo;
    // 司龄
    private final long workDays;
    // 上级、
    private final String superiorName;

    //合同到期时间
    private Date contractValidDateTo;

    // 转正日期、
    @Temporal(TemporalType.DATE)
    private Date positiveDate;
    // 身份证有效期 开始时间、
    private Date validDateFrom;
    // 身份证有效期 结束时间、
    private Date validDateTo;
    // 身份证住址、
    private String address;
    // 录入系统时间（用户创建时间）、
    private Date createdTime;
    // 上一次核验时间、
    private Date lastCheckedStatusTime;
    // 是否为组织管理员、
    private String domainAdmin;
    // 是否为部门管理员、
    private String departAdmin;
    // 可管理部门
    private String manageDeparts;

    private OperatorValueType operator;
    
    private String operatorName;

    private String operatorTime;

    /**
     * 员工状态
     */
    private String personStatus;

    /**
     * 试用期 数字
     */
    private String probation;

    /**
     * 原定转正日期
     */
    private String planPositiveDate;

    /**
     * 现住地址
     */
    private String placeOfNow;

    /**
     * 等级证等级
     */
    private String gradeLevel;
    /**
     * 等级证编号
     */
    private String gradeCerNo;

    /**
     * 测评结果
     */
    private String xlcpResult;

    /**
     * 结果规则提示 如：25~55区间为无倾向；55~65区间为轻度...
     */
    private String xlcpResultRuleTip;
    /**
     * 测评结果附件
     */
    private String xlcpFileUrl;

    private String backgroundScreeningStatus;


    public EmployeeGetResponse(String organName,String id, String name, String telephone, String departId,String departName,
                               Boolean departLeader, CredentialType credentialType, String credentialNumber,
                               UserCheckedStatus checkedStatus, OccupationType occupationType,
                               RealNameAuthenticatedStatus authenticatedStatus, Date hiredDate,
                               boolean cerStatus,boolean contractStatus,boolean gradeCerStatus,
                               String gradeLevel,String gradeCerNo,
                               String position,String authenticatedResult,Sex sex,Date birthdate,String nation,
                               String education,String politicsStatus,String householdType,String militaryStatus,
                               String nativePlace,String maritalStatus,String stature,String emergencyContact,
                               String emergencyPhone,String licenseLevel,BackgroundScreeningStatus backgroundScreeningStatus,TrueFalseStatus insure,String cerNo,
                               String superiorName,Date contractValidDateTo,
                               Date positiveDate,
                               Date validDateFrom,
                               Date validDateTo,
                               String address,
                               Date createdTime,
                               TrueFalseStatus domainAdmin,
                               TrueFalseStatus departAdmin,
                               String manageDeparts,
                               String personStatus,
                               String probation,
                               String planPositiveDate,
                               String placeOfNow,
                               OperatorValueType operator,
                               Date lastCheckedStatusTime,String xlcpResult,String xlcpResultRuleTip,String xlcpFileUrl
                               ) {
        this.organName = organName;
        this.id = id;
        this.name = name;
        this.telephone = telephone;
        this.departId = departId;
        this.departName = departName;
        this.departLeader = departLeader;
        this.operator = operator;
        if(operator != null){
            operatorName = operator.getName();
            operatorTime = operator.getOperatorTime();
        }
        if(credentialType != null) {
            this.credentialType = credentialType.getTypeName();
        }
        this.credentialNumber = credentialNumber;
        if(checkedStatus != null) {
            this.checkedStatus = checkedStatus.getTypeName();
        }
        if(occupationType != null) {
            this.occupationType = occupationType.getTypeName();
        }
        if(authenticatedStatus != null) {
            this.authenticatedStatus = authenticatedStatus.getTypeName();
        }
        this.hiredDate = hiredDate;
        if(cerStatus){
            this.cerStatus = TrueFalseStatus.True.getTypeName();
        }else{
            this.cerStatus = TrueFalseStatus.False.getTypeName();
        }
        if(gradeCerStatus){
            this.gradeCerStatus = TrueFalseStatus.True.getTypeName();
        }else{
            this.gradeCerStatus = TrueFalseStatus.False.getTypeName();
        }
        if(contractStatus){
            this.contractStatus = TrueFalseStatus.True.getTypeName();
        }else{
            this.contractStatus = TrueFalseStatus.False.getTypeName();
        }

        this.position = position;
        this.authenticatedResult = authenticatedResult;
        if(sex != null) {
            this.sex = sex.getTypeName();
        }
        this.birthdate = birthdate;
        this.nation = nation;
        this.education = education;
        this.politicsStatus = politicsStatus;
        this.householdType = householdType;
        this.militaryStatus = militaryStatus;
        this.nativePlace = nativePlace;
        this.maritalStatus = maritalStatus;
        this.stature = stature;
        this.emergencyContact = emergencyContact;
        this.emergencyPhone = emergencyPhone;
        this.licenseLevel = licenseLevel;
        if(backgroundScreeningStatus == BackgroundScreeningStatus.Init){
            this.backgroundScreeningStatus =BackgroundScreeningStatus.Init.getTypeName();
        }else if(backgroundScreeningStatus == BackgroundScreeningStatus.Good){
            this.backgroundScreeningStatus = BackgroundScreeningStatus.Good.getTypeName();
        }else if(backgroundScreeningStatus == BackgroundScreeningStatus.Illegal){
            this.backgroundScreeningStatus = BackgroundScreeningStatus.Illegal.getTypeName();
        }
        if(insure != null) {
            this.insure = insure.getTypeName();
        }else{
            this.insure = TrueFalseStatus.False.getTypeName();
        }
        this.cerNo = cerNo;
        this.gradeLevel = gradeLevel;
        this.gradeCerNo = gradeCerNo;
        if (hiredDate != null) {
            this.workDays = cn.hutool.core.date.DateUtil.between(hiredDate, Timestamp.from(Instant.now()), DateUnit.DAY);
        } else {
            this.workDays = 0;
        }

        this.superiorName = superiorName;
        this.contractValidDateTo = contractValidDateTo;

        this.positiveDate = positiveDate;
        this.validDateFrom = validDateFrom;
        this.validDateTo = validDateTo;
        this.address = address;
        this.createdTime = createdTime;

        if(domainAdmin != null) {
            this.domainAdmin = domainAdmin.getTypeName();
        }
        if(departAdmin != null) {
            this.departAdmin = departAdmin.getTypeName();
        }
        this.manageDeparts = manageDeparts;

        if(birthdate != null) {
            age = cn.hutool.core.date.DateUtil.ageOfNow(birthdate);
        }

        this.personStatus = personStatus;
        this.probation = probation;
        this.planPositiveDate = planPositiveDate;
        this.placeOfNow = placeOfNow;
        this.lastCheckedStatusTime = lastCheckedStatusTime;
        this.xlcpResult = xlcpResult;
        this.xlcpResultRuleTip = xlcpResultRuleTip;
        this.xlcpFileUrl = xlcpFileUrl;
    }

    public String getHiredDateText() {
        return DateUtil.format2ShortDate(this.getHiredDate());
    }

    public static EmployeeGetResponse create(String organName,String id, String name, String telephone, String departId, String departName,
                                             Boolean departLeader, CredentialType credentialType, String credentialNumber,
                                             UserCheckedStatus checkedStatus, OccupationType occupationType,
                                             RealNameAuthenticatedStatus authenticatedStatus, Date hiredDate,
                                             boolean cerStatus,boolean contractStatus,boolean gradeCerStatus,
                                             String gradeLevel,String gradeCerNo,
                                             String position,String authenticatedResult,Sex sex,Date birthdate,String nation,
                                             String education,String politicsStatus,String householdType,String militaryStatus,
                                             String nativePlace,String maritalStatus,String stature,String emergencyContact,
                                             String emergencyPhone,String licenseLevel,BackgroundScreeningStatus backgroundScreeningStatus,TrueFalseStatus insure,String cerNo,String superiorName,
                                             Date contractValidDateTo,
                                             Date positiveDate,
                                             Date validDateFrom,
                                             Date validDateTo,
                                             String address,
                                             Date createdTime,
                                             TrueFalseStatus domainAdmin,
                                             TrueFalseStatus departAdmin,
                                             String manageDeparts,
                                             String personStatus,
                                             String probation,
                                             String planPositiveDate,
                                             String placeOfNow,
                                             OperatorValueType operator,
                                             Date lastCheckedStatusTime,String xlcpResult,String xlcpResultRuleTip,String xlcpFileUrl) {
        return new EmployeeGetResponse(organName,id, name, telephone,departId, departName, departLeader, credentialType, credentialNumber, checkedStatus,
                occupationType, authenticatedStatus, hiredDate,cerStatus,contractStatus,gradeCerStatus,
                gradeLevel,gradeCerNo,
                position,authenticatedResult,sex,birthdate,nation,
                education,politicsStatus,householdType,militaryStatus,
                nativePlace,maritalStatus,stature,emergencyContact,
                emergencyPhone,licenseLevel, backgroundScreeningStatus,insure,cerNo,superiorName,contractValidDateTo,
                positiveDate,validDateFrom,validDateTo,address,createdTime,domainAdmin,
                departAdmin,manageDeparts,
                personStatus,
                probation,
                planPositiveDate,
                placeOfNow,operator,lastCheckedStatusTime,xlcpResult,xlcpResultRuleTip,xlcpFileUrl);
    }


    /*

    public String getOccupationTypeText() {
        if(this.getOccupationType()==null) {
            return null;
        }

        switch (this.getOccupationType()) {
            case Normal:
                return "一般职员";
            case SecurityGuard:
                return "保安员";
            case Police:
                return "警员";

        }

        return this.getOccupationType().name();
    }


    public String getCredentialTypeText() {
        if (this.getCredentialTypeText() == null) {
            return null;
        }

        switch (this.getCredentialType()) {
            case IdCard:
                return "居民身份证（户口簿）";
            case IdCardOfXiangGang:
                return "香港特区护照/身份证";
            case IdCardOfAoMen:
                return "澳门特区护照/身份证明";
            case IdCardOfTaiwan:
                return "台湾居民来往大陆通行证";
            case Passport:
                return "外国护照";
            case Arms:
                return "退伍军人证";
            case PoliceNo:
                return "警号";
        }

        return this.getOccupationType().name();
    }
     */
}
