package com.bcxin.api.interfaces.tenants.responses;

import cn.hutool.core.util.StrUtil;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class CompanyCredentialResponse implements Serializable {

        /**
         * 公司名称
         */
        private String comName;

        /**
         * 法人
         */
        private String legalPerson;

        /**
         * 办公电话
         */
        private String tel;

        /**
         * 注册资金（万元）
         */
        private String registeredMoney;
        /**
         * 许可证号
         */
        private String cerNo;
        /**
         * 注册地址
         */
        private String address;
        /**
         * 办公地址
         */
        private String location;

        /**
         * 发证日期
         */
        private Date cerDate;

        /**
         * 服务范围
         */
        private String securityScopeType;

        public CompanyCredentialResponse(){}

        public CompanyCredentialResponse(String comName,
                                         String legalPerson,
                                         String tel,
                                         String registeredMoney,
                                         String cerNo,
                                         String address,
                                         String location,
                                         Date cerDate,
                                         String securityScopeType){

                this.comName = comName;
                this.legalPerson = legalPerson;
                this.tel = tel;
                this.registeredMoney = registeredMoney;
                this.cerNo = cerNo;
                this.address = address;
                this.location = location;
                this.cerDate = cerDate;
                this.securityScopeType = StrUtil.isEmpty(securityScopeType) ? null : securityScopeType.replace("01","门卫")
                        .replace("02","巡逻")
                        .replace("03","守护")
                        .replace("04","押运")
                        .replace("05","随身护卫")
                        .replace("06","安全检查")
                        .replace("07","区域秩序维护")
                        .replace("08","安全风险评估")
                        .replace("09","安全技术防范")
                        .replace("10","其他")
                        .replace(";",",");
        }


        public static CompanyCredentialResponse create(String comName,
                                                       String legalPerson,
                                                       String tel,
                                                       String registeredMoney,
                                                       String cerNo,
                                                       String address,
                                                       String location,
                                                       Date cerDate,
                                                       String securityScopeType){
                return new CompanyCredentialResponse(comName,
                        legalPerson,
                        tel,
                        registeredMoney,
                        cerNo,
                        address,
                        location,
                        cerDate,
                        securityScopeType);
        }

}
