package com.bcxin.api.interfaces.commons;

import com.bcxin.Infrastructures.Pageable;
import com.bcxin.api.interfaces.tenants.requests.operatelog.SearchOperateLogRequest;
import com.bcxin.api.interfaces.tenants.responses.OperateLogResponse;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Component;

/**
 * description：操作日志表
 * author：linchunpeng
 * date：2023/12/13
 */
@Component
public interface OperateLogRpcProvider {

    /**
     * description：记录登出日志
     * author：linchunpeng
     * date：2023/12/13
     */
    void loginLog(String tenantUserId, String userName, String realName, String ipAddress);

    /**
     * description：记录登出日志
     * author：linchunpeng
     * date：2023/12/13
     */
    void logoutLog(String tenantUserId, String userName, String ipAddress);

    /**
     * description：分页查询操作日志
     * author：linchunpeng
     * date：2023/12/14
     */
    Pageable<OperateLogResponse> getList(SearchOperateLogRequest request, String orgId);
}
