package com.bcxin.common.apis.filter;

import cn.hutool.core.util.StrUtil;
import cn.myapps.common.controller.Resource;
import com.bcxin.runtime.approve.utils.JwtUtil;
import com.fasterxml.jackson.databind.ObjectMapper;

import javax.servlet.*;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;

public final class DynamicDataFilter extends HttpServlet implements Filter {

    private static final long serialVersionUID = 4540909316344106991L;

    @Override
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest) servletRequest;
        HttpServletResponse response = (HttpServletResponse) servletResponse;
        response.setCharacterEncoding("utf-8");
        String accessToken = request.getHeader("x-token");

        if (StrUtil.isNotEmpty(accessToken)) {
            accessToken = JwtUtil.getDomainIdFromToken(accessToken);
            request.setAttribute("domainId", accessToken);
            Map<String, Object> paramter = new HashMap<String, Object>();
            paramter.put("domainId", accessToken);
            ParameterRequestWrapper wrapper = new ParameterRequestWrapper(request, paramter);
            filterChain.doFilter(wrapper, response);
            return;
        }else{
            Resource result = new Resource(500,"accessToken缺失");
            ObjectMapper mapper = new ObjectMapper();
            PrintWriter out = response.getWriter();
            out.print(mapper.writeValueAsString(result));
            out.close();
            return;
        }
    }

    @Override
    public void init(FilterConfig arg0) throws ServletException {

    }

}

