package com.bcxin.common.apis;

import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;

@SpringBootApplication
@ComponentScan(basePackages = {"com.bcxin.sync.apis" , "com.bcxin.runtime.approve" , "com.bcxin.common.apis" , "cn.myapps.common" , "com.bcxin.web.commons.components"})
@EnableWebMvc
@EnableFeignClients
public class SaasCommonApis {
    public static void main(String[] args) {
        SpringApplication springApplication = new SpringApplication(SaasCommonApis.class);
        springApplication.setAllowCircularReferences(Boolean.TRUE);
        springApplication.run(args);
    }
}
